/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils.location;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Location;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import com.merseyside.utils.PermissionManagerKt;
import com.merseyside.utils.location.LocationBroadcastReceiver;
import com.merseyside.utils.location.LocationManager;
import com.merseyside.utils.location.LocationUpdatesService;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.ExperimentalCoroutinesApi;
import kotlinx.coroutines.channels.ProduceKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\r\u001a\u00020\u000eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0011\u0010\u0010\u001a\u00020\u000eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012H\u0017J\b\u0010\u0013\u001a\u00020\u000bH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0007J\b\u0010\u0016\u001a\u00020\u0015H\u0007J\b\u0010\u0017\u001a\u00020\u0015H\u0002J\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u001dJ\u000e\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u001dJ\u000e\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u001dJ\b\u0010$\u001a\u00020\u0015H\u0002J\b\u0010%\u001a\u00020\u0015H\u0002J\b\u0010&\u001a\u00020\u0015H\u0002J\b\u0010'\u001a\u00020\u0015H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006("}, d2={"Lcom/merseyside/utils/location/LocationManagerImpl;", "Lcom/merseyside/utils/location/LocationManager;", "Landroidx/lifecycle/LifecycleObserver;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "broadcastReceiver", "Lcom/merseyside/utils/location/LocationBroadcastReceiver;", "intent", "Landroid/content/Intent;", "isRunning", "", "()Z", "getLastLocation", "Landroid/location/Location;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getLocation", "getLocationFlow", "Lkotlinx/coroutines/flow/Flow;", "hasRequestedPermissions", "onCreate", "", "onDestroy", "registerReceiver", "setNotificationIcon", "iconRes", "", "setNotificationName", "name", "", "setNotificationText", "text", "setNotificationTicker", "ticker", "setNotificationTitle", "title", "startService", "stopAndUnregisterReceiver", "stopService", "unregisterReceiver", "utils_release"})
public final class LocationManagerImpl
implements LocationManager,
LifecycleObserver {
    @NotNull
    private final Context context;
    @NotNull
    private final Intent intent;
    @Nullable
    private LocationBroadcastReceiver broadcastReceiver;

    public LocationManagerImpl(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.intent = new Intent(this.context, LocationUpdatesService.class);
    }

    private final boolean isRunning() {
        return LocationUpdatesService.Companion.isRunning();
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_CREATE)
    public final void onCreate() {
        this.registerReceiver();
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public final void onDestroy() {
        this.stopAndUnregisterReceiver();
    }

    @Override
    @ExperimentalCoroutinesApi
    @NotNull
    public Flow<Location> getLocationFlow() {
        return FlowKt.callbackFlow((Function2)((Function2)new Function2<ProducerScope<? super Location>, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ LocationManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ProducerScope $this$callbackFlow = (ProducerScope)this.L$0;
                        LocationManagerImpl.access$startService(this.this$0);
                        LocationBroadcastReceiver locationBroadcastReceiver = LocationManagerImpl.access$getBroadcastReceiver$p(this.this$0);
                        if (locationBroadcastReceiver != null) {
                            locationBroadcastReceiver.addCallback(new LocationBroadcastReceiver.LocationCallback((ProducerScope<? super Location>)$this$callbackFlow){
                                final /* synthetic */ ProducerScope<Location> $$this$callbackFlow;
                                {
                                    this.$$this$callbackFlow = $$this$callbackFlow;
                                }

                                public void onReceive(@NotNull Location location) {
                                    Intrinsics.checkNotNullParameter((Object)location, (String)"location");
                                    this.$$this$callbackFlow.trySend-JP2dKIU((Object)location);
                                }
                            });
                        }
                        this.label = 1;
                        Object object3 = ProduceKt.awaitClose((ProducerScope)$this$callbackFlow, (Function0)((Function0)new Function0<Unit>(this.this$0){
                            final /* synthetic */ LocationManagerImpl this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                LocationManagerImpl.access$stopService(this.this$0);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<ProducerScope<? super Location>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull ProducerScope<? super Location> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Override
    @Nullable
    public Object getLastLocation(@NotNull Continuation<? super Location> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super Location> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        this.startService();
        LocationBroadcastReceiver locationBroadcastReceiver = this.broadcastReceiver;
        if (locationBroadcastReceiver != null) {
            locationBroadcastReceiver.addLastLocationCallback(new LocationBroadcastReceiver.LocationCallback(this, (CancellableContinuation<? super Location>)continuation){
                final /* synthetic */ LocationManagerImpl this$0;
                final /* synthetic */ CancellableContinuation<Location> $continuation;
                {
                    this.this$0 = $receiver;
                    this.$continuation = $continuation;
                }

                public void onReceive(@NotNull Location location) {
                    Intrinsics.checkNotNullParameter((Object)location, (String)"location");
                    LocationBroadcastReceiver locationBroadcastReceiver = LocationManagerImpl.access$getBroadcastReceiver$p(this.this$0);
                    if (locationBroadcastReceiver != null) {
                        locationBroadcastReceiver.removeCallback(this);
                    }
                    locationBroadcastReceiver = (Continuation)this.$continuation;
                    boolean bl = false;
                    Result.Companion companion = Result.Companion;
                    boolean bl2 = false;
                    locationBroadcastReceiver.resumeWith(Result.constructor-impl((Object)location));
                    LocationManagerImpl.access$stopService(this.this$0);
                }
            });
        }
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    @Override
    @Nullable
    public Object getLocation(@NotNull Continuation<? super Location> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super Location> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        this.startService();
        LocationBroadcastReceiver locationBroadcastReceiver = this.broadcastReceiver;
        if (locationBroadcastReceiver != null) {
            locationBroadcastReceiver.addCallback(new LocationBroadcastReceiver.LocationCallback(this, (CancellableContinuation<? super Location>)continuation){
                final /* synthetic */ LocationManagerImpl this$0;
                final /* synthetic */ CancellableContinuation<Location> $continuation;
                {
                    this.this$0 = $receiver;
                    this.$continuation = $continuation;
                }

                public void onReceive(@NotNull Location location) {
                    Intrinsics.checkNotNullParameter((Object)location, (String)"location");
                    LocationBroadcastReceiver locationBroadcastReceiver = LocationManagerImpl.access$getBroadcastReceiver$p(this.this$0);
                    if (locationBroadcastReceiver != null) {
                        locationBroadcastReceiver.removeCallback(this);
                    }
                    locationBroadcastReceiver = (Continuation)this.$continuation;
                    boolean bl = false;
                    Result.Companion companion = Result.Companion;
                    boolean bl2 = false;
                    locationBroadcastReceiver.resumeWith(Result.constructor-impl((Object)location));
                    LocationManagerImpl.access$stopService(this.this$0);
                }
            });
        }
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    private final void registerReceiver() {
        if (this.broadcastReceiver == null) {
            this.broadcastReceiver = new LocationBroadcastReceiver();
            IntentFilter filter = new IntentFilter("com.merseyside.utils.LOCATION_BROADCAST");
            this.context.registerReceiver((BroadcastReceiver)this.broadcastReceiver, filter);
        }
    }

    private final void unregisterReceiver() {
        LocationBroadcastReceiver locationBroadcastReceiver = this.broadcastReceiver;
        if (locationBroadcastReceiver != null) {
            LocationBroadcastReceiver locationBroadcastReceiver2 = locationBroadcastReceiver;
            boolean bl = false;
            boolean bl2 = false;
            LocationBroadcastReceiver it = locationBroadcastReceiver2;
            boolean bl3 = false;
            this.context.unregisterReceiver((BroadcastReceiver)this.broadcastReceiver);
            this.broadcastReceiver = null;
        }
    }

    private final void startService() {
        if (!this.isRunning()) {
            this.context.startService(this.intent);
        }
    }

    private final void stopService() {
        if (this.isRunning()) {
            this.context.stopService(this.intent);
        }
    }

    private final void stopAndUnregisterReceiver() {
        this.unregisterReceiver();
        this.stopService();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasRequestedPermissions() {
        Context context = this.context;
        boolean bl = false;
        boolean bl2 = false;
        Context $this$hasRequestedPermissions_u24lambda_u2d3 = context;
        boolean bl3 = false;
        String[] stringArray = new String[]{"android.permission.ACCESS_FINE_LOCATION"};
        if (PermissionManagerKt.isPermissionsGranted($this$hasRequestedPermissions_u24lambda_u2d3, stringArray)) return true;
        stringArray = new String[]{"android.permission.ACCESS_COARSE_LOCATION"};
        if (!PermissionManagerKt.isPermissionsGranted($this$hasRequestedPermissions_u24lambda_u2d3, stringArray)) return false;
        return true;
    }

    public final void setNotificationText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        LocationUpdatesService.Companion.setText$utils_release(text);
    }

    public final void setNotificationTitle(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        LocationUpdatesService.Companion.setTitle$utils_release(title);
    }

    public final void setNotificationIcon(int iconRes) {
        LocationUpdatesService.Companion.setIconRes$utils_release(iconRes);
    }

    public final void setNotificationTicker(@NotNull String ticker) {
        Intrinsics.checkNotNullParameter((Object)ticker, (String)"ticker");
        LocationUpdatesService.Companion.setTicker$utils_release(ticker);
    }

    public final void setNotificationName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        LocationUpdatesService.Companion.setName$utils_release(name);
    }

    public static final /* synthetic */ void access$stopService(LocationManagerImpl $this) {
        $this.stopService();
    }
}

