/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.google.android.play.core.appupdate.AppUpdateInfo;
import com.google.android.play.core.appupdate.AppUpdateManager;
import com.google.android.play.core.appupdate.AppUpdateManagerFactory;
import com.google.android.play.core.install.InstallState;
import com.google.android.play.core.install.InstallStateUpdatedListener;
import com.google.android.play.core.tasks.Task;
import com.merseyside.utils.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u0001:\u0003\u0017\u0018\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/merseyside/utils/UpdateManager;", "", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "appUpdateInfo", "Lcom/google/android/play/core/appupdate/AppUpdateInfo;", "appUpdateManager", "Lcom/google/android/play/core/appupdate/AppUpdateManager;", "onAppUpdateListener", "Lcom/merseyside/utils/UpdateManager$OnAppUpdateListener;", "requestCode", "", "Ljava/lang/Integer;", "installDownloadedUpdate", "", "isRequestCodeValid", "", "setOnAppUpdateListener", "startFlexibleUpdate", "onFlexibleUpdateStateListener", "Lcom/merseyside/utils/UpdateManager$OnFlexibleUpdateStateListener;", "startImmediateUpdate", "Companion", "OnAppUpdateListener", "OnFlexibleUpdateStateListener", "utils_release"})
public final class UpdateManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Activity activity;
    @Nullable
    private OnAppUpdateListener onAppUpdateListener;
    @NotNull
    private final AppUpdateManager appUpdateManager;
    @Nullable
    private AppUpdateInfo appUpdateInfo;
    @Nullable
    private Integer requestCode;
    @NotNull
    private static final String TAG = "UpdateManager";
    public static final int RESULT_IN_APP_UPDATE_FAILED = 1;

    public UpdateManager(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.activity = activity;
        AppUpdateManager appUpdateManager = AppUpdateManagerFactory.create((Context)((Context)this.activity));
        Intrinsics.checkNotNullExpressionValue((Object)appUpdateManager, (String)"create(activity)");
        this.appUpdateManager = appUpdateManager;
    }

    public final void setOnAppUpdateListener(@NotNull OnAppUpdateListener onAppUpdateListener) {
        Intrinsics.checkNotNullParameter((Object)onAppUpdateListener, (String)"onAppUpdateListener");
        this.onAppUpdateListener = onAppUpdateListener;
        Task task = this.appUpdateManager.getAppUpdateInfo();
        boolean bl = false;
        boolean bl2 = false;
        Task $this$setOnAppUpdateListener_u24lambda_u2d2 = task;
        boolean bl3 = false;
        $this$setOnAppUpdateListener_u24lambda_u2d2.addOnFailureListener(UpdateManager::setOnAppUpdateListener$lambda-2$lambda-0);
        $this$setOnAppUpdateListener_u24lambda_u2d2.addOnSuccessListener(arg_0 -> UpdateManager.setOnAppUpdateListener$lambda-2$lambda-1(this, onAppUpdateListener, arg_0));
    }

    public final void startImmediateUpdate(int requestCode) throws IllegalArgumentException {
        if (this.isRequestCodeValid(requestCode)) {
            this.requestCode = requestCode;
            if (this.appUpdateInfo == null) {
                throw new IllegalStateException("App is not available for updating");
            }
        } else {
            throw new IllegalArgumentException("requestCode must be lower than 2^16");
        }
        this.appUpdateManager.startUpdateFlowForResult(this.appUpdateInfo, 1, this.activity, requestCode);
    }

    public final void startFlexibleUpdate(int requestCode, @NotNull OnFlexibleUpdateStateListener onFlexibleUpdateStateListener) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)onFlexibleUpdateStateListener, (String)"onFlexibleUpdateStateListener");
        if (this.isRequestCodeValid(requestCode)) {
            this.requestCode = requestCode;
            if (this.appUpdateInfo == null) {
                throw new IllegalStateException("App is not available for updating");
            }
        } else {
            throw new IllegalArgumentException("requestCode must be lower than 2^16");
        }
        this.appUpdateManager.startUpdateFlowForResult(this.appUpdateInfo, 0, this.activity, requestCode);
        Ref.ObjectRef installListener = new Ref.ObjectRef();
        installListener.element = arg_0 -> UpdateManager.startFlexibleUpdate$lambda-3(onFlexibleUpdateStateListener, this, installListener, arg_0);
    }

    public final void installDownloadedUpdate() {
        this.appUpdateManager.completeUpdate();
    }

    private final boolean isRequestCodeValid(int requestCode) {
        return 0 <= requestCode ? requestCode < 65534 : false;
    }

    private static final void setOnAppUpdateListener$lambda-2$lambda-0(Exception it) {
        Logger.INSTANCE.log(TAG, "Fail to get updates");
    }

    private static final void setOnAppUpdateListener$lambda-2$lambda-1(UpdateManager this$0, OnAppUpdateListener $onAppUpdateListener, AppUpdateInfo appUpdateInfo) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$onAppUpdateListener, (String)"$onAppUpdateListener");
        Logger.INSTANCE.log(TAG, String.valueOf(appUpdateInfo.updateAvailability()));
        this$0.appUpdateInfo = appUpdateInfo;
        if (appUpdateInfo.updateAvailability() == 3) {
            if (this$0.requestCode != null) {
                Integer n = this$0.requestCode;
                Intrinsics.checkNotNull((Object)n);
                this$0.startImmediateUpdate(n);
            }
        } else if (appUpdateInfo.installStatus() == 11) {
            $onAppUpdateListener.updateDownloaded();
        } else if (appUpdateInfo.updateAvailability() == 2) {
            OnAppUpdateListener onAppUpdateListener;
            if (appUpdateInfo.isUpdateTypeAllowed(1)) {
                Log.d((String)TAG, (String)"Immediate updating is available");
                onAppUpdateListener = this$0.onAppUpdateListener;
                if (onAppUpdateListener != null) {
                    onAppUpdateListener.immediateUpdateAvailable();
                }
            }
            if (appUpdateInfo.isUpdateTypeAllowed(0)) {
                Log.d((String)TAG, (String)"Flexible updating is available");
                onAppUpdateListener = this$0.onAppUpdateListener;
                if (onAppUpdateListener != null) {
                    onAppUpdateListener.flexibleUpdateAvailable();
                }
            }
        } else {
            Logger.INSTANCE.log(TAG, "No updates");
        }
    }

    private static final void startFlexibleUpdate$lambda-3(OnFlexibleUpdateStateListener $onFlexibleUpdateStateListener, UpdateManager this$0, Ref.ObjectRef $installListener, InstallState state) {
        Intrinsics.checkNotNullParameter((Object)$onFlexibleUpdateStateListener, (String)"$onFlexibleUpdateStateListener");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$installListener, (String)"$installListener");
        int n = state.installStatus();
        switch (n) {
            case 11: {
                $onFlexibleUpdateStateListener.onDownloaded();
                break;
            }
            case 5: {
                $onFlexibleUpdateStateListener.onFailed();
                break;
            }
            case 6: {
                $onFlexibleUpdateStateListener.onCanceled();
                break;
            }
            case 4: {
                $onFlexibleUpdateStateListener.onInstalled();
            }
        }
        if (state.installStatus() != 11) {
            this$0.appUpdateManager.unregisterListener((InstallStateUpdatedListener)$installListener.element);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&J\b\u0010\u0005\u001a\u00020\u0003H&\u00a8\u0006\u0006"}, d2={"Lcom/merseyside/utils/UpdateManager$OnAppUpdateListener;", "", "flexibleUpdateAvailable", "", "immediateUpdateAvailable", "updateDownloaded", "utils_release"})
    public static interface OnAppUpdateListener {
        public void immediateUpdateAvailable();

        public void flexibleUpdateAvailable();

        public void updateDownloaded();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&J\b\u0010\u0005\u001a\u00020\u0003H&J\b\u0010\u0006\u001a\u00020\u0003H&\u00a8\u0006\u0007"}, d2={"Lcom/merseyside/utils/UpdateManager$OnFlexibleUpdateStateListener;", "", "onCanceled", "", "onDownloaded", "onFailed", "onInstalled", "utils_release"})
    public static interface OnFlexibleUpdateStateListener {
        public void onDownloaded();

        public void onFailed();

        public void onCanceled();

        public void onInstalled();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/merseyside/utils/UpdateManager$Companion;", "", "()V", "RESULT_IN_APP_UPDATE_FAILED", "", "TAG", "", "utils_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

