/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils.service;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcelable;
import android.util.Log;
import androidx.core.app.NotificationCompat;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.Task;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \"2\u00020\u0001:\u0002\"#B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\u0012\u0010\u0016\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\bH\u0002J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001eH\u0016J\b\u0010!\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lcom/merseyside/utils/service/LocationUpdatesService;", "Landroid/app/Service;", "()V", "mBinder", "Landroid/os/IBinder;", "mFusedLocationClient", "Lcom/google/android/gms/location/FusedLocationProviderClient;", "mLocation", "Landroid/location/Location;", "mLocationCallback", "Lcom/google/android/gms/location/LocationCallback;", "mLocationRequest", "Lcom/google/android/gms/location/LocationRequest;", "mNotificationManager", "Landroid/app/NotificationManager;", "notification", "Landroid/app/Notification;", "getNotification", "()Landroid/app/Notification;", "createLocationRequest", "", "getLastLocation", "onBind", "intent", "Landroid/content/Intent;", "onCreate", "onDestroy", "onNewLocation", "location", "onStartCommand", "", "flags", "startId", "requestLocationUpdates", "Companion", "LocalBinder", "utils_release"})
public final class LocationUpdatesService
extends Service {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IBinder mBinder = (IBinder)new LocalBinder();
    @Nullable
    private NotificationManager mNotificationManager;
    private LocationRequest mLocationRequest;
    private FusedLocationProviderClient mFusedLocationClient;
    @Nullable
    private LocationCallback mLocationCallback;
    @Nullable
    private Location mLocation;
    @NotNull
    private static String name = "App name";
    @NotNull
    private static String title = "Location app";
    @NotNull
    private static String text = "Getting your location";
    @NotNull
    private static String ticker = "";
    private static int iconRes = 0x10D0000;
    private static boolean isRunning;
    @NotNull
    private static final String PACKAGE_NAME = "com.merseyside.utils";
    private static final String TAG;
    @NotNull
    public static final String ACTION_BROADCAST = "com.merseyside.utils.LOCATION_BROADCAST";
    @NotNull
    public static final String LOCATION_KEY = "location";
    @NotNull
    public static final String LAST_LOCATION_KEY = "last_location";
    @NotNull
    private static final String CHANNEL_ID = "channel_01";
    private static final long UPDATE_INTERVAL_IN_MILLISECONDS = 10000L;
    private static final long FASTEST_UPDATE_INTERVAL_IN_MILLISECONDS = 5000L;
    private static final int NOTIFICATION_ID = 12345678;

    public void onCreate() {
        isRunning = true;
        FusedLocationProviderClient fusedLocationProviderClient = LocationServices.getFusedLocationProviderClient((Context)((Context)this));
        Intrinsics.checkNotNullExpressionValue((Object)fusedLocationProviderClient, (String)"getFusedLocationProviderClient(this)");
        this.mFusedLocationClient = fusedLocationProviderClient;
        this.mLocationCallback = new LocationCallback(this){
            final /* synthetic */ LocationUpdatesService this$0;
            {
                this.this$0 = $receiver;
            }

            public void onLocationResult(@NotNull LocationResult locationResult) {
                Intrinsics.checkNotNullParameter((Object)locationResult, (String)"locationResult");
                super.onLocationResult(locationResult);
                Location location = locationResult.getLastLocation();
                Intrinsics.checkNotNullExpressionValue((Object)location, (String)"locationResult.lastLocation");
                LocationUpdatesService.access$onNewLocation(this.this$0, location);
            }
        };
        this.createLocationRequest();
        this.mNotificationManager = (NotificationManager)this.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel mChannel = new NotificationChannel(CHANNEL_ID, (CharSequence)name, 3);
            NotificationManager notificationManager = this.mNotificationManager;
            if (notificationManager != null) {
                notificationManager.createNotificationChannel(mChannel);
            }
        }
        this.getLastLocation();
        this.requestLocationUpdates();
    }

    public int onStartCommand(@NotNull Intent intent, int flags, int startId) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        return 2;
    }

    public void onDestroy() {
        FusedLocationProviderClient fusedLocationProviderClient = this.mFusedLocationClient;
        if (fusedLocationProviderClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mFusedLocationClient");
            throw null;
        }
        fusedLocationProviderClient.removeLocationUpdates(this.mLocationCallback);
        fusedLocationProviderClient = this.mNotificationManager;
        if (fusedLocationProviderClient != null) {
            fusedLocationProviderClient.cancelAll();
        }
        isRunning = false;
    }

    @NotNull
    public IBinder onBind(@Nullable Intent intent) {
        return this.mBinder;
    }

    private final void requestLocationUpdates() {
        Log.i((String)TAG, (String)"Requesting location updates");
        this.startService(new Intent(this.getApplicationContext(), LocationUpdatesService.class));
        try {
            FusedLocationProviderClient fusedLocationProviderClient = this.mFusedLocationClient;
            if (fusedLocationProviderClient == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mFusedLocationClient");
                throw null;
            }
            FusedLocationProviderClient fusedLocationProviderClient2 = fusedLocationProviderClient;
            fusedLocationProviderClient = this.mLocationRequest;
            if (fusedLocationProviderClient == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mLocationRequest");
                throw null;
            }
            fusedLocationProviderClient2.requestLocationUpdates((LocationRequest)fusedLocationProviderClient, this.mLocationCallback, Looper.myLooper());
            fusedLocationProviderClient = this.mNotificationManager;
            if (fusedLocationProviderClient != null) {
                fusedLocationProviderClient.notify(12345678, this.getNotification());
            }
        }
        catch (SecurityException unlikely) {
            Log.e((String)TAG, (String)Intrinsics.stringPlus((String)"Lost location permission. Could not request updates. ", (Object)unlikely));
        }
    }

    private final Notification getNotification() {
        NotificationCompat.Builder builder = new NotificationCompat.Builder((Context)this, CHANNEL_ID).setContentText((CharSequence)text).setContentTitle((CharSequence)title).setOngoing(true).setSmallIcon(iconRes).setTicker((CharSequence)ticker).setWhen(System.currentTimeMillis());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder(this, CHANNEL_ID)\n                .setContentText(text)\n                .setContentTitle(title)\n                .setOngoing(true)\n                .setSmallIcon(iconRes)\n                .setTicker(ticker)\n                .setWhen(System.currentTimeMillis())");
        NotificationCompat.Builder builder2 = builder;
        if (Build.VERSION.SDK_INT >= 24) {
            builder2.setPriority(4);
        } else {
            builder2.setPriority(1);
        }
        if (Build.VERSION.SDK_INT >= 26) {
            builder2.setChannelId(CHANNEL_ID);
        }
        builder = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder.build()");
        return builder;
    }

    private final void getLastLocation() {
        try {
            FusedLocationProviderClient fusedLocationProviderClient = this.mFusedLocationClient;
            if (fusedLocationProviderClient == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mFusedLocationClient");
                throw null;
            }
            fusedLocationProviderClient.getLastLocation().addOnCompleteListener(arg_0 -> LocationUpdatesService.getLastLocation$lambda-1(this, arg_0));
        }
        catch (SecurityException unlikely) {
            Log.e((String)TAG, (String)Intrinsics.stringPlus((String)"Lost location permission.", (Object)unlikely));
        }
    }

    private final void onNewLocation(Location location) {
        Log.i((String)TAG, (String)Intrinsics.stringPlus((String)"New location: ", (Object)location));
        this.mLocation = location;
        Intent intent = new Intent(ACTION_BROADCAST);
        boolean bl = false;
        boolean bl2 = false;
        Intent it = intent;
        boolean bl3 = false;
        it.putExtra(LOCATION_KEY, (Parcelable)location);
        this.sendBroadcast(it);
    }

    private final void createLocationRequest() {
        LocationRequest locationRequest = LocationRequest.create();
        Intrinsics.checkNotNullExpressionValue((Object)locationRequest, (String)"create()");
        locationRequest = this.mLocationRequest = locationRequest;
        if (locationRequest == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mLocationRequest");
            throw null;
        }
        locationRequest.setInterval(10000L);
        locationRequest = this.mLocationRequest;
        if (locationRequest == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mLocationRequest");
            throw null;
        }
        locationRequest.setFastestInterval(5000L);
        locationRequest = this.mLocationRequest;
        if (locationRequest == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mLocationRequest");
            throw null;
        }
        locationRequest.setPriority(100);
    }

    private static final void getLastLocation$lambda-1(LocationUpdatesService this$0, Task task) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (task.isSuccessful() && task.getResult() != null) {
            Intent intent = new Intent(ACTION_BROADCAST);
            boolean bl = false;
            boolean bl2 = false;
            Intent it = intent;
            boolean bl3 = false;
            it.putExtra(LAST_LOCATION_KEY, (Parcelable)task.getResult());
            this$0.sendBroadcast(it);
        } else {
            Log.w((String)TAG, (String)"Failed to get location.");
        }
    }

    public static final /* synthetic */ void access$onNewLocation(LocationUpdatesService $this, Location location) {
        $this.onNewLocation(location);
    }

    static {
        TAG = LocationUpdatesService.class.getSimpleName();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/merseyside/utils/service/LocationUpdatesService$LocalBinder;", "Landroid/os/Binder;", "(Lcom/merseyside/utils/service/LocationUpdatesService;)V", "service", "Lcom/merseyside/utils/service/LocationUpdatesService;", "getService", "()Lcom/merseyside/utils/service/LocationUpdatesService;", "utils_release"})
    public final class LocalBinder
    extends Binder {
        public LocalBinder() {
            Intrinsics.checkNotNullParameter((Object)((Object)LocationUpdatesService.this), (String)"this$0");
        }

        @NotNull
        public final LocationUpdatesService getService() {
            return LocationUpdatesService.this;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0012\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000e*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u001a\u0010\"\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001c\"\u0004\b$\u0010\u001eR\u001a\u0010%\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001c\"\u0004\b'\u0010\u001e\u00a8\u0006("}, d2={"Lcom/merseyside/utils/service/LocationUpdatesService$Companion;", "", "()V", "ACTION_BROADCAST", "", "CHANNEL_ID", "FASTEST_UPDATE_INTERVAL_IN_MILLISECONDS", "", "LAST_LOCATION_KEY", "LOCATION_KEY", "NOTIFICATION_ID", "", "PACKAGE_NAME", "TAG", "kotlin.jvm.PlatformType", "UPDATE_INTERVAL_IN_MILLISECONDS", "iconRes", "getIconRes$utils_release", "()I", "setIconRes$utils_release", "(I)V", "isRunning", "", "()Z", "setRunning", "(Z)V", "name", "getName$utils_release", "()Ljava/lang/String;", "setName$utils_release", "(Ljava/lang/String;)V", "text", "getText$utils_release", "setText$utils_release", "ticker", "getTicker$utils_release", "setTicker$utils_release", "title", "getTitle$utils_release", "setTitle$utils_release", "utils_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getName$utils_release() {
            return name;
        }

        public final void setName$utils_release(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            name = string2;
        }

        @NotNull
        public final String getTitle$utils_release() {
            return title;
        }

        public final void setTitle$utils_release(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            title = string2;
        }

        @NotNull
        public final String getText$utils_release() {
            return text;
        }

        public final void setText$utils_release(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            text = string2;
        }

        @NotNull
        public final String getTicker$utils_release() {
            return ticker;
        }

        public final void setTicker$utils_release(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            ticker = string2;
        }

        public final int getIconRes$utils_release() {
            return iconRes;
        }

        public final void setIconRes$utils_release(int n) {
            iconRes = n;
        }

        public final boolean isRunning() {
            return isRunning;
        }

        public final void setRunning(boolean bl) {
            isRunning = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

