/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils.reflection;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\t\u001a\u00020\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b\u00a8\u0006\f"}, d2={"Lcom/merseyside/utils/reflection/ReflectionUtils;", "", "()V", "getGenericParameterClass", "Ljava/lang/Class;", "actualClass", "genericClass", "parameterIndex", "", "getParameterTypeDeclarationIndex", "typeVariable", "Ljava/lang/reflect/TypeVariable;", "utils_release"})
public final class ReflectionUtils {
    @NotNull
    public static final ReflectionUtils INSTANCE = new ReflectionUtils();

    private ReflectionUtils() {
    }

    @NotNull
    public final Class<?> getGenericParameterClass(@NotNull Class<?> actualClass, @NotNull Class<?> genericClass, int parameterIndex) {
        Type type;
        Intrinsics.checkNotNullParameter(actualClass, (String)"actualClass");
        Intrinsics.checkNotNullParameter(genericClass, (String)"genericClass");
        Class<?> clazz = actualClass.getSuperclass();
        Intrinsics.checkNotNull(clazz);
        if (!genericClass.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class " + genericClass.getName() + " is not a superclass of " + actualClass.getName() + '.');
        }
        Stack<ParameterizedType> genericClasses = new Stack<ParameterizedType>();
        Class<?> clazz2 = actualClass;
        while (true) {
            Type rawType;
            Type type2;
            Type type3;
            if ((type3 = clazz2.getGenericSuperclass()) == null) {
                continue;
            }
            Type genericSuperclass = type3;
            boolean isParameterizedType = genericSuperclass instanceof ParameterizedType;
            if (isParameterizedType) {
                genericClasses.push((ParameterizedType)genericSuperclass);
            } else {
                genericClasses.clear();
            }
            if (isParameterizedType) {
                type = ((ParameterizedType)genericSuperclass).getRawType();
                Intrinsics.checkNotNullExpressionValue((Object)type, (String)"genericSuperclass as ParameterizedType).rawType");
                type2 = type;
            } else {
                type2 = rawType = genericSuperclass;
            }
            if (Intrinsics.areEqual((Object)rawType, genericClass)) break;
            type = clazz2.getSuperclass();
            Intrinsics.checkNotNull(type);
            clazz2 = type;
        }
        Type isParameterizedType = ((ParameterizedType)genericClasses.pop()).getActualTypeArguments()[parameterIndex];
        Intrinsics.checkNotNullExpressionValue((Object)isParameterizedType, (String)"genericClasses.pop().actualTypeArguments[parameterIndex]");
        Type result = isParameterizedType;
        while (result instanceof TypeVariable && !genericClasses.empty()) {
            int actualArgumentIndex = this.getParameterTypeDeclarationIndex((TypeVariable)result);
            type = genericClasses.pop();
            Intrinsics.checkNotNullExpressionValue(type, (String)"genericClasses.pop()");
            ParameterizedType type4 = (ParameterizedType)type;
            type = type4.getActualTypeArguments()[actualArgumentIndex];
            Intrinsics.checkNotNullExpressionValue(type, (String)"type.actualTypeArguments[actualArgumentIndex]");
            result = type;
        }
        if (result instanceof TypeVariable) {
            throw new IllegalStateException("Unable to resolve type variable " + result + ". Try to replace instances of parametrized class with its non-parameterized subtype.");
        }
        if (result instanceof ParameterizedType) {
            Type type5 = ((ParameterizedType)result).getRawType();
            Intrinsics.checkNotNullExpressionValue((Object)type5, (String)"result.rawType");
            result = type5;
        }
        if (!(result instanceof Class)) {
            throw new IllegalStateException("Actual parameter type for " + actualClass.getName() + " is not a Class.");
        }
        return result;
    }

    public final int getParameterTypeDeclarationIndex(@NotNull TypeVariable<?> typeVariable) {
        Integer n;
        Intrinsics.checkNotNullParameter(typeVariable, (String)"typeVariable");
        Object obj = typeVariable.getGenericDeclaration();
        Intrinsics.checkNotNullExpressionValue(obj, (String)"typeVariable.genericDeclaration");
        Object genericDeclaration = obj;
        TypeVariable<?>[] typeVariableArray = genericDeclaration.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(typeVariableArray, (String)"genericDeclaration.typeParameters");
        TypeVariable<?>[] typeVariables = typeVariableArray;
        Integer actualArgumentIndex = null;
        int n2 = 0;
        int n3 = typeVariables.length + -1;
        if (n2 <= n3) {
            do {
                int i;
                if (!Intrinsics.areEqual(typeVariables[i = n2++], typeVariable)) continue;
                actualArgumentIndex = i;
                break;
            } while (n2 <= n3);
        }
        if ((n = actualArgumentIndex) == null) {
            throw new IllegalStateException("Argument " + typeVariable + " is not found in " + genericDeclaration + '.');
        }
        return n;
    }
}

