/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils.billing;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import androidx.annotation.RawRes;
import com.android.billingclient.api.BillingClient;
import com.android.billingclient.api.BillingClientStateListener;
import com.android.billingclient.api.BillingFlowParams;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.PurchaseHistoryRecord;
import com.android.billingclient.api.PurchaseHistoryResponseListener;
import com.android.billingclient.api.PurchasesUpdatedListener;
import com.android.billingclient.api.SkuDetails;
import com.android.billingclient.api.SkuDetailsParams;
import com.android.billingclient.api.SkuDetailsResponseListener;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.androidpublisher.AndroidPublisher;
import com.google.api.services.androidpublisher.model.SubscriptionPurchase;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import com.merseyside.utils.LibUtils;
import com.merseyside.utils.Logger;
import com.merseyside.utils.billing.BillingManager;
import com.merseyside.utils.billing.Security;
import com.merseyside.utils.billing.Subscription;
import com.merseyside.utils.ext.CollectionExtKt;
import com.merseyside.utils.ext.LoggerExtKt;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 ;2\u00020\u00012\u00020\u0002:\u0003:;<B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J+\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0010\b\u0002\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0016H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J+\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001fH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 J \u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020'\u0018\u00010&H\u0016J7\u0010(\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u00162\u0012\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060*\"\u00020\u00062\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J7\u0010,\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u00162\u0012\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060*\"\u00020\u00062\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J\u000e\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020\u0012J\u0013\u0010/\u001a\u0004\u0018\u00010\u000bH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00100J\u0016\u00101\u001a\u00020$2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0017J\u0019\u00105\u001a\u00020\"2\u0006\u00102\u001a\u000203H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00106J\u0018\u00107\u001a\u00020\u001f2\u0006\u00108\u001a\u00020\u00062\u0006\u00109\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006="}, d2={"Lcom/merseyside/utils/billing/BillingManager;", "Lcom/android/billingclient/api/PurchasesUpdatedListener;", "Lkotlinx/coroutines/CoroutineScope;", "context", "Landroid/content/Context;", "base64Key", "", "credentialsId", "", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/Integer;)V", "billingClient", "Lcom/android/billingclient/api/BillingClient;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "Ljava/lang/Integer;", "onPurchaseListener", "Lcom/merseyside/utils/billing/BillingManager$OnPurchaseListener;", "getGoogleCredentials", "Lcom/google/auth/oauth2/GoogleCredentials;", "getSkuDetails", "", "Lcom/android/billingclient/api/SkuDetails;", "skuList", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getSubscriptionState", "Lcom/merseyside/utils/billing/Subscription;", "sku", "token", "isKeepActiveOnError", "", "(Ljava/lang/String;Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onPurchasesUpdated", "", "result", "Lcom/android/billingclient/api/BillingResult;", "purchases", "", "Lcom/android/billingclient/api/Purchase;", "queryActiveSubscriptionsAsync", "skus", "", "([Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "queryAllSubscriptionsAsync", "setOnPurchaseListener", "listener", "startConnection", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startSubscription", "activity", "Landroid/app/Activity;", "skuDetails", "startTestPurchase", "(Landroid/app/Activity;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "verifyValidSignature", "signedData", "signature", "BillingConnectionListener", "Companion", "OnPurchaseListener", "utils_release"})
public final class BillingManager
implements PurchasesUpdatedListener,
CoroutineScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final String base64Key;
    @Nullable
    private final Integer credentialsId;
    @Nullable
    private OnPurchaseListener onPurchaseListener;
    @Nullable
    private BillingClient billingClient;
    @NotNull
    private static final String TEST_SUBSCRIPTION_ID = "android.test.purchased";
    @NotNull
    private static final String PUBLISHER_SCOPE = "https://www.googleapis.com/auth/androidpublisher";

    public BillingManager(@NotNull Context context, @NotNull String base64Key, @RawRes @Nullable Integer credentialsId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)base64Key, (String)"base64Key");
        this.context = context;
        this.base64Key = base64Key;
        this.credentialsId = credentialsId;
    }

    public /* synthetic */ BillingManager(Context context, String string2, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        this(context, string2, n);
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return (CoroutineContext)Dispatchers.INSTANCE.getMain();
    }

    public final void setOnPurchaseListener(@NotNull OnPurchaseListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.onPurchaseListener = listener;
    }

    private final Object startConnection(Continuation<? super BillingClient> $completion) {
        if (this.billingClient == null) {
            boolean $i$f$suspendCancellableCoroutine = false;
            Continuation<? super BillingClient> uCont$iv = $completion;
            boolean bl = false;
            CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
            cancellable$iv.initCancellability();
            CancellableContinuation cont = (CancellableContinuation)cancellable$iv;
            boolean bl2 = false;
            BillingClient billingClient = BillingClient.newBuilder((Context)this.context).enablePendingPurchases().setListener((PurchasesUpdatedListener)this).build();
            Intrinsics.checkNotNullExpressionValue((Object)billingClient, (String)"newBuilder(context)\n                    .enablePendingPurchases()\n                    .setListener(this@BillingManager)\n                    .build()");
            BillingClient client = billingClient;
            client.startConnection(new BillingClientStateListener((CancellableContinuation<? super BillingClient>)cont, this, client){
                final /* synthetic */ CancellableContinuation<BillingClient> $cont;
                final /* synthetic */ BillingManager this$0;
                final /* synthetic */ BillingClient $client;
                {
                    this.$cont = $cont;
                    this.this$0 = $receiver;
                    this.$client = $client;
                }

                public void onBillingSetupFinished(@NotNull BillingResult billingResult) {
                    Intrinsics.checkNotNullParameter((Object)billingResult, (String)"billingResult");
                    if (this.$cont.isActive()) {
                        if (billingResult.getResponseCode() == 0) {
                            BillingManager.access$setBillingClient$p(this.this$0, this.$client);
                            Continuation continuation = (Continuation)this.$cont;
                            BillingClient billingClient = BillingManager.access$getBillingClient$p(this.this$0);
                            boolean bl = false;
                            Result.Companion companion = Result.Companion;
                            boolean bl2 = false;
                            continuation.resumeWith(Result.constructor-impl((Object)billingClient));
                        } else {
                            Continuation continuation = (Continuation)this.$cont;
                            Object var3_5 = null;
                            boolean bl = false;
                            Result.Companion companion = Result.Companion;
                            boolean bl3 = false;
                            continuation.resumeWith(Result.constructor-impl(var3_5));
                        }
                    }
                }

                public void onBillingServiceDisconnected() {
                    BillingManager.access$setBillingClient$p(this.this$0, null);
                }
            });
            Object object = cancellable$iv.getResult();
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                DebugProbesKt.probeCoroutineSuspended($completion);
            }
            return object;
        }
        return this.billingClient;
    }

    public void onPurchasesUpdated(@NotNull BillingResult result, @Nullable List<Purchase> purchases) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (result.getResponseCode() == 0) {
            if (purchases != null) {
                Iterable $this$forEach$iv = purchases;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Purchase purchase = (Purchase)element$iv;
                    boolean bl = false;
                    Object object = purchase.getOriginalJson();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"purchase.originalJson");
                    String string2 = object;
                    object = purchase.getSignature();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"purchase.signature");
                    if (this.verifyValidSignature(string2, (String)object)) {
                        object = this.onPurchaseListener;
                        if (object == null) continue;
                        object.onPurchase(purchase);
                        continue;
                    }
                    object = this.onPurchaseListener;
                    if (object == null) continue;
                    object.onError(result);
                }
            } else {
                OnPurchaseListener onPurchaseListener = this.onPurchaseListener;
                if (onPurchaseListener != null) {
                    onPurchaseListener.onError(result);
                }
            }
        } else {
            OnPurchaseListener onPurchaseListener = this.onPurchaseListener;
            if (onPurchaseListener != null) {
                onPurchaseListener.onError(result);
            }
        }
    }

    private final boolean verifyValidSignature(String signedData, String signature) {
        boolean bl;
        try {
            bl = Security.INSTANCE.verifyPurchase(this.base64Key, signedData, signature);
        }
        catch (IOException e) {
            Logger.INSTANCE.logErr(this, Intrinsics.stringPlus((String)"Got an exception trying to validate a purchase: ", (Object)e.getMessage()));
            bl = false;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getSkuDetails(@Nullable List<String> var1_1, @NotNull Continuation<? super List<? extends SkuDetails>> var2_2) {
        block10: {
            if (!(var2_2 instanceof getSkuDetails.1)) ** GOTO lbl-1000
            var14_3 = var2_2;
            if ((var14_3.label & -2147483648) != 0) {
                var14_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ BillingManager this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.getSkuDetails(null, (Continuation<? super List<? extends SkuDetails>>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var15_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (!CollectionExtKt.isNotNullAndEmpty(skuList)) break block10;
                    Logger.INSTANCE.log(this, this);
                    var11_6 = this;
                    $continuation.L$0 = this;
                    $continuation.L$1 = skuList;
                    $continuation.L$2 = var11_6;
                    $continuation.label = 1;
                    v0 = this.startConnection((Continuation<? super BillingClient>)$continuation);
                    if (v0 == var15_5) {
                        return var15_5;
                    }
                    ** GOTO lbl29
                }
                case 1: {
                    var11_6 = (BillingManager)$continuation.L$2;
                    skuList = (List)$continuation.L$1;
                    this = (BillingManager)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl29:
                    // 2 sources

                    var12_7 = v0;
                    var11_6.billingClient = (BillingClient)var12_7;
                    if (this.billingClient == null) break;
                    var4_8 = SkuDetailsParams.newBuilder().setSkusList(skuList).setType("subs").build();
                    Intrinsics.checkNotNullExpressionValue((Object)var4_8, (String)"newBuilder().setSkusList(skuList)\n                    .setType(BillingClient.SkuType.SUBS).build()");
                    skuDetailsParams = var4_8;
                    var4_9 = false;
                    var5_12 = false;
                    $continuation.L$0 = this;
                    $continuation.L$1 = skuDetailsParams;
                    $continuation.L$2 = null;
                    $continuation.label = 2;
                    var5_13 = $continuation;
                    var6_14 = false;
                    var7_15 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var5_13));
                    cont = (Continuation)var7_15;
                    $i$a$-suspendCoroutine-BillingManager$getSkuDetails$2 = false;
                    var10_18 = this.billingClient;
                    Intrinsics.checkNotNull((Object)var10_18);
                    var10_18.querySkuDetailsAsync(skuDetailsParams, new SkuDetailsResponseListener((Continuation<? super List<? extends SkuDetails>>)cont){
                        final /* synthetic */ Continuation<List<? extends SkuDetails>> $cont;
                        {
                            this.$cont = $cont;
                        }

                        public final void onSkuDetailsResponse(@NotNull BillingResult result, @Nullable List<SkuDetails> responseSkuList) {
                            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                            if (result.getResponseCode() == 0) {
                                Continuation<List<? extends SkuDetails>> continuation = this.$cont;
                                boolean bl = false;
                                Result.Companion companion = Result.Companion;
                                boolean bl2 = false;
                                continuation.resumeWith(Result.constructor-impl(responseSkuList));
                            } else {
                                Continuation<List<? extends SkuDetails>> continuation = this.$cont;
                                Object var4_6 = null;
                                boolean bl = false;
                                Result.Companion companion = Result.Companion;
                                boolean bl3 = false;
                                continuation.resumeWith(Result.constructor-impl(var4_6));
                            }
                        }
                    });
                    v1 = var7_15.getOrThrow();
                    if (v1 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                        DebugProbesKt.probeCoroutineSuspended((Continuation)$continuation);
                    }
                    v2 = v1;
                    if (v1 == var15_5) {
                        return var15_5;
                    }
                    ** GOTO lbl63
                }
                case 2: {
                    var3_11 = (SkuDetailsParams)$continuation.L$1;
                    this = (BillingManager)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl63:
                    // 2 sources

                    return v2;
                }
            }
            return null;
        }
        throw new IllegalArgumentException("Sku list can not be empty");
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object getSkuDetails$default(BillingManager billingManager, List list, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            list = null;
        }
        return billingManager.getSkuDetails(list, (Continuation<? super List<? extends SkuDetails>>)continuation);
    }

    @NotNull
    public final BillingResult startSubscription(@NotNull Activity activity, @NotNull SkuDetails skuDetails) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)skuDetails, (String)"skuDetails");
        Logger.INSTANCE.log(this, this);
        if (this.billingClient != null) {
            BillingFlowParams billingFlowParams = BillingFlowParams.newBuilder().setSkuDetails(skuDetails).build();
            Intrinsics.checkNotNullExpressionValue((Object)billingFlowParams, (String)"newBuilder()\n                .setSkuDetails(skuDetails)\n                .build()");
            BillingFlowParams flowParams = billingFlowParams;
            BillingClient billingClient = this.billingClient;
            Intrinsics.checkNotNull((Object)billingClient);
            billingFlowParams = billingClient.launchBillingFlow(activity, flowParams);
            Intrinsics.checkNotNullExpressionValue((Object)billingFlowParams, (String)"billingClient!!.launchBillingFlow(activity, flowParams)");
            return billingFlowParams;
        }
        throw new IllegalStateException("BillingClient is null");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object queryAllSubscriptionsAsync(@NotNull String[] var1_1, boolean var2_2, @NotNull Continuation<? super List<? extends Subscription>> var3_3) {
        block14: {
            block15: {
                block16: {
                    if (!(var3_3 instanceof queryAllSubscriptionsAsync.1)) ** GOTO lbl-1000
                    var28_4 = var3_3;
                    if ((var28_4.label & -2147483648) != 0) {
                        var28_4.label -= -2147483648;
                    } else lbl-1000:
                    // 2 sources

                    {
                        $continuation = new ContinuationImpl(this, var3_3){
                            Object L$0;
                            Object L$1;
                            Object L$2;
                            boolean Z$0;
                            /* synthetic */ Object result;
                            final /* synthetic */ BillingManager this$0;
                            int label;
                            {
                                this.this$0 = this$0;
                                super($completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object $result) {
                                this.result = $result;
                                this.label |= Integer.MIN_VALUE;
                                return this.this$0.queryAllSubscriptionsAsync(null, false, (Continuation<? super List<? extends Subscription>>)((Continuation)this));
                            }
                        };
                    }
                    $result = $continuation.result;
                    var29_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch ($continuation.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            if (this.credentialsId == null) break block14;
                            $continuation.L$0 = this;
                            $continuation.L$1 = skus;
                            $continuation.Z$0 = isKeepActiveOnError;
                            $continuation.label = 1;
                            v0 = this.startConnection((Continuation<? super BillingClient>)$continuation);
                            if (v0 == var29_6) {
                                return var29_6;
                            }
                            ** GOTO lbl27
                        }
                        case 1: {
                            isKeepActiveOnError = $continuation.Z$0;
                            skus = (String[])$continuation.L$1;
                            this = (BillingManager)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl27:
                            // 2 sources

                            if ((billingClient = (BillingClient)v0) == null) break block15;
                            var6_8 = false;
                            var7_10 = false;
                            $continuation.L$0 = this;
                            $continuation.L$1 = skus;
                            $continuation.L$2 = billingClient;
                            $continuation.Z$0 = isKeepActiveOnError;
                            $continuation.label = 2;
                            var7_11 /* !! */  = $continuation;
                            var8_12 = false;
                            var9_14 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var7_11 /* !! */ ));
                            cont = (Continuation)var9_14;
                            $i$a$-suspendCoroutine-BillingManager$queryAllSubscriptionsAsync$historyList$1 = false;
                            billingClient.queryPurchaseHistoryAsync("subs", new PurchaseHistoryResponseListener((Continuation<? super List<? extends PurchaseHistoryRecord>>)cont){
                                final /* synthetic */ Continuation<List<? extends PurchaseHistoryRecord>> $cont;
                                {
                                    this.$cont = $cont;
                                }

                                public final void onPurchaseHistoryResponse(@NotNull BillingResult result, @Nullable List<PurchaseHistoryRecord> historyList2) {
                                    Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                                    if (result.getResponseCode() == 0) {
                                        Continuation<List<? extends PurchaseHistoryRecord>> continuation = this.$cont;
                                        boolean bl = false;
                                        Result.Companion companion = Result.Companion;
                                        boolean bl2 = false;
                                        continuation.resumeWith(Result.constructor-impl(historyList2));
                                    } else {
                                        Continuation<List<? extends PurchaseHistoryRecord>> continuation = this.$cont;
                                        Object var4_6 = null;
                                        boolean bl = false;
                                        Result.Companion companion = Result.Companion;
                                        boolean bl3 = false;
                                        continuation.resumeWith(Result.constructor-impl(var4_6));
                                    }
                                }
                            });
                            v1 = var9_14.getOrThrow();
                            if (v1 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                DebugProbesKt.probeCoroutineSuspended((Continuation)$continuation);
                            }
                            v2 = v1;
                            if (v1 == var29_6) {
                                return var29_6;
                            }
                            ** GOTO lbl57
                        }
                        case 2: {
                            isKeepActiveOnError = $continuation.Z$0;
                            var4_7 = (BillingClient)$continuation.L$2;
                            skus = (String[])$continuation.L$1;
                            this = (BillingManager)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl57:
                            // 2 sources

                            var6_9 = historyList = (List)LoggerExtKt.log$default(v2, null, 1, null);
                            if (var6_9 != null) ** GOTO lbl61
                            v3 = null;
                            break block16;
lbl61:
                            // 1 sources

                            $this$filter$iv = var6_9;
                            $i$f$filter = false;
                            cont = $this$filter$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                it = (PurchaseHistoryRecord)element$iv$iv;
                                $i$a$-filter-BillingManager$queryAllSubscriptionsAsync$2 = false;
                                if (!Boxing.boxBoolean((boolean)ArraysKt.contains((Object[])skus, (Object)it.getSku())).booleanValue()) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            var7_11 /* !! */  = (List)destination$iv$iv;
                            $this$mapNotNull$iv = (Iterable)var7_11 /* !! */ ;
                            $i$f$mapNotNull = false;
                            $this$filterTo$iv$iv = $this$mapNotNull$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$mapNotNullTo = false;
                            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                            $i$f$forEach = false;
                            var15_24 = $this$forEach$iv$iv$iv.iterator();
lbl82:
                            // 3 sources

                            while (var15_24.hasNext()) {
                                element$iv$iv = element$iv$iv$iv = var15_24.next();
                                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                                it = (PurchaseHistoryRecord)element$iv$iv;
                                $i$a$-mapNotNull-BillingManager$queryAllSubscriptionsAsync$3 = false;
                                var21_31 = it.getSku();
                                Intrinsics.checkNotNullExpressionValue((Object)var21_31, (String)"it.sku");
                                v4 = var21_31;
                                var21_31 = it.getPurchaseToken();
                                Intrinsics.checkNotNullExpressionValue((Object)var21_31, (String)"it.purchaseToken");
                                $continuation.L$0 = this;
                                $continuation.L$1 = destination$iv$iv;
                                $continuation.L$2 = var15_24;
                                $continuation.Z$0 = isKeepActiveOnError;
                                $continuation.label = 3;
                                v5 = this.getSubscriptionState(v4, var21_31, isKeepActiveOnError != false, (Continuation<? super Subscription>)$continuation);
                                if (v5 == var29_6) {
                                    return var29_6;
                                }
                                ** GOTO lbl114
                            }
                            break;
                        }
                        case 3: {
                            $i$f$mapNotNull = false;
                            $i$f$mapNotNullTo = false;
                            $i$f$forEach = false;
                            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                            $i$a$-mapNotNull-BillingManager$queryAllSubscriptionsAsync$3 = false;
                            var2_2 = $continuation.Z$0;
                            var15_24 = (Iterator<T>)$continuation.L$2;
                            destination$iv$iv = (Collection)$continuation.L$1;
                            this = (BillingManager)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v5 = $result;
lbl114:
                            // 2 sources

                            if ((Subscription)v5 == null) ** GOTO lbl82
                            var23_33 = false;
                            var24_34 = false;
                            it$iv$iv = var22_32;
                            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                            destination$iv$iv.add(it$iv$iv);
                            ** GOTO lbl82
                        }
                    }
                    v3 = (List)destination$iv$iv;
                }
                return v3;
            }
            return null;
        }
        throw new IllegalArgumentException("Please, set credentials id by constructor");
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object queryAllSubscriptionsAsync$default(BillingManager billingManager, String[] stringArray, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return billingManager.queryAllSubscriptionsAsync(stringArray, bl, (Continuation<? super List<? extends Subscription>>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object queryActiveSubscriptionsAsync(@NotNull String[] var1_1, boolean var2_2, @NotNull Continuation<? super List<? extends Subscription>> var3_3) {
        if (!(var3_3 instanceof queryActiveSubscriptionsAsync.1)) ** GOTO lbl-1000
        var13_4 = var3_3;
        if ((var13_4.label & -2147483648) != 0) {
            var13_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ BillingManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.queryActiveSubscriptionsAsync(null, false, (Continuation<? super List<? extends Subscription>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.queryAllSubscriptionsAsync((String[])Arrays.copyOf(skus, ((void)skus).length), isKeepActiveOnError != false, (Continuation<? super List<? extends Subscription>>)$continuation);
                if (v0 == var14_6) {
                    return var14_6;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                if ((var4_7 = (List)v0) == null) {
                    v1 = null;
                } else {
                    $this$filterIsInstance$iv = var4_7;
                    $i$f$filterIsInstance = false;
                    var7_10 = $this$filterIsInstance$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterIsInstanceTo = false;
                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof Subscription.ActiveSubscription)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    v1 = (List)destination$iv$iv;
                }
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object queryActiveSubscriptionsAsync$default(BillingManager billingManager, String[] stringArray, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return billingManager.queryActiveSubscriptionsAsync(stringArray, bl, (Continuation<? super List<? extends Subscription>>)continuation);
    }

    private final Object getSubscriptionState(String sku, String token, boolean isKeepActiveOnError, Continuation<? super Subscription> $completion) {
        NetHttpTransport httpTransport = new NetHttpTransport();
        JacksonFactory jacksonJsonFactory = JacksonFactory.getDefaultInstance();
        String packageName = this.context.getPackageName();
        AndroidPublisher publisher = new AndroidPublisher.Builder((HttpTransport)httpTransport, (JsonFactory)jacksonJsonFactory, (HttpRequestInitializer)new HttpCredentialsAdapter((Credentials)this.getGoogleCredentials())).setApplicationName(LibUtils.getApplicationName(this.context)).build();
        Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"publisher");
        AndroidPublisher.Purchases.Subscriptions.Get request = new AndroidPublisher.Purchases(publisher).subscriptions().get(packageName, sku, token);
        Ref.BooleanRef isKeepActiveOnErrorMut = new Ref.BooleanRef();
        isKeepActiveOnErrorMut.element = isKeepActiveOnError;
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.INSTANCE.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Subscription>, Object>(request, isKeepActiveOnErrorMut, sku, null){
            int label;
            final /* synthetic */ AndroidPublisher.Purchases.Subscriptions.Get $request;
            final /* synthetic */ Ref.BooleanRef $isKeepActiveOnErrorMut;
            final /* synthetic */ String $sku;
            {
                this.$request = $request;
                this.$isKeepActiveOnErrorMut = $isKeepActiveOnErrorMut;
                this.$sku = $sku;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        SubscriptionPurchase subscriptionPurchase;
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            subscriptionPurchase = (SubscriptionPurchase)this.$request.execute();
                        }
                        catch (GoogleJsonResponseException e) {
                            this.$isKeepActiveOnErrorMut.element = false;
                            subscriptionPurchase = null;
                        }
                        catch (HttpResponseException e) {
                            subscriptionPurchase = null;
                        }
                        boolean bl = this.$isKeepActiveOnErrorMut.element;
                        SubscriptionPurchase subscriptionPurchase2 = subscriptionPurchase;
                        return new Subscription.Builder(subscriptionPurchase2, bl).setSku(this.$sku).build();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Subscription> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object startTestPurchase(@NotNull Activity var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof startTestPurchase.1)) ** GOTO lbl-1000
        var5_3 = var2_2;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ BillingManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.startTestPurchase(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.getSkuDetails(CollectionsKt.listOf((Object)"android.test.purchased"), (Continuation<? super List<? extends SkuDetails>>)$continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                skuList = (List)LoggerExtKt.log$default(v0, null, 1, null);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final GoogleCredentials getGoogleCredentials() {
        Resources resources = this.context.getResources();
        Object object = this.credentialsId;
        Intrinsics.checkNotNull((Object)object);
        object = resources.openRawResource(((Integer)object).intValue());
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            InputStream is = (InputStream)object;
            boolean bl3 = false;
            String[] stringArray = new String[]{PUBLISHER_SCOPE};
            GoogleCredentials googleCredentials = GoogleCredentials.fromStream((InputStream)is).createScoped(stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)googleCredentials, (String)"fromStream(`is`)\n                .createScoped(PUBLISHER_SCOPE)");
            GoogleCredentials googleCredentials2 = googleCredentials;
            return googleCredentials2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    public static final /* synthetic */ Object access$startConnection(BillingManager $this, Continuation $completion) {
        return $this.startConnection((Continuation<? super BillingClient>)$completion);
    }

    public static final /* synthetic */ Object access$getSubscriptionState(BillingManager $this, String sku, String token, boolean isKeepActiveOnError, Continuation $completion) {
        return $this.getSubscriptionState(sku, token, isKeepActiveOnError, (Continuation<? super Subscription>)$completion);
    }

    public static final /* synthetic */ void access$setBillingClient$p(BillingManager $this, BillingClient billingClient) {
        $this.billingClient = billingClient;
    }

    public static final /* synthetic */ BillingClient access$getBillingClient$p(BillingManager $this) {
        return $this.billingClient;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/merseyside/utils/billing/BillingManager$BillingConnectionListener;", "", "onConnected", "", "onDisconnected", "onError", "code", "", "utils_release"})
    public static interface BillingConnectionListener {
        public void onConnected();

        public void onError(int var1);

        public void onDisconnected();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\t"}, d2={"Lcom/merseyside/utils/billing/BillingManager$OnPurchaseListener;", "", "onError", "", "result", "Lcom/android/billingclient/api/BillingResult;", "onPurchase", "purchase", "Lcom/android/billingclient/api/Purchase;", "utils_release"})
    public static interface OnPurchaseListener {
        public void onPurchase(@NotNull Purchase var1);

        public void onError(@NotNull BillingResult var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/merseyside/utils/billing/BillingManager$Companion;", "", "()V", "PUBLISHER_SCOPE", "", "TEST_SUBSCRIPTION_ID", "utils_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

