/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils.network;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import androidx.annotation.RequiresPermission;
import com.merseyside.utils.LibUtils;
import com.merseyside.utils.network.InternetConnectionObserver;
import com.merseyside.utils.network.NetworkStateChangeReceiver;
import com.merseyside.utils.network.NetworkStateListener;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\bH\u0007R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/merseyside/utils/network/InternetConnectionObserver;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "broadcastReceiver", "Lcom/merseyside/utils/network/NetworkStateChangeReceiver;", "registerReceiver", "", "listener", "Lcom/merseyside/utils/network/NetworkStateListener;", "unregisterReceiver", "Companion", "utils_release"})
public final class InternetConnectionObserver {
    private NetworkStateChangeReceiver broadcastReceiver;
    private final Context context;
    public static final Companion Companion = new Companion(null);

    @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
    public final void registerReceiver(@NotNull NetworkStateListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        if (Build.VERSION.SDK_INT >= 24) {
            InternetConnectionObserver.Companion.getConnectivityManager(this.context).registerDefaultNetworkCallback(new ConnectivityManager.NetworkCallback(listener2){
                final /* synthetic */ NetworkStateListener $listener;

                public void onAvailable(@NotNull Network network) {
                    Intrinsics.checkParameterIsNotNull((Object)network, (String)"network");
                    LibUtils.mainThread((Function0<Unit>)((Function0)new Function0<Unit>(this){
                        final /* synthetic */ registerReceiver.1 this$0;

                        public final void invoke() {
                            this.this$0.$listener.onConnectionState(true);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }));
                }

                public void onLost(@Nullable Network network) {
                    LibUtils.mainThread((Function0<Unit>)((Function0)new Function0<Unit>(this){
                        final /* synthetic */ registerReceiver.1 this$0;

                        public final void invoke() {
                            this.this$0.$listener.onConnectionState(false);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }));
                }
                {
                    this.$listener = $captured_local_variable$0;
                }
            });
        } else {
            NetworkStateChangeReceiver networkStateChangeReceiver = this.broadcastReceiver = new NetworkStateChangeReceiver();
            if (networkStateChangeReceiver == null) {
                Intrinsics.throwNpe();
            }
            networkStateChangeReceiver.setStateListener(listener2);
            IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            NetworkStateChangeReceiver networkStateChangeReceiver2 = this.broadcastReceiver;
            if (networkStateChangeReceiver2 == null) {
                Intrinsics.throwNpe();
            }
            this.context.registerReceiver((BroadcastReceiver)networkStateChangeReceiver2, intentFilter);
        }
    }

    @Deprecated(message="On API >= 24 DefaultNetworkCallback is used and doesn't need to be unregistered")
    public final void unregisterReceiver() {
        if (this.broadcastReceiver != null) {
            this.context.unregisterReceiver((BroadcastReceiver)this.broadcastReceiver);
            this.broadcastReceiver = null;
        }
    }

    public InternetConnectionObserver(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\n"}, d2={"Lcom/merseyside/utils/network/InternetConnectionObserver$Companion;", "", "()V", "getConnectivityManager", "Landroid/net/ConnectivityManager;", "context", "Landroid/content/Context;", "isOnline", "", "isWifiOnAndConnected", "utils_release"})
    public static final class Companion {
        @RequiresPermission(value="android.permission.ACCESS_NETWORK_STATE")
        public final boolean isOnline(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            ConnectivityManager cm = this.getConnectivityManager(context);
            NetworkInfo networkInfo = cm.getActiveNetworkInfo();
            return networkInfo != null ? networkInfo.isConnected() : false;
        }

        @RequiresPermission(value="android.permission.ACCESS_WIFI_STATE")
        public final boolean isWifiOnAndConnected(@NotNull Context context) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object object = context.getApplicationContext().getSystemService("wifi");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.net.wifi.WifiManager");
            }
            WifiManager wifiMgr = (WifiManager)object;
            if (wifiMgr.isWifiEnabled()) {
                WifiInfo wifiInfo;
                WifiInfo wifiInfo2 = wifiInfo = wifiMgr.getConnectionInfo();
                Intrinsics.checkExpressionValueIsNotNull((Object)wifiInfo2, (String)"wifiInfo");
                bl = wifiInfo2.getNetworkId() != -1;
            } else {
                bl = false;
            }
            return bl;
        }

        private final ConnectivityManager getConnectivityManager(Context context) {
            Object object = context.getSystemService("connectivity");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
            }
            return (ConnectivityManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

