/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.utils;

import android.app.Activity;
import android.content.Context;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\"\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J1\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\"\u00020\t2\u0006\u0010\u0012\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0013J/\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\"\u00020\t2\u0006\u0010\u0012\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/merseyside/utils/PermissionManager;", "", "()V", "isPermissionsGranted", "", "context", "Landroid/content/Context;", "permissions", "", "", "(Landroid/content/Context;[Ljava/lang/String;)Z", "isRequestCodeValid", "code", "", "requestPermissions", "", "activity", "Landroid/app/Activity;", "requestCode", "(Landroid/app/Activity;[Ljava/lang/String;I)V", "fragment", "Landroidx/fragment/app/Fragment;", "(Landroidx/fragment/app/Fragment;[Ljava/lang/String;I)V", "utils_release"})
public final class PermissionManager {
    public static final PermissionManager INSTANCE;

    public final void requestPermissions(@Nullable Activity activity, @NotNull String[] permissions, int requestCode) {
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        if (this.isRequestCodeValid(requestCode)) {
            if (!this.isPermissionsGranted((Context)activity, Arrays.copyOf(permissions, permissions.length))) {
                Activity activity2 = activity;
                if (activity2 == null) {
                    Intrinsics.throwNpe();
                }
                ActivityCompat.requestPermissions((Activity)activity2, (String[])permissions, (int)requestCode);
            }
        } else {
            throw (Throwable)new IllegalArgumentException("Request code is not valid");
        }
    }

    public final void requestPermissions(@NotNull Fragment fragment, @NotNull String[] permissions, int requestCode) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        if (this.isRequestCodeValid(requestCode)) {
            if (!this.isPermissionsGranted(fragment.getContext(), Arrays.copyOf(permissions, permissions.length))) {
                fragment.requestPermissions(permissions, requestCode);
            }
        } else {
            throw (Throwable)new IllegalArgumentException("Request code is not valid");
        }
    }

    public final boolean isPermissionsGranted(@Nullable Context context, String ... permissions) {
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        for (String permission : permissions) {
            int granted;
            Context context2 = context;
            if (context2 == null) {
                Intrinsics.throwNpe();
            }
            if ((granted = ContextCompat.checkSelfPermission((Context)context2, (String)permission)) == 0) continue;
            return false;
        }
        return true;
    }

    private final boolean isRequestCodeValid(int code) {
        double d = 2.0;
        double d2 = 16.0;
        double d3 = code;
        boolean bl = false;
        double d4 = Math.pow(d, d2);
        return d3 <= d4 - 1.0;
    }

    private PermissionManager() {
    }

    static {
        PermissionManager permissionManager;
        INSTANCE = permissionManager = new PermissionManager();
    }
}

