/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.merseyLib.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.view.KeyCharacterMap;
import android.view.ViewConfiguration;
import androidx.core.content.ContextCompat;
import com.merseyside.merseyLib.utils.LibUtils$sam$java_lang_Runnable$0;
import com.merseyside.merseyLib.utils.LocaleManager;
import com.merseyside.merseyLib.utils.time.TimeUnit;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.CharRange;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u0016\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u001a\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007\u001a\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u000e\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u000e\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u0006\u0010\u001d\u001a\u00020\u001c\u001a\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\u001f\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u001a\u0016\u0010 \u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0010\u001a\u000e\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u0001\u001a\u000e\u0010$\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019\u00a8\u0006%"}, d2={"convertDpToPixel", "", "context", "Landroid/content/Context;", "dp", "convertPixelsToDp", "px", "", "delayedMainThread", "Landroid/os/Handler;", "delay", "Lcom/merseyside/merseyLib/utils/time/TimeUnit;", "onMain", "Lkotlin/Function0;", "", "generateRandomString", "", "length", "getApplicationName", "getLocalizedContext", "localeManager", "Lcom/merseyside/merseyLib/utils/LocaleManager;", "getNavigationBarHeight", "getNumberOfDigits", "number", "", "getWindowWidth", "isExternalStorageReadable", "", "isMainThread", "isTablet", "mainThread", "openUrl", "url", "randomBool", "positiveProbability", "shrinkNumber", "utils_release"})
@JvmName(name="LibUtils")
public final class LibUtils {
    @NotNull
    public static final Context getLocalizedContext(@NotNull LocaleManager localeManager) {
        Intrinsics.checkParameterIsNotNull((Object)localeManager, (String)"localeManager");
        CharSequence charSequence = localeManager.getLanguage();
        boolean bl = false;
        return charSequence.length() > 0 ? localeManager.setLocale() : localeManager.getContext();
    }

    public static final boolean randomBool(float positiveProbability) {
        java.util.Random rand;
        return positiveProbability >= 1.0f ? true : (positiveProbability <= 0.0f ? false : (rand = new java.util.Random()).nextFloat() <= positiveProbability);
    }

    public static final float convertPixelsToDp(@NotNull Context context, int px) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        float density = resources.getDisplayMetrics().density;
        return (float)px / density;
    }

    public static final float convertDpToPixel(@NotNull Context context, float dp) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        float density = resources.getDisplayMetrics().density;
        return dp * density;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String generateRandomString(int length) {
        if (length > 0) {
            Constable constable;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            char c = 'a';
            CharRange charRange = new CharRange(c, 'z');
            c = 'A';
            CharRange charRange2 = new CharRange(c, 'Z');
            c = '0';
            List charPool = CollectionsKt.plus((Collection)CollectionsKt.plus((Iterable)((Iterable)charRange), (Iterable)((Iterable)charRange2)), (Iterable)((Iterable)new CharRange(c, '9')));
            c = '\u0001';
            Iterable $this$map$iv = (Iterable)new IntRange((int)c, length);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                collection = destination$iv$iv;
                boolean bl = false;
                constable = Random.Default.nextInt(0, charPool.size());
                collection.add(constable);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p1;
                int it = ((Number)item$iv$iv).intValue();
                collection = destination$iv$iv;
                boolean bl = false;
                constable = Character.valueOf(((Character)charPool.get((int)p1)).charValue());
                collection.add(constable);
            }
            return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        }
        return "";
    }

    public static final int getWindowWidth(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        DisplayMetrics metrics = resources.getDisplayMetrics();
        return metrics.widthPixels;
    }

    public static final int getNavigationBarHeight(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        int result = 0;
        boolean hasMenuKey = ViewConfiguration.get((Context)context).hasPermanentMenuKey();
        boolean hasBackKey = KeyCharacterMap.deviceHasKey((int)4);
        if (!hasMenuKey && !hasBackKey) {
            Resources resources = context.getResources();
            Resources resources2 = context.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources2, (String)"context.resources");
            int orientation = resources2.getConfiguration().orientation;
            int resourceId = 0;
            int n = LibUtils.isTablet(context) ? resources.getIdentifier(orientation == 1 ? "navigation_bar_height" : "navigation_bar_height_landscape", "dimen", "android") : (resourceId = resources.getIdentifier(orientation == 1 ? "navigation_bar_height" : "navigation_bar_width", "dimen", "android"));
            if (resourceId > 0) {
                return context.getResources().getDimensionPixelSize(resourceId);
            }
        }
        return result;
    }

    public static final boolean isTablet(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return (resources.getConfiguration().screenLayout & 0xF) >= 3;
    }

    @Nullable
    public static final String getApplicationName(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfo, (String)"context.applicationInfo");
        ApplicationInfo applicationInfo2 = applicationInfo;
        int stringId = applicationInfo2.labelRes;
        return stringId == 0 ? ((Object)applicationInfo2.nonLocalizedLabel).toString() : context.getString(stringId);
    }

    @NotNull
    public static final Handler mainThread(@NotNull Function0<Unit> onMain) {
        Intrinsics.checkParameterIsNotNull(onMain, (String)"onMain");
        Handler handler = new Handler(Looper.getMainLooper());
        Function0<Unit> function0 = onMain;
        handler.post((Runnable)new LibUtils$sam$java_lang_Runnable$0(function0));
        return handler;
    }

    @NotNull
    public static final Handler delayedMainThread(@NotNull TimeUnit delay, @NotNull Function0<Unit> onMain) {
        Intrinsics.checkParameterIsNotNull((Object)delay, (String)"delay");
        Intrinsics.checkParameterIsNotNull(onMain, (String)"onMain");
        Handler handler = new Handler(Looper.getMainLooper());
        Function0<Unit> function0 = onMain;
        handler.postDelayed((Runnable)new LibUtils$sam$java_lang_Runnable$0(function0), delay.toMillisLong());
        return handler;
    }

    public static final boolean isMainThread() {
        return Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper());
    }

    public static final boolean isExternalStorageReadable() {
        String state = Environment.getExternalStorageState();
        return Intrinsics.areEqual((Object)"mounted", (Object)state) || Intrinsics.areEqual((Object)"mounted_ro", (Object)state);
    }

    public static final int getNumberOfDigits(@NotNull Number number) throws NumberFormatException {
        Intrinsics.checkParameterIsNotNull((Object)number, (String)"number");
        String str = String.valueOf(number.longValue());
        return str.length();
    }

    @NotNull
    public static final String shrinkNumber(@NotNull Number number) {
        Intrinsics.checkParameterIsNotNull((Object)number, (String)"number");
        long l = number.longValue();
        return l < (long)1000 ? String.valueOf(l) : (l < (long)1000000 ? l / (long)1000 + "K+" : l / (long)1000000 + "M+");
    }

    public static final void openUrl(@NotNull Context context, @NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        ContextCompat.startActivity((Context)context, (Intent)browserIntent, null);
    }
}

