/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.merseyLib.utils;

import android.app.Activity;
import android.content.Context;
import androidx.core.app.ActivityCompat;
import androidx.fragment.app.Fragment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J+\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0013J)\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/merseyside/merseyLib/utils/PermissionsManager;", "", "()V", "isPermissionsGranted", "", "context", "Landroid/content/Context;", "PERMISSIONS_STORAGE", "", "", "(Landroid/content/Context;[Ljava/lang/String;)Z", "isRequestCodeValid", "code", "", "verifyStoragePermissions", "", "activity", "Landroid/app/Activity;", "PERMISSIONS", "(Landroid/app/Activity;[Ljava/lang/String;I)V", "fragment", "Landroidx/fragment/app/Fragment;", "(Landroidx/fragment/app/Fragment;[Ljava/lang/String;I)V", "utils_release"})
public final class PermissionsManager {
    public static final PermissionsManager INSTANCE;

    public final void verifyStoragePermissions(@Nullable Activity activity, @NotNull String[] PERMISSIONS, int code) {
        Intrinsics.checkParameterIsNotNull((Object)PERMISSIONS, (String)"PERMISSIONS");
        if (this.isRequestCodeValid(code)) {
            if (!this.isPermissionsGranted((Context)activity, PERMISSIONS)) {
                Activity activity2 = activity;
                if (activity2 == null) {
                    Intrinsics.throwNpe();
                }
                ActivityCompat.requestPermissions((Activity)activity2, (String[])PERMISSIONS, (int)code);
            }
        } else {
            throw (Throwable)new IllegalArgumentException("Request code is not valid");
        }
    }

    public final void verifyStoragePermissions(@NotNull Fragment fragment, @NotNull String[] PERMISSIONS, int code) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)PERMISSIONS, (String)"PERMISSIONS");
        if (this.isRequestCodeValid(code)) {
            if (!this.isPermissionsGranted(fragment.getContext(), PERMISSIONS)) {
                fragment.requestPermissions(PERMISSIONS, code);
            }
        } else {
            throw (Throwable)new IllegalArgumentException("Request code is not valid");
        }
    }

    public final boolean isPermissionsGranted(@Nullable Context context, @NotNull String[] PERMISSIONS_STORAGE) {
        Intrinsics.checkParameterIsNotNull((Object)PERMISSIONS_STORAGE, (String)"PERMISSIONS_STORAGE");
        for (String permission : PERMISSIONS_STORAGE) {
            int granted;
            Context context2 = context;
            if (context2 == null) {
                Intrinsics.throwNpe();
            }
            if ((granted = ActivityCompat.checkSelfPermission((Context)context2, (String)permission)) == 0) continue;
            return false;
        }
        return true;
    }

    private final boolean isRequestCodeValid(int code) {
        double d = 2.0;
        double d2 = 16.0;
        double d3 = code;
        boolean bl = false;
        double d4 = Math.pow(d, d2);
        return d3 <= d4 - 1.0;
    }

    private PermissionsManager() {
    }

    static {
        PermissionsManager permissionsManager;
        INSTANCE = permissionsManager = new PermissionsManager();
    }
}

