/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.archy.presentation.view.circleView;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.ColorInt;
import com.merseyside.archy.R;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 %2\u00020\u0001:\u0001%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u001a\u001a\u00020\u00172\b\b\u0001\u0010\u001b\u001a\u00020\bH\u0002J\u0012\u0010\u001c\u001a\u00020\u00172\b\b\u0001\u0010\u001b\u001a\u00020\bH\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0012\u0010\u001e\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014J\u0018\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\bH\u0014J\u0010\u0010\"\u001a\u00020\u00172\b\b\u0001\u0010\u001b\u001a\u00020\bJ\u000e\u0010#\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010$\u001a\u00020\u00172\b\b\u0001\u0010\u001b\u001a\u00020\bR\u0012\u0010\u0007\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/merseyside/archy/presentation/view/circleView/CircleTextView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attributeSet", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "circleColor", "", "circleTextColor", "font", "Landroid/graphics/Typeface;", "paint", "Landroid/graphics/Paint;", "rect", "Landroid/graphics/Rect;", "size", "text", "", "textColor", "textPaint", "textSize", "drawCenter", "", "canvas", "Landroid/graphics/Canvas;", "initCirclePaint", "color", "initTextPaint", "loadAttrs", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "setColor", "setText", "setTextColor", "Companion", "archy_release"})
public final class CircleTextView
extends View {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int size;
    @ColorInt
    private int circleColor;
    @ColorInt
    private int circleTextColor;
    @ColorInt
    private int textColor;
    @NotNull
    private String text;
    private Paint paint;
    private Paint textPaint;
    @NotNull
    private Rect rect;
    private int textSize;
    @Nullable
    private Typeface font;
    @NotNull
    private static final String TAG = "CircleView";

    public CircleTextView(@NotNull Context context, @NotNull AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attributeSet, (String)"attributeSet");
        super(context, attributeSet);
        this.circleColor = -16777216;
        this.circleTextColor = -1;
        this.textColor = -16777216;
        this.text = "";
        this.loadAttrs(attributeSet);
        this.initCirclePaint(this.circleColor);
        this.initTextPaint(this.circleTextColor);
        this.rect = new Rect();
    }

    private final void loadAttrs(AttributeSet attributeSet) {
        Object object = this.getContext().getTheme().obtainStyledAttributes(attributeSet, R.styleable.CircleTextView, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.theme.obtainStyl\u2026ble.CircleTextView, 0, 0)");
        TypedArray array = object;
        this.circleColor = array.getColor(R.styleable.CircleTextView_\u0441olor, this.circleColor);
        object = array.getString(R.styleable.CircleTextView_text);
        this.text = object == null ? this.text : object;
        this.circleTextColor = array.getColor(R.styleable.CircleTextView_textColor, this.circleTextColor);
        this.textColor = array.getColor(R.styleable.CircleTextView_textColor, this.textColor);
        this.textSize = array.getDimensionPixelSize(R.styleable.CircleTextView_android_textSize, 0);
        object = array.getString(R.styleable.CircleTextView_font);
        if (object != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            CharSequence charSequence = (CharSequence)it;
            boolean bl4 = false;
            if (charSequence.length() > 0) {
                this.font = Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)Intrinsics.stringPlus((String)"fonts/", (Object)it));
            }
        }
        array.recycle();
    }

    private final void initCirclePaint(@ColorInt int color) {
        Paint paint;
        this.paint = new Paint(1);
        Paint paint2 = this.paint;
        if (paint2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"paint");
            paint = null;
        } else {
            paint = paint2;
        }
        paint.setColor(color);
    }

    private final void initTextPaint(@ColorInt int color) {
        Paint paint;
        Paint paint2;
        Paint paint3;
        this.textPaint = new Paint(1);
        Paint paint4 = this.textPaint;
        if (paint4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"textPaint");
            paint3 = null;
        } else {
            paint3 = paint4;
        }
        paint3.setTextAlign(Paint.Align.CENTER);
        paint4 = this.textPaint;
        if (paint4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"textPaint");
            paint2 = null;
        } else {
            paint2 = paint4;
        }
        paint2.setColor(color);
        paint4 = this.textPaint;
        if (paint4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"textPaint");
            paint = null;
        } else {
            paint = paint4;
        }
        paint.setTextSize((float)this.textSize);
        if (this.font != null) {
            Paint paint5;
            paint4 = this.textPaint;
            if (paint4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textPaint");
                paint5 = null;
            } else {
                paint5 = paint4;
            }
            paint5.setTypeface(this.font);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height = View.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        int width = View.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        boolean bl = false;
        this.size = Math.min(width, height);
        this.setMeasuredDimension(this.size, this.size);
        if (this.textSize == 0) {
            Paint paint;
            this.textSize = this.size / 2;
            Paint paint2 = this.textPaint;
            if (paint2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textPaint");
                paint = null;
            } else {
                paint = paint2;
            }
            paint.setTextSize((float)this.textSize);
        }
        this.rect.set(0, 0, this.size, this.size);
    }

    protected void onDraw(@Nullable Canvas canvas) {
        super.onDraw(canvas);
        Canvas canvas2 = canvas;
        if (canvas2 != null) {
            Paint paint;
            Paint paint2;
            Canvas canvas3 = canvas2;
            boolean bl = false;
            boolean bl2 = false;
            Canvas it = canvas3;
            boolean bl3 = false;
            float point = this.size / 2;
            Paint paint3 = this.paint;
            if (paint3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"paint");
                paint2 = null;
            } else {
                paint2 = paint3;
            }
            canvas.drawCircle(point, point, point, paint2);
            paint3 = this.textPaint;
            if (paint3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textPaint");
                paint = null;
            } else {
                paint = paint3;
            }
            this.drawCenter(canvas, this.rect, paint, this.text);
        }
    }

    private final void drawCenter(Canvas canvas, Rect rect, Paint paint, String text) {
        canvas.getClipBounds(rect);
        int cHeight = rect.height();
        int cWidth = rect.width();
        paint.setTextAlign(Paint.Align.LEFT);
        paint.getTextBounds(text, 0, text.length(), rect);
        float x = (float)cWidth / 2.0f - (float)rect.width() / 2.0f - (float)rect.left;
        float y = (float)cHeight / 2.0f + (float)rect.height() / 2.0f - (float)rect.bottom;
        canvas.drawText(text, x, y, paint);
    }

    public final void setText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        CharSequence charSequence = text;
        boolean bl = false;
        this.text = charSequence.length() == 0 ? "?" : text;
        this.invalidate();
    }

    public final void setColor(@ColorInt int color) {
        this.circleColor = color;
        this.initCirclePaint(color);
        this.invalidate();
    }

    public final void setTextColor(@ColorInt int color) {
        this.circleTextColor = color;
        this.initTextPaint(color);
        this.invalidate();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/merseyside/archy/presentation/view/circleView/CircleTextView$Companion;", "", "()V", "TAG", "", "archy_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

