/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.archy.data.cache;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.CallSuper;
import com.merseyside.archy.data.cache.CacheFileManager;
import com.merseyside.archy.data.cache.serializer.Serializer;
import com.merseyside.archy.domain.executor.ThreadExecutor;
import io.reactivex.Observable;
import io.reactivex.exceptions.UndeliverableException;
import java.io.File;
import java.lang.reflect.ParameterizedType;

public abstract class BaseCache<T> {
    private final String TAG = "BaseCache";
    private final File cacheDir;
    private final Serializer serializer;
    private final CacheFileManager fileManager;
    private final ThreadExecutor threadExecutor;
    private Class<T> persistentClass;

    public BaseCache(Context context, Serializer serializer2, CacheFileManager fileManager, ThreadExecutor executor) {
        if (context == null || serializer2 == null || fileManager == null || executor == null) {
            throw new IllegalArgumentException("Invalid null parameter");
        }
        Context context1 = context.getApplicationContext();
        this.cacheDir = context1.getCacheDir();
        this.serializer = serializer2;
        this.fileManager = fileManager;
        this.threadExecutor = executor;
        this.persistentClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public abstract String getCacheFilename();

    public abstract String getCacheDirName();

    public Observable<T> get() {
        return Observable.create(emitter -> {
            File userEntityFile = this.buildFile();
            String fileContent = this.fileManager.readFileContent(userEntityFile);
            T entity = this.serializer.deserialize(fileContent, this.persistentClass);
            try {
                if (entity != null) {
                    emitter.onNext(entity);
                    emitter.onComplete();
                } else {
                    emitter.onError((Throwable)new Exception());
                }
            }
            catch (UndeliverableException undeliverableException) {
                // empty catch block
            }
        });
    }

    @CallSuper
    public boolean put(T entity) {
        this.executeAsynchronously(new CacheEvictor(this.fileManager, this.buildFile()));
        if (entity != null) {
            File cacheFile = this.buildFile();
            String jsonString = this.serializer.serialize(entity, this.persistentClass);
            this.executeAsynchronously(new CacheWriter(this.fileManager, cacheFile, jsonString));
            return true;
        }
        return false;
    }

    public boolean isCached() {
        File userEntityFile = this.buildFile();
        return this.fileManager.exists(userEntityFile);
    }

    public String getFullPath() {
        File file = this.buildFile();
        return file.getPath();
    }

    private File buildFile() {
        String dir = "";
        if (!TextUtils.isEmpty((CharSequence)this.getCacheDirName())) {
            File file = new File(this.cacheDir.getPath() + File.separator + this.getCacheDirName());
            if (!file.exists()) {
                file.mkdirs();
            }
            dir = File.separator + this.getCacheDirName();
        }
        String fileNameBuilder = this.cacheDir.getPath() + dir + File.separator + this.getCacheFilename();
        return new File(fileNameBuilder);
    }

    void evict() {
        this.executeAsynchronously(new CacheEvictor(this.fileManager, this.buildFile()));
    }

    private void executeAsynchronously(Runnable runnable) {
        this.threadExecutor.execute(runnable);
    }

    private static class CacheEvictor
    implements Runnable {
        private final CacheFileManager fileManager;
        private final File cacheFile;

        CacheEvictor(CacheFileManager fileManager, File cacheFile) {
            this.fileManager = fileManager;
            this.cacheFile = cacheFile;
        }

        @Override
        public void run() {
            this.fileManager.deleteFile(this.cacheFile);
        }
    }

    private static class CacheWriter
    implements Runnable {
        private final CacheFileManager fileManager;
        private final File fileToWrite;
        private final String fileContent;

        CacheWriter(CacheFileManager fileManager, File fileToWrite, String fileContent) {
            this.fileManager = fileManager;
            this.fileToWrite = fileToWrite;
            this.fileContent = fileContent;
        }

        @Override
        public void run() {
            this.fileManager.writeToFile(this.fileToWrite, this.fileContent);
        }
    }
}

