/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.archy;

import android.app.Application;
import android.content.Context;
import androidx.annotation.StringRes;
import com.merseyside.utils.LibUtils;
import com.merseyside.utils.LocaleManager;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0014J-\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\u0012\"\u00020\u000eH\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0006\u0010\u0015\u001a\u00020\u000eJ\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u000eR\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/merseyside/archy/BaseApplication;", "Landroid/app/Application;", "()V", "<set-?>", "Landroid/content/Context;", "context", "getContext", "()Landroid/content/Context;", "localeManager", "Lcom/merseyside/utils/LocaleManager;", "attachBaseContext", "", "base", "getActualString", "", "id", "", "args", "", "getActualString$archy_release", "(I[Ljava/lang/String;)Ljava/lang/String;", "getLanguage", "getLocale", "Ljava/util/Locale;", "setLanguage", "language", "archy_release"})
public abstract class BaseApplication
extends Application {
    private LocaleManager localeManager;
    private Context context;

    @NotNull
    public final Context getContext() {
        Context context = this.context;
        if (context != null) {
            return context;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        return null;
    }

    protected void attachBaseContext(@NotNull Context base) {
        LocaleManager localeManager;
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        LocaleManager localeManager2 = this.localeManager = new LocaleManager(base);
        if (localeManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localeManager");
            localeManager = null;
        } else {
            localeManager = localeManager2;
        }
        this.context = LibUtils.getLocalizedContext((LocaleManager)localeManager);
        super.attachBaseContext(this.getContext());
    }

    @NotNull
    public final Context setLanguage(@NotNull String language) {
        LocaleManager localeManager;
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        LocaleManager localeManager2 = this.localeManager;
        if (localeManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localeManager");
            localeManager = null;
        } else {
            localeManager = localeManager2;
        }
        this.context = localeManager.setNewLocale(language);
        return this.getContext();
    }

    @NotNull
    public final String getLanguage() {
        LocaleManager localeManager;
        LocaleManager localeManager2 = this.localeManager;
        if (localeManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localeManager");
            localeManager = null;
        } else {
            localeManager = localeManager2;
        }
        return localeManager.getLanguage();
    }

    @NotNull
    public final String getActualString$archy_release(@StringRes int id, String ... args) throws Exception {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String string = this.getContext().getString(id, (Object[])Arrays.copyOf(args, args.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.getString(id, *args)");
        return string;
    }

    @NotNull
    public final Locale getLocale() {
        LocaleManager localeManager;
        LocaleManager localeManager2 = this.localeManager;
        if (localeManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localeManager");
            localeManager = null;
        } else {
            localeManager = localeManager2;
        }
        return localeManager.getCurrentLocale();
    }
}

