/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.archy.presentation.view.localeViews;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.StringRes;
import com.google.android.material.textfield.TextInputLayout;
import com.merseyside.archy.R;
import com.merseyside.archy.presentation.activity.BaseActivity;
import com.merseyside.archy.presentation.view.localeViews.ILocaleTextInputLayout;
import com.merseyside.archy.presentation.view.localeViews.ILocaleView;
import com.merseyside.archy.presentation.view.localeViews.LocaleData;
import com.merseyside.utils.ext.LoggerExtKt;
import com.merseyside.utils.ext.ViewExtKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0017\u001a\u00020\u0004H\u0016J\b\u0010\u0018\u001a\u00020\u0001H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002R\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\"\u0010\u0010\u001a\u0004\u0018\u00010\u00118\u0016@\u0016X\u0097\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0016\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lcom/merseyside/archy/presentation/view/localeViews/LocaleTextInputLayout;", "Lcom/google/android/material/textfield/TextInputLayout;", "Lcom/merseyside/archy/presentation/view/localeViews/ILocaleTextInputLayout;", "context", "Landroid/content/Context;", "attributeSet", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "hintArgs", "", "", "getHintArgs", "()[Ljava/lang/String;", "setHintArgs", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "hintId", "", "getHintId", "()Ljava/lang/Integer;", "setHintId", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getLocaleContext", "getView", "loadAttrs", "", "archy_release"})
public final class LocaleTextInputLayout
extends TextInputLayout
implements ILocaleTextInputLayout {
    @StringRes
    @Nullable
    private Integer hintId;
    @NotNull
    private String[] hintArgs;

    public LocaleTextInputLayout(@NotNull Context context, @NotNull AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attributeSet, (String)"attributeSet");
        super(context, attributeSet);
        this.hintArgs = new String[0];
        this.loadAttrs(attributeSet);
        ILocaleView.DefaultImpls.updateLocale$default(this, null, 1, null);
    }

    @Override
    @Nullable
    public Integer getHintId() {
        return this.hintId;
    }

    @Override
    public void setHintId(@Nullable Integer n) {
        this.hintId = n;
    }

    @Override
    @NotNull
    public String[] getHintArgs() {
        return this.hintArgs;
    }

    @Override
    public void setHintArgs(@NotNull String[] stringArray) {
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"<set-?>");
        this.hintArgs = stringArray;
    }

    private final void loadAttrs(AttributeSet attributeSet) {
        TypedArray typedArray = this.getContext().getTheme().obtainStyledAttributes(attributeSet, R.styleable.LocaleTextInputLayout, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyledAttributes(\n            attributeSet, R.styleable.LocaleTextInputLayout, 0, 0)");
        TypedArray array = typedArray;
        this.setHintId((Integer)LoggerExtKt.log$default((Object)array.getResourceId(R.styleable.LocaleTextInputLayout_android_hint, 0), null, (int)1, null));
        array.recycle();
    }

    @Override
    @NotNull
    public TextInputLayout getView() {
        return this;
    }

    @Override
    @NotNull
    public Context getLocaleContext() {
        return ((BaseActivity)ViewExtKt.getActivity((View)((View)this))).getContext();
    }

    @Override
    @NotNull
    public String getString(@StringRes int id, String ... args) {
        return ILocaleTextInputLayout.DefaultImpls.getString((ILocaleTextInputLayout)this, id, args);
    }

    @Override
    @Nullable
    public String getString(@StringRes @Nullable Integer id, String ... args) {
        return ILocaleTextInputLayout.DefaultImpls.getString((ILocaleTextInputLayout)this, id, args);
    }

    @Override
    @Nullable
    public String getString(@NotNull Context context, @StringRes @Nullable Integer id, String ... args) {
        return ILocaleTextInputLayout.DefaultImpls.getString((ILocaleTextInputLayout)this, context, id, args);
    }

    @Override
    public void setHint(@StringRes int id, String ... args) {
        ILocaleTextInputLayout.DefaultImpls.setHint((ILocaleTextInputLayout)this, id, args);
    }

    @Override
    public void setHint(@StringRes @Nullable Integer id, String ... args) {
        ILocaleTextInputLayout.DefaultImpls.setHint((ILocaleTextInputLayout)this, id, args);
    }

    @Override
    public void setHint(@NotNull Context context, @StringRes @Nullable Integer id, String ... args) {
        ILocaleTextInputLayout.DefaultImpls.setHint((ILocaleTextInputLayout)this, context, id, args);
    }

    @Override
    public void setHint(@Nullable LocaleData localeData) {
        ILocaleTextInputLayout.DefaultImpls.setHint(this, localeData);
    }

    @Override
    public void updateLocale(@NotNull Context context) {
        ILocaleTextInputLayout.DefaultImpls.updateLocale(this, context);
    }
}

