/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.animators.animator;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.view.View;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import com.merseyside.animators.Axis;
import com.merseyside.animators.BaseAnimatorBuilder;
import com.merseyside.animators.BaseSingleAnimator;
import com.merseyside.animators.MainPoint;
import com.merseyside.animators.animator.TransitionAnimator;
import com.merseyside.utils.Logger;
import com.merseyside.utils.ext.LoggerExtKt;
import com.merseyside.utils.time.TimeUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0005B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0006"}, d2={"Lcom/merseyside/animators/animator/TransitionAnimator;", "Lcom/merseyside/animators/BaseSingleAnimator;", "builder", "Lcom/merseyside/animators/animator/TransitionAnimator$Builder;", "(Lcom/merseyside/animators/animator/TransitionAnimator$Builder;)V", "Builder", "animators_release"})
public final class TransitionAnimator
extends BaseSingleAnimator {
    public TransitionAnimator(@NotNull Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super(builder);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\r\u0010\u001b\u001a\u00020\u001cH\u0010\u00a2\u0006\u0002\b\u001dJ\u0019\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0010\u00a2\u0006\u0002\b\u001fJ\u0019\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0010\u00a2\u0006\u0002\b!J4\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\u00182\u0018\u0010#\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\u0018H\u0002J*\u0010$\u001a\u00020%2\u0018\u0010&\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0'2\u0006\u0010\b\u001a\u00020\tH\u0002J?\u0010(\u001a\u00020)2*\u0010#\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0*\"\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010+J?\u0010,\u001a\u00020)2*\u0010-\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0*\"\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010+J2\u0010.\u001a\u00020\u001c2\u0018\u0010/\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R'\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\"\u0010\u0017\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/merseyside/animators/animator/TransitionAnimator$Builder;", "Lcom/merseyside/animators/BaseAnimatorBuilder;", "Lcom/merseyside/animators/animator/TransitionAnimator;", "view", "Landroid/view/View;", "duration", "Lcom/merseyside/utils/time/TimeUnit;", "(Landroid/view/View;Lcom/merseyside/utils/time/TimeUnit;)V", "axis", "Lcom/merseyside/animators/Axis;", "current", "Lkotlin/Pair;", "", "Lcom/merseyside/animators/MainPoint;", "getCurrent", "()Lkotlin/Pair;", "current$delegate", "Lkotlin/Lazy;", "isLogValues", "", "()Z", "setLogValues", "(Z)V", "pointList", "", "viewHeight", "viewWidth", "build", "Landroid/animation/Animator;", "build$animators_release", "calculateCurrentValue", "calculateCurrentValue$animators_release", "getCurrentValue", "getCurrentValue$animators_release", "getPixelsFromPercents", "pointPercents", "recalculateValues", "", "values", "", "setInPercents", "", "", "([Lkotlin/Pair;Lcom/merseyside/animators/Axis;)V", "setInPixels", "pointPixels", "translateAnimation", "pointFloats", "animators_release"})
    public static final class Builder
    extends BaseAnimatorBuilder<TransitionAnimator> {
        @NotNull
        private final View view;
        private float viewWidth;
        private float viewHeight;
        @NotNull
        private final Lazy current$delegate;
        @Nullable
        private List<? extends Pair<Float, ? extends MainPoint>> pointList;
        @Nullable
        private Axis axis;
        private boolean isLogValues;

        public Builder(@NotNull View view, @NotNull TimeUnit duration) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
            super(duration);
            this.view = view;
            this.viewWidth = -1.0f;
            this.viewHeight = -1.0f;
            if (this.view.getVisibility() == 8) {
                this.view.setVisibility(4);
                this.view.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                    public void onGlobalLayout() {
                        viewHeight = view.getHeight();
                        viewWidth = view.getWidth();
                        view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        view.setVisibility(8);
                    }
                });
            } else {
                this.viewWidth = this.view.getWidth();
                this.viewHeight = this.view.getHeight();
            }
            this.current$delegate = LazyKt.lazy((Function0)current.2.INSTANCE);
        }

        private final Pair<Float, MainPoint> getCurrent() {
            Lazy lazy = this.current$delegate;
            boolean bl = false;
            return (Pair)lazy.getValue();
        }

        public final boolean isLogValues() {
            return this.isLogValues;
        }

        public final void setLogValues(boolean bl) {
            this.isLogValues = bl;
        }

        public final void setInPercents(@NotNull Pair<Float, ? extends MainPoint>[] pointPercents, @NotNull Axis axis) {
            Intrinsics.checkNotNullParameter(pointPercents, (String)"pointPercents");
            Intrinsics.checkNotNullParameter((Object)((Object)axis), (String)"axis");
            this.axis = axis;
            this.pointList = this.getPixelsFromPercents(ArraysKt.toList((Object[])pointPercents));
        }

        public final void setInPixels(@NotNull Pair<Float, ? extends MainPoint>[] pointPixels, @NotNull Axis axis) {
            Intrinsics.checkNotNullParameter(pointPixels, (String)"pointPixels");
            Intrinsics.checkNotNullParameter((Object)((Object)axis), (String)"axis");
            this.axis = axis;
            this.pointList = ArraysKt.toList((Object[])pointPixels);
        }

        /*
         * WARNING - void declaration
         */
        private final Animator translateAnimation(List<? extends Pair<Float, ? extends MainPoint>> pointFloats, Axis axis, TimeUnit duration) {
            List list = CollectionsKt.toMutableList((Collection)pointFloats);
            boolean bl = false;
            boolean bl2 = false;
            List list2 = list;
            boolean bl3 = false;
            Object $this$forEachIndexed$iv = pointFloats;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            Iterator iterator = $this$forEachIndexed$iv.iterator();
            while (iterator.hasNext()) {
                void value;
                Object item$iv = iterator.next();
                int n = index$iv++;
                boolean bl4 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Pair pair = (Pair)item$iv;
                int index = n;
                boolean bl5 = false;
                if (!Intrinsics.areEqual((Object)value, this.getCurrentValue$animators_release())) continue;
                list2.set(index, this.calculateCurrentValue$animators_release());
            }
            if (pointFloats.size() == 1) {
                list2.add(0, this.calculateCurrentValue$animators_release());
                this.pointList = list2;
            }
            $this$forEachIndexed$iv = this.recalculateValues(list2, axis);
            boolean bl6 = false;
            boolean bl7 = false;
            Object it = $this$forEachIndexed$iv;
            boolean bl8 = false;
            if (this.isReverse()) {
                ArraysKt.reverse((float[])it);
            }
            Object floatArray = $this$forEachIndexed$iv;
            if (this.isLogValues) {
                Logger.INSTANCE.log((Object)this, (Object)ArraysKt.joinToString$default((float[])floatArray, null, null, null, (int)0, null, null, (int)63, null));
            }
            ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])Arrays.copyOf((float[])floatArray, ((Object)floatArray).length));
            bl2 = false;
            boolean bl9 = false;
            ValueAnimator $this$translateAnimation_u24lambda_u2d4 = valueAnimator;
            boolean bl10 = false;
            $this$translateAnimation_u24lambda_u2d4.setDuration(duration.getMillis());
            $this$translateAnimation_u24lambda_u2d4.addUpdateListener(arg_0 -> Builder.translateAnimation$lambda-4$lambda-3(this, axis, arg_0));
            list = valueAnimator;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"ofFloat(*floatArray).apply {\n                this.duration = duration.millis\n\n                addUpdateListener { valueAnimator ->\n                    val value = valueAnimator.animatedValue as Float\n\n                    if (isLogValues) {\n                        Logger.log(this@Builder, value)\n                    }\n                    when (axis) {\n                        Axis.X ->\n                            view.x = value\n\n                        Axis.Y ->\n                            view.y = value\n                    }\n                }\n            }");
            return (Animator)list;
        }

        private final List<Pair<Float, MainPoint>> getPixelsFromPercents(List<? extends Pair<Float, ? extends MainPoint>> pointPercents) {
            int n;
            Axis axis = this.axis;
            Intrinsics.checkNotNull((Object)((Object)axis));
            Object object = axis;
            int n2 = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
            switch (n2) {
                case 1: {
                    ViewParent viewParent = this.view.getParent();
                    if (viewParent == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.view.View");
                    }
                    n = ((View)viewParent).getWidth();
                    break;
                }
                case 2: {
                    ViewParent viewParent = this.view.getParent();
                    if (viewParent == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.view.View");
                    }
                    n = ((View)viewParent).getHeight();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            int parentViewSize = n;
            object = CollectionsKt.toMutableList((Collection)pointPercents);
            n2 = 0;
            boolean bl = false;
            Object list = object;
            boolean bl2 = false;
            int i = 0;
            while (i < pointPercents.size()) {
                if (!Intrinsics.areEqual(list.get(i), this.getCurrentValue$animators_release())) {
                    list.set(i, TuplesKt.to((Object)Float.valueOf((float)parentViewSize * ((Number)((Pair)list.get(i)).getFirst()).floatValue()), (Object)((Pair)list.get(i)).getSecond()));
                }
                int n3 = i;
                i = n3 + 1;
            }
            return list;
        }

        private final float[] recalculateValues(List<Pair<Float, MainPoint>> values, Axis axis) {
            float f;
            Axis axis2 = axis;
            int n = WhenMappings.$EnumSwitchMapping$0[axis2.ordinal()];
            switch (n) {
                case 1: {
                    f = this.viewWidth;
                    break;
                }
                case 2: {
                    f = this.viewHeight;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            float viewSize = f;
            float[] floatArray = new float[values.size()];
            int i = 0;
            while (i < values.size()) {
                float value = ((Number)values.get(i).getFirst()).floatValue();
                MainPoint mainPoint = (MainPoint)((Object)values.get(i).getSecond());
                int n2 = WhenMappings.$EnumSwitchMapping$1[mainPoint.ordinal()];
                switch (n2) {
                    case 1: {
                        floatArray[i] = value - viewSize / (float)2;
                        break;
                    }
                    case 2: {
                        Axis axis3 = axis;
                        int n3 = WhenMappings.$EnumSwitchMapping$0[axis3.ordinal()];
                        switch (n3) {
                            case 1: {
                                floatArray[i] = value + viewSize;
                            }
                        }
                        break;
                    }
                    case 3: {
                        Axis axis3 = axis;
                        int n3 = WhenMappings.$EnumSwitchMapping$0[axis3.ordinal()];
                        switch (n3) {
                            case 1: {
                                break;
                            }
                            case 2: {
                                Logger.INSTANCE.log(null, (Object)("value = " + value + " viewSize = " + viewSize));
                                floatArray[i] = value - viewSize;
                                LoggerExtKt.log((Object)Float.valueOf(floatArray[i]), (Object)"bottom left =");
                            }
                        }
                        break;
                    }
                    case 4: {
                        Axis axis3 = axis;
                        int n3 = WhenMappings.$EnumSwitchMapping$0[axis3.ordinal()];
                        switch (n3) {
                            case 1: {
                                floatArray[i] = value - viewSize;
                                break;
                            }
                            case 2: {
                                floatArray[i] = value - viewSize;
                            }
                        }
                        break;
                    }
                    default: {
                        floatArray[i] = value;
                    }
                }
                int n4 = i;
                i = n4 + 1;
            }
            return floatArray;
        }

        @NotNull
        public Pair<Float, MainPoint> getCurrentValue$animators_release() {
            return this.getCurrent();
        }

        @NotNull
        public Pair<Float, MainPoint> calculateCurrentValue$animators_release() {
            Pair pair;
            Axis axis = this.axis;
            int n = axis == null ? -1 : WhenMappings.$EnumSwitchMapping$0[axis.ordinal()];
            switch (n) {
                case 2: {
                    pair = TuplesKt.to((Object)Float.valueOf(this.view.getY()), (Object)((Object)MainPoint.TOP_LEFT));
                    break;
                }
                case 1: {
                    pair = TuplesKt.to((Object)Float.valueOf(this.view.getX()), (Object)((Object)MainPoint.TOP_LEFT));
                    break;
                }
                case -1: {
                    throw new NullPointerException();
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return pair;
        }

        @Override
        @NotNull
        public Animator build$animators_release() throws IllegalArgumentException {
            if (this.pointList != null && this.axis != null) {
                Object object = this.pointList;
                Intrinsics.checkNotNull(object);
                List<? extends Pair<Float, ? extends MainPoint>> list = object;
                object = this.axis;
                Intrinsics.checkNotNull(object);
                return this.translateAnimation(list, (Axis)((Object)object), this.getDuration());
            }
            throw new IllegalArgumentException("Points haven't been set");
        }

        private static final void translateAnimation$lambda-4$lambda-3(Builder this$0, Axis $axis, ValueAnimator valueAnimator) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)$axis), (String)"$axis");
            Object object = valueAnimator.getAnimatedValue();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
            }
            float value = ((Float)object).floatValue();
            if (this$0.isLogValues()) {
                Logger.INSTANCE.log((Object)this$0, (Object)Float.valueOf(value));
            }
            object = $axis;
            int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
            switch (n) {
                case 1: {
                    this$0.view.setX(value);
                    break;
                }
                case 2: {
                    this$0.view.setY(value);
                }
            }
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[Axis.values().length];
                nArray[Axis.X.ordinal()] = 1;
                nArray[Axis.Y.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[MainPoint.values().length];
                nArray[MainPoint.CENTER.ordinal()] = 1;
                nArray[MainPoint.TOP_RIGHT.ordinal()] = 2;
                nArray[MainPoint.BOTTOM_LEFT.ordinal()] = 3;
                nArray[MainPoint.BOTTOM_RIGHT.ordinal()] = 4;
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }
}

