/*
 * Decompiled with CFR 0.152.
 */
package com.merseyside.adapters.base;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.databinding.DataBindingUtil;
import androidx.databinding.ViewDataBinding;
import androidx.paging.PagedListAdapter;
import androidx.recyclerview.widget.DiffUtil;
import com.merseyside.adapters.base.HasOnItemClickListener;
import com.merseyside.adapters.base.OnItemClickListener;
import com.merseyside.adapters.model.BaseAdapterViewModel;
import com.merseyside.adapters.view.BaseBindingHolder;
import com.merseyside.utils.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u000e\b\u0001\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00050\u00042\b\u0012\u0004\u0012\u0002H\u00010\u0006:\u0002/0B\u0013\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\u0012\u001a\u00028\u00012\u0006\u0010\u0013\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H$J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016H$J\b\u0010\u001b\u001a\u00020\u0016H\u0017J\b\u0010\u001c\u001a\u00020\u0011H\u0014J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\u0018\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0016H\u0016J\u001a\u0010)\u001a\u00020#2\u0006\u0010*\u001a\u00020+2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-J\u001c\u0010.\u001a\u00020#2\u0006\u0010\u0010\u001a\u00020+2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010-H\u0002R\"\u0010\n\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/merseyside/adapters/base/BasePagedAdapter;", "M", "T", "Lcom/merseyside/adapters/model/BaseAdapterViewModel;", "Landroidx/paging/PagedListAdapter;", "Lcom/merseyside/adapters/view/BaseBindingHolder;", "Lcom/merseyside/adapters/base/HasOnItemClickListener;", "diffUtil", "Landroidx/recyclerview/widget/DiffUtil$ItemCallback;", "(Landroidx/recyclerview/widget/DiffUtil$ItemCallback;)V", "listener", "Lcom/merseyside/adapters/base/OnItemClickListener;", "getListener", "()Lcom/merseyside/adapters/base/OnItemClickListener;", "setListener", "(Lcom/merseyside/adapters/base/OnItemClickListener;)V", "networkState", "Lcom/merseyside/adapters/base/BasePagedAdapter$INetworkState;", "createItemViewModel", "obj", "(Ljava/lang/Object;)Lcom/merseyside/adapters/model/BaseAdapterViewModel;", "getBindingVariable", "", "getItemCount", "getItemViewType", "position", "getLayoutIdForPosition", "getNetworkConnectionLayout", "getNetworkConnectionModel", "getViewHolder", "binding", "Landroidx/databinding/ViewDataBinding;", "hasExtraRow", "", "onBindViewHolder", "", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setNetworkState", "newNetworkState", "Lcom/merseyside/adapters/base/BasePagedAdapter$NetworkState;", "msg", "", "setupNetworkItem", "INetworkState", "NetworkState", "adapters_release"})
public abstract class BasePagedAdapter<M, T extends BaseAdapterViewModel<M>>
extends PagedListAdapter<M, BaseBindingHolder>
implements HasOnItemClickListener<M> {
    @Nullable
    private OnItemClickListener<M> listener;
    private INetworkState networkState;

    @Override
    @Nullable
    public OnItemClickListener<M> getListener() {
        return this.listener;
    }

    @Override
    public void setListener(@Nullable OnItemClickListener<M> onItemClickListener) {
        this.listener = onItemClickListener;
    }

    @NotNull
    public BaseBindingHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        LayoutInflater layoutInflater = LayoutInflater.from((Context)parent.getContext());
        Intrinsics.checkExpressionValueIsNotNull((Object)layoutInflater, (String)"LayoutInflater.from(parent.context)");
        LayoutInflater layoutInflater2 = layoutInflater;
        ViewDataBinding viewDataBinding = DataBindingUtil.inflate((LayoutInflater)layoutInflater2, (int)viewType, (ViewGroup)parent, (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewDataBinding, (String)"DataBindingUtil.inflate(\u2026 viewType, parent, false)");
        ViewDataBinding binding = viewDataBinding;
        return this.getViewHolder(binding);
    }

    @NotNull
    protected abstract T createItemViewModel(M var1);

    protected abstract int getLayoutIdForPosition(int var1);

    protected abstract int getBindingVariable();

    @NotNull
    protected INetworkState getNetworkConnectionModel() {
        throw (Throwable)new IllegalArgumentException("You have to override this methodin order to use network states");
    }

    public int getItemViewType(int position) {
        return this.hasExtraRow() && position == this.getItemCount() - 1 ? this.getNetworkConnectionLayout() : this.getLayoutIdForPosition(position);
    }

    public void onBindViewHolder(@NotNull BaseBindingHolder holder, int position) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)holder), (String)"holder");
        if (this.hasExtraRow() && position == this.getItemCount() - 1) {
            int n = this.getBindingVariable();
            INetworkState iNetworkState = this.networkState;
            if (iNetworkState == null) {
                Intrinsics.throwNpe();
            }
            holder.bind(n, iNetworkState);
        } else {
            Object obj = this.getItem(position);
            if (obj != null) {
                holder.bind(this.getBindingVariable(), this.createItemViewModel(obj));
                holder.itemView.setOnClickListener(new View.OnClickListener(this, obj){
                    final /* synthetic */ BasePagedAdapter this$0;
                    final /* synthetic */ Object $obj;

                    public final void onClick(View it) {
                        block0: {
                            OnItemClickListener<Object> onItemClickListener = this.this$0.getListener();
                            if (onItemClickListener == null) break block0;
                            onItemClickListener.onItemClicked(this.$obj);
                        }
                    }
                    {
                        this.this$0 = basePagedAdapter;
                        this.$obj = object;
                    }
                });
            }
        }
    }

    @NotNull
    public BaseBindingHolder getViewHolder(@NotNull ViewDataBinding binding) {
        Intrinsics.checkParameterIsNotNull((Object)binding, (String)"binding");
        return new BaseBindingHolder(binding);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasExtraRow() {
        if (this.networkState == null) return false;
        INetworkState iNetworkState = this.networkState;
        if (iNetworkState == null) {
            Intrinsics.throwNpe();
        }
        if (iNetworkState.getNetworkState() == NetworkState.CONNECTED) return false;
        return true;
    }

    @LayoutRes
    public int getNetworkConnectionLayout() {
        return 0;
    }

    public int getItemCount() {
        return super.getItemCount() + (this.hasExtraRow() ? 1 : 0);
    }

    public final void setNetworkState(@NotNull NetworkState newNetworkState, @Nullable String msg) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)newNetworkState), (String)"newNetworkState");
        Logger.INSTANCE.log((Object)this, (Object)("set network state " + (Object)((Object)newNetworkState)));
        if (this.networkState == null) {
            this.networkState = this.getNetworkConnectionModel();
        }
        INetworkState iNetworkState = this.networkState;
        if (iNetworkState == null) {
            Intrinsics.throwNpe();
        }
        NetworkState previousState = iNetworkState.getNetworkState();
        boolean hadExtraRow = this.hasExtraRow();
        this.setupNetworkItem(newNetworkState, msg);
        boolean hasExtraRow = this.hasExtraRow();
        if (hadExtraRow != hasExtraRow) {
            if (hadExtraRow) {
                this.notifyItemRemoved(super.getItemCount());
            } else {
                this.notifyItemInserted(super.getItemCount());
            }
        } else if (hasExtraRow && previousState != newNetworkState) {
            this.notifyItemChanged(this.getItemCount() - 1);
        }
    }

    public static /* synthetic */ void setNetworkState$default(BasePagedAdapter basePagedAdapter, NetworkState networkState, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setNetworkState");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        basePagedAdapter.setNetworkState(networkState, string);
    }

    private final void setupNetworkItem(NetworkState networkState, String msg) {
        block1: {
            INetworkState iNetworkState = this.networkState;
            if (iNetworkState == null) break block1;
            INetworkState iNetworkState2 = iNetworkState;
            boolean bl = false;
            boolean bl2 = false;
            INetworkState $this$apply = iNetworkState2;
            boolean bl3 = false;
            $this$apply.onStateChanged(networkState);
            if (msg != null) {
                $this$apply.setMessage(msg);
            }
        }
    }

    static /* synthetic */ void setupNetworkItem$default(BasePagedAdapter basePagedAdapter, NetworkState networkState, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setupNetworkItem");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        basePagedAdapter.setupNetworkItem(networkState, string);
    }

    public BasePagedAdapter(@NotNull DiffUtil.ItemCallback<M> diffUtil) {
        Intrinsics.checkParameterIsNotNull(diffUtil, (String)"diffUtil");
        super(diffUtil);
    }

    @Override
    public void setOnItemClickListener(@Nullable OnItemClickListener<M> listener) {
        HasOnItemClickListener.DefaultImpls.setOnItemClickListener(this, listener);
    }

    @Override
    @Nullable
    public OnItemClickListener<M> getOnItemClickListener() {
        return HasOnItemClickListener.DefaultImpls.getOnItemClickListener(this);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/merseyside/adapters/base/BasePagedAdapter$NetworkState;", "", "(Ljava/lang/String;I)V", "ERROR", "NO_CONNECTION", "CONNECTED", "LOADING", "adapters_release"})
    public static final class NetworkState
    extends Enum<NetworkState> {
        public static final /* enum */ NetworkState ERROR;
        public static final /* enum */ NetworkState NO_CONNECTION;
        public static final /* enum */ NetworkState CONNECTED;
        public static final /* enum */ NetworkState LOADING;
        private static final /* synthetic */ NetworkState[] $VALUES;

        static {
            NetworkState[] networkStateArray = new NetworkState[4];
            NetworkState[] networkStateArray2 = networkStateArray;
            networkStateArray[0] = ERROR = new NetworkState();
            networkStateArray[1] = NO_CONNECTION = new NetworkState();
            networkStateArray[2] = CONNECTED = new NetworkState();
            networkStateArray[3] = LOADING = new NetworkState();
            $VALUES = networkStateArray;
        }

        public static NetworkState[] values() {
            return (NetworkState[])$VALUES.clone();
        }

        public static NetworkState valueOf(String string) {
            return Enum.valueOf(NetworkState.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001:\u0001\nJ\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H&J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\u000b"}, d2={"Lcom/merseyside/adapters/base/BasePagedAdapter$INetworkState;", "", "getNetworkState", "Lcom/merseyside/adapters/base/BasePagedAdapter$NetworkState;", "onStateChanged", "", "state", "setMessage", "msg", "", "OnRetryListener", "adapters_release"})
    public static interface INetworkState {
        public void setMessage(@NotNull String var1);

        public void onStateChanged(@NotNull NetworkState var1);

        @NotNull
        public NetworkState getNetworkState();

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/merseyside/adapters/base/BasePagedAdapter$INetworkState$OnRetryListener;", "", "onRetry", "", "adapters_release"})
        public static interface OnRetryListener {
            public void onRetry();
        }
    }
}

