/*
 * Decompiled with CFR 0.152.
 */
package in.galaxyofandroid.spinerdialog;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import in.galaxyofandroid.spinerdialog.OnSpinerItemClick;
import in.galaxyofandroid.spinerdialog.R;
import java.util.ArrayList;

public class SpinnerDialog {
    ArrayList<String> items;
    Activity context;
    String dTitle;
    String closeTitle = "Close";
    OnSpinerItemClick onSpinerItemClick;
    AlertDialog alertDialog;
    int pos;
    int style;
    boolean cancellable = false;
    boolean showKeyboard = false;

    public SpinnerDialog(Activity activity, ArrayList<String> items, String dialogTitle) {
        this.items = items;
        this.context = activity;
        this.dTitle = dialogTitle;
    }

    public SpinnerDialog(Activity activity, ArrayList<String> items, String dialogTitle, String closeTitle) {
        this.items = items;
        this.context = activity;
        this.dTitle = dialogTitle;
        this.closeTitle = closeTitle;
    }

    public SpinnerDialog(Activity activity, ArrayList<String> items, String dialogTitle, int style) {
        this.items = items;
        this.context = activity;
        this.dTitle = dialogTitle;
        this.style = style;
    }

    public SpinnerDialog(Activity activity, ArrayList<String> items, String dialogTitle, int style, String closeTitle) {
        this.items = items;
        this.context = activity;
        this.dTitle = dialogTitle;
        this.style = style;
        this.closeTitle = closeTitle;
    }

    public void bindOnSpinerListener(OnSpinerItemClick onSpinerItemClick1) {
        this.onSpinerItemClick = onSpinerItemClick1;
    }

    public void showSpinerDialog() {
        AlertDialog.Builder adb = new AlertDialog.Builder((Context)this.context);
        View v = this.context.getLayoutInflater().inflate(R.layout.dialog_layout, null);
        TextView rippleViewClose = (TextView)v.findViewById(R.id.close);
        TextView title = (TextView)v.findViewById(R.id.spinerTitle);
        rippleViewClose.setText((CharSequence)this.closeTitle);
        title.setText((CharSequence)this.dTitle);
        ListView listView = (ListView)v.findViewById(R.id.list);
        final EditText searchBox = (EditText)v.findViewById(R.id.searchBox);
        if (this.isShowKeyboard()) {
            this.showKeyboard(searchBox);
        }
        final ArrayAdapter adapter = new ArrayAdapter((Context)this.context, R.layout.items_view, this.items);
        listView.setAdapter((ListAdapter)adapter);
        adb.setView(v);
        this.alertDialog = adb.create();
        this.alertDialog.getWindow().getAttributes().windowAnimations = this.style;
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                TextView t = (TextView)view.findViewById(R.id.text1);
                for (int j = 0; j < SpinnerDialog.this.items.size(); ++j) {
                    if (!t.getText().toString().equalsIgnoreCase(SpinnerDialog.this.items.get(j).toString())) continue;
                    SpinnerDialog.this.pos = j;
                }
                SpinnerDialog.this.onSpinerItemClick.onClick(t.getText().toString(), SpinnerDialog.this.pos);
                SpinnerDialog.this.closeSpinerDialog();
            }
        });
        searchBox.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                adapter.getFilter().filter((CharSequence)searchBox.getText().toString());
            }
        });
        rippleViewClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SpinnerDialog.this.closeSpinerDialog();
            }
        });
        this.alertDialog.setCancelable(this.isCancellable());
        this.alertDialog.setCanceledOnTouchOutside(this.isCancellable());
        this.alertDialog.show();
    }

    public void closeSpinerDialog() {
        this.hideKeyboard();
        if (this.alertDialog != null) {
            this.alertDialog.dismiss();
        }
    }

    private void hideKeyboard() {
        try {
            InputMethodManager inputManager = (InputMethodManager)this.context.getSystemService("input_method");
            inputManager.hideSoftInputFromWindow(this.context.getCurrentFocus().getWindowToken(), 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showKeyboard(final EditText ettext) {
        ettext.requestFocus();
        ettext.postDelayed(new Runnable(){

            @Override
            public void run() {
                InputMethodManager keyboard = (InputMethodManager)SpinnerDialog.this.context.getSystemService("input_method");
                keyboard.showSoftInput((View)ettext, 0);
            }
        }, 200L);
    }

    private boolean isCancellable() {
        return this.cancellable;
    }

    public void setCancellable(boolean cancellable) {
        this.cancellable = cancellable;
    }

    private boolean isShowKeyboard() {
        return this.showKeyboard;
    }

    public void setShowKeyboard(boolean showKeyboard) {
        this.showKeyboard = showKeyboard;
    }
}

