/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.routing;

import java.util.ArrayList;
import org.osmdroid.bonuspack.routing.Road;
import org.osmdroid.bonuspack.routing.RoadLeg;
import org.osmdroid.bonuspack.routing.RoadNode;
import org.osmdroid.bonuspack.utils.PolylineEncoder;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class GoogleDirectionsHandler
extends DefaultHandler {
    ArrayList<Road> mRoads;
    Road mCurrentRoad;
    RoadLeg mLeg;
    RoadNode mNode;
    boolean isPolyline = false;
    boolean isOverviewPolyline = false;
    boolean isLeg = false;
    boolean isStep = false;
    boolean isDuration = false;
    boolean isDistance = false;
    boolean isBB = false;
    int mValue;
    double mLat;
    double mLng;
    double mNorth;
    double mWest;
    double mSouth;
    double mEast;
    private StringBuilder mStringBuilder = new StringBuilder(1024);

    public GoogleDirectionsHandler() {
        this.mRoads = new ArrayList();
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (localName.equals("route")) {
            this.mCurrentRoad = new Road();
            this.mRoads.add(this.mCurrentRoad);
        } else if (localName.equals("polyline")) {
            this.isPolyline = true;
        } else if (localName.equals("overview_polyline")) {
            this.isOverviewPolyline = true;
        } else if (localName.equals("leg")) {
            this.mLeg = new RoadLeg();
            this.isLeg = true;
        } else if (localName.equals("step")) {
            this.mNode = new RoadNode();
            this.isStep = true;
        } else if (localName.equals("duration")) {
            this.isDuration = true;
        } else if (localName.equals("distance")) {
            this.isDistance = true;
        } else if (localName.equals("bounds")) {
            this.isBB = true;
        }
        this.mStringBuilder.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.mStringBuilder.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (localName.equals("points")) {
            if (this.isPolyline) {
                ArrayList<GeoPoint> polyLine = PolylineEncoder.decode(this.mStringBuilder.toString(), 10, false);
                this.mCurrentRoad.mRouteHigh.addAll(polyLine);
            } else if (this.isOverviewPolyline) {
                this.mCurrentRoad.setRouteLow(PolylineEncoder.decode(this.mStringBuilder.toString(), 10, false));
            }
        } else if (localName.equals("polyline")) {
            this.isPolyline = false;
        } else if (localName.equals("overview_polyline")) {
            this.isOverviewPolyline = false;
        } else if (localName.equals("value")) {
            this.mValue = Integer.parseInt(this.mStringBuilder.toString());
        } else if (localName.equals("duration")) {
            if (this.isStep) {
                this.mNode.mDuration = this.mValue;
            } else {
                this.mLeg.mDuration = this.mValue;
            }
            this.isDuration = false;
        } else if (localName.equals("distance")) {
            if (this.isStep) {
                this.mNode.mLength = (double)this.mValue / 1000.0;
            } else {
                this.mLeg.mLength = (double)this.mValue / 1000.0;
            }
            this.isDistance = false;
        } else if (localName.equals("html_instructions")) {
            if (this.isStep) {
                String value;
                this.mNode.mInstructions = value = this.mStringBuilder.toString();
            }
        } else if (localName.equals("start_location")) {
            if (this.isStep) {
                this.mNode.mLocation = new GeoPoint(this.mLat, this.mLng);
            }
        } else if (localName.equals("step")) {
            this.mCurrentRoad.mNodes.add(this.mNode);
            this.isStep = false;
        } else if (localName.equals("leg")) {
            this.mCurrentRoad.mLegs.add(this.mLeg);
            this.isLeg = false;
        } else if (localName.equals("lat")) {
            this.mLat = Double.parseDouble(this.mStringBuilder.toString());
        } else if (localName.equals("lng")) {
            this.mLng = Double.parseDouble(this.mStringBuilder.toString());
        } else if (localName.equals("northeast")) {
            if (this.isBB) {
                this.mNorth = this.mLat;
                this.mEast = this.mLng;
            }
        } else if (localName.equals("southwest")) {
            if (this.isBB) {
                this.mSouth = this.mLat;
                this.mWest = this.mLng;
            }
        } else if (localName.equals("bounds")) {
            this.mCurrentRoad.mBoundingBox = new BoundingBox(this.mNorth, this.mEast, this.mSouth, this.mWest);
            this.isBB = false;
        }
    }
}

