/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.location;

import android.graphics.Bitmap;
import android.util.Log;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osmdroid.bonuspack.location.POI;
import org.osmdroid.bonuspack.utils.BonusPackHelper;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;

public class NominatimPOIProvider {
    public static final String NOMINATIM_POI_SERVICE = "https://nominatim.openstreetmap.org/";
    public static final String MAPQUEST_POI_SERVICE = "https://open.mapquestapi.com/nominatim/v1/";
    protected String mService = "https://nominatim.openstreetmap.org/";
    protected String mUserAgent;

    public NominatimPOIProvider(String userAgent) {
        this.mUserAgent = userAgent;
    }

    public void setService(String serviceUrl) {
        this.mService = serviceUrl;
    }

    private StringBuilder getCommonUrl(String facility, int maxResults) {
        StringBuilder urlString = new StringBuilder(this.mService);
        urlString.append("search?");
        urlString.append("format=json");
        urlString.append("&q=[" + URLEncoder.encode(facility) + "]");
        urlString.append("&limit=" + maxResults);
        urlString.append("&bounded=1");
        return urlString;
    }

    private String getUrlInside(BoundingBox bb, String type, int maxResults) {
        StringBuilder urlString = this.getCommonUrl(type, maxResults);
        urlString.append("&viewbox=" + bb.getLonWest() + "," + bb.getLatNorth() + "," + bb.getLonEast() + "," + bb.getLatSouth());
        return urlString.toString();
    }

    private String getUrlCloseTo(GeoPoint p, String type, int maxResults, double maxDistance) {
        BoundingBox bb = new BoundingBox(p.getLatitude() + maxDistance, p.getLongitude() + maxDistance, p.getLatitude() - maxDistance, p.getLongitude() - maxDistance);
        return this.getUrlInside(bb, type, maxResults);
    }

    public ArrayList<POI> getThem(String url) {
        Log.d((String)"BONUSPACK", (String)("NominatimPOIProvider:get:" + url));
        String jString = BonusPackHelper.requestStringFromUrl(url, this.mUserAgent);
        if (jString == null) {
            Log.e((String)"BONUSPACK", (String)"NominatimPOIProvider: request failed.");
            return null;
        }
        try {
            JSONArray jPlaceIds = new JSONArray(jString);
            int n = jPlaceIds.length();
            ArrayList<POI> pois = new ArrayList<POI>(n);
            Bitmap thumbnail = null;
            for (int i = 0; i < n; ++i) {
                JSONObject jPlace = jPlaceIds.getJSONObject(i);
                POI poi = new POI(POI.POI_SERVICE_NOMINATIM);
                poi.mId = jPlace.optLong("osm_id");
                poi.mLocation = new GeoPoint(jPlace.getDouble("lat"), jPlace.getDouble("lon"));
                poi.mCategory = jPlace.optString("class");
                poi.mType = jPlace.getString("type");
                poi.mDescription = jPlace.optString("display_name");
                poi.mThumbnailPath = jPlace.optString("icon", null);
                if (i == 0 && poi.mThumbnailPath != null) {
                    thumbnail = BonusPackHelper.loadBitmap(poi.mThumbnailPath);
                }
                poi.mThumbnail = thumbnail;
                pois.add(poi);
            }
            return pois;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ArrayList<POI> getPOICloseTo(GeoPoint position, String facility, int maxResults, double maxDistance) {
        String url = this.getUrlCloseTo(position, facility, maxResults, maxDistance);
        return this.getThem(url);
    }

    public ArrayList<POI> getPOIInside(BoundingBox boundingBox, String facility, int maxResults) {
        String url = this.getUrlInside(boundingBox, facility, maxResults);
        return this.getThem(url);
    }

    public ArrayList<POI> getPOIAlong(ArrayList<GeoPoint> path, String facility, int maxResults, double maxWidth) {
        StringBuilder url = this.getCommonUrl(facility, maxResults);
        url.append("&routewidth=" + maxWidth);
        url.append("&route=");
        boolean isFirst = true;
        for (GeoPoint p : path) {
            if (isFirst) {
                isFirst = false;
            } else {
                url.append(",");
            }
            String lat = Double.toString(p.getLatitude());
            lat = lat.substring(0, Math.min(lat.length(), 7));
            String lon = Double.toString(p.getLongitude());
            lon = lon.substring(0, Math.min(lon.length(), 7));
            url.append(lat + "," + lon);
        }
        return this.getThem(url.toString());
    }
}

