/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.kml;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.osmdroid.bonuspack.kml.KmlDocument;
import org.osmdroid.bonuspack.kml.Style;
import org.osmdroid.bonuspack.kml.StyleSelector;

public class StyleMap
extends StyleSelector
implements Parcelable {
    protected HashMap<String, String> mPairs;
    public static final Parcelable.Creator<StyleMap> CREATOR = new Parcelable.Creator<StyleMap>(){

        public StyleMap createFromParcel(Parcel source) {
            return new StyleMap(source);
        }

        public StyleMap[] newArray(int size) {
            return new StyleMap[size];
        }
    };

    public StyleMap() {
        this.mPairs = new HashMap();
    }

    public void setPair(String key, String styleUrl) {
        this.mPairs.put(key, styleUrl);
    }

    public String getStyleUrl(String key) {
        return this.mPairs.get(key);
    }

    public Style getNormalStyle(KmlDocument doc) {
        return doc.getStyle(this.getStyleUrl("normal"));
    }

    @Override
    public void writeAsKML(Writer writer, String styleId) {
        try {
            writer.write("<StyleMap id='" + styleId + "'>\n");
            for (Map.Entry<String, String> entry : this.mPairs.entrySet()) {
                String key = entry.getKey();
                String styleUrl = entry.getValue();
                writer.write("<Pair><key>" + key + "</key><styleUrl>" + styleUrl + "</styleUrl></Pair>\n");
            }
            writer.write("</StyleMap>\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mPairs.size());
        for (String key : this.mPairs.keySet()) {
            out.writeString(key);
            out.writeString(this.mPairs.get(key));
        }
    }

    public StyleMap(Parcel in) {
        int size = in.readInt();
        this.mPairs = new HashMap(size);
        for (int i = 0; i < size; ++i) {
            String key = in.readString();
            String value = in.readString();
            this.mPairs.put(key, value);
        }
    }
}

