/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.kml;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.osmdroid.bonuspack.kml.KmlDocument;
import org.osmdroid.bonuspack.kml.KmlFeature;
import org.osmdroid.bonuspack.kml.KmlGeometry;
import org.osmdroid.bonuspack.kml.KmlPlacemark;
import org.osmdroid.bonuspack.kml.Style;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.Marker;
import org.osmdroid.views.overlay.Overlay;

public class KmlPoint
extends KmlGeometry
implements Parcelable,
Cloneable {
    public static final Parcelable.Creator<KmlPoint> CREATOR = new Parcelable.Creator<KmlPoint>(){

        public KmlPoint createFromParcel(Parcel source) {
            return new KmlPoint(source);
        }

        public KmlPoint[] newArray(int size) {
            return new KmlPoint[size];
        }
    };

    public KmlPoint() {
    }

    public KmlPoint(GeoPoint position) {
        this();
        this.setPosition(position);
    }

    public KmlPoint(JsonObject json) {
        this();
        JsonElement coordinates = json.get("coordinates");
        if (coordinates != null) {
            this.setPosition(KmlGeometry.parseGeoJSONPosition(coordinates.getAsJsonArray()));
        }
    }

    public void setPosition(GeoPoint position) {
        if (this.mCoordinates == null) {
            this.mCoordinates = new ArrayList(1);
            this.mCoordinates.add(position);
        } else {
            this.mCoordinates.set(0, position);
        }
    }

    public GeoPoint getPosition() {
        return (GeoPoint)this.mCoordinates.get(0);
    }

    public void applyDefaultStyling(Marker marker, Style defaultStyle, KmlPlacemark kmlPlacemark, KmlDocument kmlDocument, MapView map) {
        Context context = map.getContext();
        Style style = kmlDocument.getStyle(kmlPlacemark.mStyle);
        if (style != null && style.mIconStyle != null) {
            style.mIconStyle.styleMarker(marker, context);
        } else if (defaultStyle != null && defaultStyle.mIconStyle != null) {
            defaultStyle.mIconStyle.styleMarker(marker, context);
        }
        marker.setDraggable(true);
        marker.setOnMarkerDragListener((Marker.OnMarkerDragListener)new OnKMLMarkerDragListener());
        marker.setEnabled(kmlPlacemark.mVisibility);
    }

    @Override
    public Overlay buildOverlay(MapView map, Style defaultStyle, KmlFeature.Styler styler, KmlPlacemark kmlPlacemark, KmlDocument kmlDocument) {
        Marker marker = new Marker(map);
        marker.setTitle(kmlPlacemark.mName);
        marker.setSnippet(kmlPlacemark.mDescription);
        marker.setSubDescription(kmlPlacemark.getExtendedDataAsText());
        marker.setPosition(this.getPosition());
        marker.setRelatedObject((Object)this);
        marker.setId(this.mId);
        if (styler == null) {
            this.applyDefaultStyling(marker, defaultStyle, kmlPlacemark, kmlDocument, map);
        } else {
            styler.onPoint(marker, kmlPlacemark, this);
        }
        return marker;
    }

    @Override
    public void saveAsKML(Writer writer) {
        try {
            writer.write("<Point>\n");
            KmlPoint.writeKMLCoordinates(writer, this.mCoordinates);
            writer.write("</Point>\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public JsonObject asGeoJSON() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "Point");
        json.add("coordinates", (JsonElement)KmlGeometry.geoJSONPosition((GeoPoint)this.mCoordinates.get(0)));
        return json;
    }

    @Override
    public BoundingBox getBoundingBox() {
        return BoundingBox.fromGeoPoints((List)this.mCoordinates);
    }

    @Override
    public KmlPoint clone() {
        return (KmlPoint)super.clone();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public KmlPoint(Parcel in) {
        super(in);
    }

    public class OnKMLMarkerDragListener
    implements Marker.OnMarkerDragListener {
        public void onMarkerDrag(Marker marker) {
        }

        public void onMarkerDragEnd(Marker marker) {
            Object object = marker.getRelatedObject();
            if (object != null && object instanceof KmlPoint) {
                KmlPoint point = (KmlPoint)object;
                point.setPosition(marker.getPosition());
            }
        }

        public void onMarkerDragStart(Marker marker) {
        }
    }
}

