/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.kml;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.osmdroid.bonuspack.kml.KmlDocument;
import org.osmdroid.bonuspack.kml.KmlFeature;
import org.osmdroid.bonuspack.kml.KmlGeometry;
import org.osmdroid.bonuspack.kml.KmlPlacemark;
import org.osmdroid.bonuspack.kml.Style;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.Overlay;
import org.osmdroid.views.overlay.Polyline;
import org.osmdroid.views.overlay.infowindow.BasicInfoWindow;
import org.osmdroid.views.overlay.infowindow.InfoWindow;

public class KmlLineString
extends KmlGeometry {
    static int mDefaultLayoutResId = 0;
    public static final Parcelable.Creator<KmlLineString> CREATOR = new Parcelable.Creator<KmlLineString>(){

        public KmlLineString createFromParcel(Parcel source) {
            return new KmlLineString(source);
        }

        public KmlLineString[] newArray(int size) {
            return new KmlLineString[size];
        }
    };

    public KmlLineString() {
    }

    protected KmlLineString(JsonArray coordinates) {
        this();
        this.mCoordinates = KmlGeometry.parseGeoJSONPositions(coordinates);
    }

    public KmlLineString(JsonObject json) {
        this(json.get("coordinates").getAsJsonArray());
    }

    public void applyDefaultStyling(Polyline lineStringOverlay, Style defaultStyle, KmlPlacemark kmlPlacemark, KmlDocument kmlDocument, MapView map) {
        Context context = map.getContext();
        Style style = kmlDocument.getStyle(kmlPlacemark.mStyle);
        if (style != null) {
            lineStringOverlay.setColor(style.getOutlinePaint().getColor());
            lineStringOverlay.setWidth(style.getOutlinePaint().getStrokeWidth());
        } else if (defaultStyle != null && defaultStyle.mLineStyle != null) {
            lineStringOverlay.setColor(defaultStyle.getOutlinePaint().getColor());
            lineStringOverlay.setWidth(defaultStyle.getOutlinePaint().getStrokeWidth());
        }
        if (kmlPlacemark.mName != null && !"".equals(kmlPlacemark.mName) || kmlPlacemark.mDescription != null && !"".equals(kmlPlacemark.mDescription) || lineStringOverlay.getSubDescription() != null && !"".equals(lineStringOverlay.getSubDescription())) {
            if (mDefaultLayoutResId == 0) {
                String packageName = context.getPackageName();
                mDefaultLayoutResId = context.getResources().getIdentifier("layout/bonuspack_bubble", null, packageName);
            }
            lineStringOverlay.setInfoWindow((InfoWindow)new BasicInfoWindow(mDefaultLayoutResId, map));
        }
        lineStringOverlay.setEnabled(kmlPlacemark.mVisibility);
    }

    @Override
    public Overlay buildOverlay(MapView map, Style defaultStyle, KmlFeature.Styler styler, KmlPlacemark kmlPlacemark, KmlDocument kmlDocument) {
        Polyline lineStringOverlay = new Polyline();
        lineStringOverlay.setGeodesic(true);
        lineStringOverlay.setPoints((List)this.mCoordinates);
        lineStringOverlay.setTitle(kmlPlacemark.mName);
        lineStringOverlay.setSnippet(kmlPlacemark.mDescription);
        lineStringOverlay.setSubDescription(kmlPlacemark.getExtendedDataAsText());
        lineStringOverlay.setRelatedObject((Object)this);
        lineStringOverlay.setId(this.mId);
        if (styler != null) {
            styler.onLineString(lineStringOverlay, kmlPlacemark, this);
        } else {
            this.applyDefaultStyling(lineStringOverlay, defaultStyle, kmlPlacemark, kmlDocument, map);
        }
        return lineStringOverlay;
    }

    @Override
    public void saveAsKML(Writer writer) {
        try {
            writer.write("<LineString>\n");
            KmlLineString.writeKMLCoordinates(writer, this.mCoordinates);
            writer.write("</LineString>\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public JsonObject asGeoJSON() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "LineString");
        json.add("coordinates", (JsonElement)KmlGeometry.geoJSONCoordinates(this.mCoordinates));
        return json;
    }

    @Override
    public BoundingBox getBoundingBox() {
        if (this.mCoordinates != null) {
            return BoundingBox.fromGeoPoints((List)this.mCoordinates);
        }
        return null;
    }

    @Override
    public KmlLineString clone() {
        return (KmlLineString)super.clone();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public KmlLineString(Parcel in) {
        super(in);
    }
}

