/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.kml;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.osmdroid.bonuspack.kml.KmlDocument;
import org.osmdroid.bonuspack.kml.KmlFolder;
import org.osmdroid.bonuspack.kml.KmlGeometry;
import org.osmdroid.bonuspack.kml.KmlGroundOverlay;
import org.osmdroid.bonuspack.kml.KmlLineString;
import org.osmdroid.bonuspack.kml.KmlPlacemark;
import org.osmdroid.bonuspack.kml.KmlPoint;
import org.osmdroid.bonuspack.kml.KmlPolygon;
import org.osmdroid.bonuspack.kml.KmlTrack;
import org.osmdroid.bonuspack.kml.Style;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.Marker;
import org.osmdroid.views.overlay.Overlay;
import org.osmdroid.views.overlay.Polygon;
import org.osmdroid.views.overlay.Polyline;

public abstract class KmlFeature
implements Parcelable,
Cloneable {
    public String mId;
    public String mName;
    public String mDescription;
    public boolean mVisibility;
    public boolean mOpen;
    public String mStyle;
    public HashMap<String, String> mExtendedData;

    public abstract BoundingBox getBoundingBox();

    public abstract Overlay buildOverlay(MapView var1, Style var2, Styler var3, KmlDocument var4);

    public abstract void writeKMLSpecifics(Writer var1);

    public abstract JsonObject asGeoJSON(boolean var1);

    public KmlFeature() {
        this.mVisibility = true;
        this.mOpen = true;
    }

    public boolean hasGeometry(Class<? extends KmlGeometry> C) {
        if (!(this instanceof KmlPlacemark)) {
            return false;
        }
        KmlPlacemark placemark = (KmlPlacemark)this;
        KmlGeometry geometry = placemark.mGeometry;
        if (geometry == null) {
            return false;
        }
        return C.isInstance(geometry);
    }

    public String getExtendedData(String name) {
        if (this.mExtendedData == null) {
            return null;
        }
        return this.mExtendedData.get(name);
    }

    public String getExtendedDataAsText() {
        if (this.mExtendedData == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : this.mExtendedData.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            result.append(name + "=" + value + "<br>\n");
        }
        if (result.length() > 0) {
            return result.toString();
        }
        return null;
    }

    public void setExtendedData(String name, String value) {
        if (this.mExtendedData == null) {
            this.mExtendedData = new HashMap();
        }
        this.mExtendedData.put(name, value);
    }

    protected boolean writeKMLExtendedData(Writer writer) {
        if (this.mExtendedData == null) {
            return true;
        }
        try {
            writer.write("<ExtendedData>\n");
            for (Map.Entry<String, String> entry : this.mExtendedData.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                writer.write("<Data name=\"" + name + "\"><value>" + StringEscapeUtils.escapeXml10((String)value) + "</value></Data>\n");
            }
            writer.write("</ExtendedData>\n");
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean writeAsKML(Writer writer, boolean isDocument, KmlDocument kmlDocument) {
        try {
            String objectType;
            if (this instanceof KmlFolder) {
                objectType = isDocument ? "Document" : "Folder";
            } else if (this instanceof KmlPlacemark) {
                objectType = "Placemark";
            } else if (this instanceof KmlGroundOverlay) {
                objectType = "GroundOverlay";
            } else {
                return false;
            }
            writer.write('<' + objectType);
            if (this.mId != null) {
                writer.write(" id=\"mId\"");
            }
            writer.write(">\n");
            if (this.mStyle != null) {
                writer.write("<styleUrl>#" + this.mStyle + "</styleUrl>\n");
            }
            if (this.mName != null) {
                writer.write("<name>" + StringEscapeUtils.escapeXml10((String)this.mName) + "</name>\n");
            }
            if (this.mDescription != null) {
                writer.write("<description><![CDATA[" + this.mDescription + "]]></description>\n");
            }
            if (!this.mVisibility) {
                writer.write("<visibility>0</visibility>\n");
            }
            this.writeKMLSpecifics(writer);
            this.writeKMLExtendedData(writer);
            if (isDocument) {
                kmlDocument.writeKMLStyles(writer);
            }
            writer.write("</" + objectType + ">\n");
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static KmlFeature parseGeoJSON(JsonObject json) {
        if (json == null) {
            return null;
        }
        String type = json.get("type").getAsString();
        if ("FeatureCollection".equals(type)) {
            return new KmlFolder(json);
        }
        if ("Feature".equals(type)) {
            return new KmlPlacemark(json);
        }
        return null;
    }

    public KmlFeature clone() {
        KmlFeature kmlFeature;
        try {
            kmlFeature = (KmlFeature)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
        if (this.mExtendedData != null) {
            kmlFeature.mExtendedData = new HashMap(this.mExtendedData.size());
            kmlFeature.mExtendedData.putAll(this.mExtendedData);
        }
        return kmlFeature;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.mId);
        out.writeString(this.mName);
        out.writeString(this.mDescription);
        out.writeInt(this.mVisibility ? 1 : 0);
        out.writeInt(this.mOpen ? 1 : 0);
        out.writeString(this.mStyle);
    }

    public KmlFeature(Parcel in) {
        this.mId = in.readString();
        this.mName = in.readString();
        this.mDescription = in.readString();
        this.mVisibility = in.readInt() == 1;
        this.mOpen = in.readInt() == 1;
        this.mStyle = in.readString();
    }

    public static interface Styler {
        public void onFeature(Overlay var1, KmlFeature var2);

        public void onPoint(Marker var1, KmlPlacemark var2, KmlPoint var3);

        public void onLineString(Polyline var1, KmlPlacemark var2, KmlLineString var3);

        public void onPolygon(Polygon var1, KmlPlacemark var2, KmlPolygon var3);

        public void onTrack(Polyline var1, KmlPlacemark var2, KmlTrack var3);
    }
}

