/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.kml;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.IOException;
import java.io.Writer;

public class HotSpot
implements Parcelable {
    public float mx;
    public float my;
    public Units mXUnits;
    public Units mYUnits;
    public static final Parcelable.Creator<HotSpot> CREATOR = new Parcelable.Creator<HotSpot>(){

        public HotSpot createFromParcel(Parcel in) {
            return new HotSpot(in);
        }

        public HotSpot[] newArray(int size) {
            return new HotSpot[size];
        }
    };

    public Units getUnits(String sUnits) {
        if ("fraction".equals(sUnits)) {
            return Units.fraction;
        }
        if ("pixels".equals(sUnits)) {
            return Units.pixels;
        }
        if ("insetPixels".equals(sUnits)) {
            return Units.insetPixels;
        }
        return Units.fraction;
    }

    public String getUnits(Units units) {
        return "" + (Object)((Object)units);
    }

    public HotSpot() {
        this.mx = 0.5f;
        this.my = 0.0f;
        this.mXUnits = Units.fraction;
        this.mYUnits = Units.fraction;
    }

    public HotSpot(float x, float y, String xunits, String yunits) {
        this.mx = x;
        this.my = y;
        this.mXUnits = this.getUnits(xunits);
        this.mYUnits = this.getUnits(yunits);
    }

    public float get(float dim, Units units, float iconSize) {
        switch (units) {
            case fraction: {
                return dim;
            }
            case pixels: {
                return dim / iconSize;
            }
            case insetPixels: {
                return (iconSize - dim) / iconSize;
            }
        }
        return dim;
    }

    public float getX(float iconSize) {
        return this.get(this.mx, this.mXUnits, iconSize);
    }

    public float getY(float iconSize) {
        return this.get(this.my, this.mYUnits, iconSize);
    }

    public void writeAsKML(Writer writer) {
        try {
            writer.write("<hotSpot x=\"" + this.mx + "\" y=\"" + this.my + "\" xunits=\"" + this.getUnits(this.mXUnits) + "\" yunits=\"" + this.getUnits(this.mYUnits) + "\"/>\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeFloat(this.mx);
        out.writeFloat(this.my);
        out.writeInt(this.mXUnits.ordinal());
        out.writeInt(this.mYUnits.ordinal());
    }

    public HotSpot(Parcel in) {
        this.mx = in.readFloat();
        this.my = in.readFloat();
        this.mXUnits = Units.fromOrdinal(in.readInt());
        this.mYUnits = Units.fromOrdinal(in.readInt());
    }

    public static enum Units {
        fraction,
        pixels,
        insetPixels;

        private static Units[] allValues;

        public static Units fromOrdinal(int n) {
            return allValues[n];
        }

        static {
            allValues = Units.values();
        }
    }
}

