/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.clustering;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Point;
import android.view.MotionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.osmdroid.bonuspack.clustering.StaticCluster;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.Marker;
import org.osmdroid.views.overlay.Overlay;

public abstract class MarkerClusterer
extends Overlay {
    protected static final int FORCE_CLUSTERING = -1;
    protected ArrayList<Marker> mItems = new ArrayList();
    protected Point mPoint = new Point();
    protected ArrayList<StaticCluster> mClusters = new ArrayList();
    protected int mLastZoomLevel = -1;
    protected Bitmap mClusterIcon;
    protected String mName;
    protected String mDescription;

    public abstract ArrayList<StaticCluster> clusterer(MapView var1);

    public abstract Marker buildClusterMarker(StaticCluster var1, MapView var2);

    public abstract void renderer(ArrayList<StaticCluster> var1, Canvas var2, MapView var3);

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setIcon(Bitmap icon) {
        this.mClusterIcon = icon;
    }

    public void add(Marker marker) {
        this.mItems.add(marker);
    }

    public void invalidate() {
        this.mLastZoomLevel = -1;
    }

    public Marker getItem(int id) {
        return this.mItems.get(id);
    }

    public ArrayList<Marker> getItems() {
        return this.mItems;
    }

    protected void hideInfoWindows() {
        for (Marker m : this.mItems) {
            if (!m.isInfoWindowShown()) continue;
            m.closeInfoWindow();
        }
    }

    public void draw(Canvas canvas, MapView mapView, boolean shadow) {
        if (shadow) {
            return;
        }
        int zoomLevel = mapView.getZoomLevel();
        if (zoomLevel != this.mLastZoomLevel && !mapView.isAnimating()) {
            this.hideInfoWindows();
            this.mClusters = this.clusterer(mapView);
            this.renderer(this.mClusters, canvas, mapView);
            this.mLastZoomLevel = zoomLevel;
        }
        for (StaticCluster cluster : this.mClusters) {
            cluster.getMarker().draw(canvas, mapView.getProjection());
        }
    }

    public Iterable<StaticCluster> reversedClusters() {
        return new Iterable<StaticCluster>(){

            @Override
            public Iterator<StaticCluster> iterator() {
                final ListIterator<StaticCluster> i = MarkerClusterer.this.mClusters.listIterator(MarkerClusterer.this.mClusters.size());
                return new Iterator<StaticCluster>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasPrevious();
                    }

                    @Override
                    public StaticCluster next() {
                        return (StaticCluster)i.previous();
                    }

                    @Override
                    public void remove() {
                        i.remove();
                    }
                };
            }
        };
    }

    public boolean onSingleTapConfirmed(MotionEvent event, MapView mapView) {
        for (StaticCluster cluster : this.reversedClusters()) {
            if (!cluster.getMarker().onSingleTapConfirmed(event, mapView)) continue;
            return true;
        }
        return false;
    }

    public boolean onLongPress(MotionEvent event, MapView mapView) {
        for (StaticCluster cluster : this.reversedClusters()) {
            if (!cluster.getMarker().onLongPress(event, mapView)) continue;
            return true;
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent event, MapView mapView) {
        for (StaticCluster cluster : this.reversedClusters()) {
            if (!cluster.getMarker().onTouchEvent(event, mapView)) continue;
            return true;
        }
        return false;
    }

    public BoundingBox getBounds() {
        if (this.mItems.size() == 0) {
            return null;
        }
        double minLat = Double.MAX_VALUE;
        double minLon = Double.MAX_VALUE;
        double maxLat = -1.7976931348623157E308;
        double maxLon = -1.7976931348623157E308;
        for (Marker item : this.mItems) {
            double latitude = item.getPosition().getLatitude();
            double longitude = item.getPosition().getLongitude();
            minLat = Math.min(minLat, latitude);
            minLon = Math.min(minLon, longitude);
            maxLat = Math.max(maxLat, latitude);
            maxLon = Math.max(maxLon, longitude);
        }
        return new BoundingBox(maxLat, maxLon, minLat, minLon);
    }
}

