/*
 * Decompiled with CFR 0.152.
 */
package com.lottiefiles.dotlottie.core.util;

import android.content.Context;
import androidx.compose.runtime.internal.StabilityInferred;
import com.lottiefiles.dotlottie.core.loader.DotLottieResult;
import com.lottiefiles.dotlottie.core.util.DotLottieContent;
import com.lottiefiles.dotlottie.core.util.DotLottieSource;
import java.io.File;
import java.io.FileOutputStream;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J!\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\r\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000e"}, d2={"Lcom/lottiefiles/dotlottie/core/util/DotLottieUtils;", "", "()V", "byteArrayToFile", "Ljava/io/File;", "context", "Landroid/content/Context;", "data", "", "getContent", "Lcom/lottiefiles/dotlottie/core/util/DotLottieContent;", "source", "Lcom/lottiefiles/dotlottie/core/util/DotLottieSource;", "(Landroid/content/Context;Lcom/lottiefiles/dotlottie/core/util/DotLottieSource;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dotlottie_release"})
@StabilityInferred(parameters=0)
public final class DotLottieUtils {
    @NotNull
    public static final DotLottieUtils INSTANCE = new DotLottieUtils();
    public static final int $stable;

    private DotLottieUtils() {
    }

    @Nullable
    public final Object getContent(@NotNull Context context, @NotNull DotLottieSource source, @NotNull Continuation<? super DotLottieContent> $completion) {
        DotLottieSource dotLottieSource = source;
        if (dotLottieSource instanceof DotLottieSource.Url) {
            Continuation<? super DotLottieContent> continuation = $completion;
            SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
            Continuation cont = (Continuation)safeContinuation;
            boolean bl = false;
            DotLottieLoader.Companion.with(context).fromUrl(((DotLottieSource.Url)source).getUrlString()).load(new DotLottieResult((Continuation<? super DotLottieContent>)cont){
                final /* synthetic */ Continuation<DotLottieContent> $cont;
                {
                    this.$cont = $cont;
                }

                public void onSuccess(@NotNull DotLottieContent result) {
                    Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                    this.$cont.resumeWith(Result.constructor-impl((Object)result));
                }

                public void onError(@NotNull Throwable throwable) {
                    Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                    this.$cont.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)));
                }
            });
            Object object = safeContinuation.getOrThrow();
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                DebugProbesKt.probeCoroutineSuspended($completion);
            }
            return object;
        }
        if (dotLottieSource instanceof DotLottieSource.Asset) {
            Continuation<? super DotLottieContent> continuation = $completion;
            SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
            Continuation cont = (Continuation)safeContinuation;
            boolean bl = false;
            DotLottieLoader.Companion.with(context).fromAsset(((DotLottieSource.Asset)source).getAssetPath()).load(new DotLottieResult((Continuation<? super DotLottieContent>)cont){
                final /* synthetic */ Continuation<DotLottieContent> $cont;
                {
                    this.$cont = $cont;
                }

                public void onSuccess(@NotNull DotLottieContent result) {
                    Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                    this.$cont.resumeWith(Result.constructor-impl((Object)result));
                }

                public void onError(@NotNull Throwable throwable) {
                    Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                    this.$cont.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)));
                }
            });
            Object object = safeContinuation.getOrThrow();
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                DebugProbesKt.probeCoroutineSuspended($completion);
            }
            return object;
        }
        if (dotLottieSource instanceof DotLottieSource.Json) {
            Continuation<? super DotLottieContent> continuation = $completion;
            SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
            Continuation cont = (Continuation)safeContinuation;
            boolean bl = false;
            cont.resumeWith(Result.constructor-impl((Object)new DotLottieContent.Json(((DotLottieSource.Json)source).getJsonString())));
            Object object = safeContinuation.getOrThrow();
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                DebugProbesKt.probeCoroutineSuspended($completion);
            }
            return object;
        }
        if (dotLottieSource instanceof DotLottieSource.Data) {
            Continuation<? super DotLottieContent> continuation = $completion;
            SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
            Continuation cont = (Continuation)safeContinuation;
            boolean bl = false;
            cont.resumeWith(Result.constructor-impl((Object)new DotLottieContent.Binary(((DotLottieSource.Data)source).getData())));
            Object object = safeContinuation.getOrThrow();
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                DebugProbesKt.probeCoroutineSuspended($completion);
            }
            return object;
        }
        throw new NoWhenBranchMatchedException();
    }

    private final File byteArrayToFile(Context context, byte[] data) {
        File file;
        try {
            File file2;
            File $this$byteArrayToFile_u24lambda_u244 = file2 = new File(context.getCacheDir(), UUID.randomUUID() + ".lottie");
            boolean bl = false;
            $this$byteArrayToFile_u24lambda_u244.createNewFile();
            File filePath = file2;
            FileOutputStream fileOutputStream = new FileOutputStream(filePath);
            fileOutputStream.write(data);
            fileOutputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            file = null;
        }
        return file;
    }
}

