/*
 * Decompiled with CFR 0.152.
 */
package com.lottiefiles.dotlottie.core.drawable;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.FloatRange;
import androidx.compose.runtime.internal.StabilityInferred;
import com.dotlottie.dlplayer.Config;
import com.dotlottie.dlplayer.DotLottiePlayer;
import com.dotlottie.dlplayer.Event;
import com.dotlottie.dlplayer.Layout;
import com.dotlottie.dlplayer.Manifest;
import com.dotlottie.dlplayer.Marker;
import com.dotlottie.dlplayer.Mode;
import com.dotlottie.dlplayer.Observer;
import com.dotlottie.dlplayer.StateMachineObserver;
import com.lottiefiles.dotlottie.core.util.DotLottieContent;
import com.lottiefiles.dotlottie.core.util.DotLottieEventListener;
import com.lottiefiles.dotlottie.core.util.StateMachineEventListener;
import com.sun.jna.Pointer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.UInt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0017\b\u0007\u0018\u0000 \u0093\u00012\u00020\u00012\u00020\u0002:\u0002\u0093\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020UJ\u0010\u0010^\u001a\u00020\\2\u0006\u0010_\u001a\u00020`H\u0016J\b\u0010a\u001a\u00020\u0006H\u0016J\b\u0010b\u001a\u00020\u0006H\u0016J\b\u0010c\u001a\u00020\u0006H\u0016J\b\u0010d\u001a\u00020\\H\u0002J\u0006\u0010e\u001a\u00020\u0015J\b\u0010f\u001a\u00020\u0015H\u0016J\u0006\u0010g\u001a\u00020\u0015J\u000e\u0010h\u001a\u00020\\2\u0006\u0010i\u001a\u00020\u000fJ\u000e\u0010j\u001a\u00020\u00152\u0006\u0010k\u001a\u00020\u000fJ\b\u0010l\u001a\u0004\u0018\u00010mJ\u0006\u0010n\u001a\u00020\\J\u0006\u0010o\u001a\u00020\\J\u000e\u0010p\u001a\u00020\u00062\u0006\u0010q\u001a\u00020rJ\u0006\u0010s\u001a\u00020\\J\u000e\u0010t\u001a\u00020\\2\u0006\u0010]\u001a\u00020UJ\u0006\u0010u\u001a\u00020\\J\u0016\u0010v\u001a\u00020\\2\u0006\u0010w\u001a\u00020\u00062\u0006\u0010x\u001a\u00020\u0006J\u0010\u0010y\u001a\u00020\\2\u0006\u0010z\u001a\u00020\u0006H\u0016J\u0012\u0010{\u001a\u00020\\2\b\u0010|\u001a\u0004\u0018\u00010}H\u0016J\u000e\u0010~\u001a\u00020\\2\u0006\u0010\u007f\u001a\u00020\u001bJ\u000f\u0010\u0080\u0001\u001a\u00020\\2\u0006\u0010H\u001a\u00020IJ\u0019\u0010\u0081\u0001\u001a\u00020\\2\u0007\u0010\u0082\u0001\u001a\u00020\u001b2\u0007\u0010\u0083\u0001\u001a\u00020\u001bJ\u0010\u0010\u0084\u0001\u001a\u00020\\2\u0007\u0010\u0085\u0001\u001a\u00020\u000fJ\u0018\u0010\u0086\u0001\u001a\u00020\u00152\u0007\u0010\u0087\u0001\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u0015J\u0018\u0010\u0088\u0001\u001a\u00020\u00152\u0007\u0010\u0087\u0001\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u001bJ\u0018\u0010\u0089\u0001\u001a\u00020\u00152\u0007\u0010\u0087\u0001\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u000fJ\u0010\u0010\u008a\u0001\u001a\u00020\\2\u0007\u0010\u008b\u0001\u001a\u00020\u000fJ\u0010\u0010\u008c\u0001\u001a\u00020\\2\u0007\u0010\u008d\u0001\u001a\u00020\u000fJ\t\u0010\u008e\u0001\u001a\u00020\\H\u0016J\u0007\u0010\u008f\u0001\u001a\u00020\u0015J\t\u0010\u0090\u0001\u001a\u00020\\H\u0016J\u0007\u0010\u0091\u0001\u001a\u00020\u0015J\t\u0010\u0092\u0001\u001a\u00020\\H\u0002R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010 \u001a\u00020\u001b8FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010#R$\u0010%\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u0015@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0017\"\u0004\b'\u0010(R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010)\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0017R$\u0010+\u001a\u00020*2\u0006\u0010$\u001a\u00020*8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R$\u00100\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u00158F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b1\u0010\u0017\"\u0004\b2\u0010(R'\u00103\u001a\u0002048FX\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u00109\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u000e\u0010:\u001a\u00020;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020=X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010>\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u000f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b?\u0010\u0011\"\u0004\b@\u0010AR\u0017\u0010B\u001a\b\u0012\u0004\u0012\u00020C0\t8F\u00a2\u0006\u0006\u001a\u0004\bD\u0010ER\u0010\u0010F\u001a\u0004\u0018\u00010GX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010H\u001a\u00020I8F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010KR\u001f\u0010L\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b\u0018\u00010M8F\u00a2\u0006\u0006\u001a\u0004\bN\u0010OR$\u0010P\u001a\u00020\u001b2\u0006\u0010P\u001a\u00020\u001b8G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bQ\u0010\u001d\"\u0004\bR\u0010#R\u0014\u0010S\u001a\b\u0012\u0004\u0012\u00020U0TX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010V\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\bW\u0010\u001dR$\u0010X\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u00158F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bY\u0010\u0017\"\u0004\bZ\u0010(R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0094\u0001"}, d2={"Lcom/lottiefiles/dotlottie/core/drawable/DotLottieDrawable;", "Landroid/graphics/drawable/Drawable;", "Landroid/graphics/drawable/Animatable;", "animationData", "Lcom/lottiefiles/dotlottie/core/util/DotLottieContent;", "width", "", "height", "dotLottieEventListener", "", "Lcom/lottiefiles/dotlottie/core/util/DotLottieEventListener;", "config", "Lcom/dotlottie/dlplayer/Config;", "(Lcom/lottiefiles/dotlottie/core/util/DotLottieContent;IILjava/util/List;Lcom/dotlottie/dlplayer/Config;)V", "activeAnimationId", "", "getActiveAnimationId", "()Ljava/lang/String;", "activeThemeId", "getActiveThemeId", "autoplay", "", "getAutoplay", "()Z", "bitmapBuffer", "Landroid/graphics/Bitmap;", "currentFrame", "", "getCurrentFrame", "()F", "dlPlayer", "Lcom/dotlottie/dlplayer/DotLottiePlayer;", "duration", "getDuration", "setDuration", "(F)V", "value", "freeze", "getFreeze", "setFreeze", "(Z)V", "isLoaded", "Lcom/dotlottie/dlplayer/Layout;", "layout", "getLayout", "()Lcom/dotlottie/dlplayer/Layout;", "setLayout", "(Lcom/dotlottie/dlplayer/Layout;)V", "loop", "getLoop", "setLoop", "loopCount", "Lkotlin/UInt;", "getLoopCount-pVg5ArA", "()I", "setLoopCount-WZ4Q5Ns", "(I)V", "I", "mHandler", "Landroid/os/Handler;", "mNextFrameRunnable", "Ljava/lang/Runnable;", "marker", "getMarker", "setMarker", "(Ljava/lang/String;)V", "markers", "Lcom/dotlottie/dlplayer/Marker;", "getMarkers", "()Ljava/util/List;", "nativeBuffer", "Lcom/sun/jna/Pointer;", "playMode", "Lcom/dotlottie/dlplayer/Mode;", "getPlayMode", "()Lcom/dotlottie/dlplayer/Mode;", "segment", "Lkotlin/Pair;", "getSegment", "()Lkotlin/Pair;", "speed", "getSpeed", "setSpeed", "stateMachineListeners", "", "Lcom/lottiefiles/dotlottie/core/util/StateMachineEventListener;", "totalFrame", "getTotalFrame", "useFrameInterpolation", "getUseFrameInterpolation", "setUseFrameInterpolation", "addStateMachineEventListener", "", "listener", "draw", "canvas", "Landroid/graphics/Canvas;", "getIntrinsicHeight", "getIntrinsicWidth", "getOpacity", "initialize", "isPaused", "isRunning", "isStopped", "loadAnimation", "animationId", "loadStateMachine", "stateMachineId", "manifest", "Lcom/dotlottie/dlplayer/Manifest;", "pause", "play", "postEvent", "event", "Lcom/dotlottie/dlplayer/Event;", "release", "removeStateMachineEventListener", "resetTheme", "resize", "w", "h", "setAlpha", "alpha", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "setCurrentFrame", "frame", "setPlayMode", "setSegment", "first", "second", "setSlots", "slots", "setStateMachineBooleanContext", "key", "setStateMachineNumericContext", "setStateMachineStringContext", "setTheme", "themeId", "setThemeData", "themeData", "start", "startStateMachine", "stop", "stopStateMachine", "subscribe", "Companion", "dotlottie_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDotLottieDrawable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotLottieDrawable.kt\ncom/lottiefiles/dotlottie/core/drawable/DotLottieDrawable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,417:1\n1855#2,2:418\n1855#2,2:420\n1855#2,2:422\n1855#2,2:424\n1855#2,2:426\n*S KotlinDebug\n*F\n+ 1 DotLottieDrawable.kt\ncom/lottiefiles/dotlottie/core/drawable/DotLottieDrawable\n*L\n156#1:418,2\n44#1:420,2\n48#1:422,2\n223#1:424,2\n348#1:426,2\n*E\n"})
public final class DotLottieDrawable
extends Drawable
implements Animatable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DotLottieContent animationData;
    private int width;
    private int height;
    @NotNull
    private final List<DotLottieEventListener> dotLottieEventListener;
    @NotNull
    private Config config;
    @Nullable
    private Pointer nativeBuffer;
    @Nullable
    private Bitmap bitmapBuffer;
    @Nullable
    private DotLottiePlayer dlPlayer;
    @NotNull
    private List<StateMachineEventListener> stateMachineListeners;
    private boolean freeze;
    private float duration;
    private int loopCount;
    @NotNull
    private final Handler mHandler;
    @NotNull
    private final Runnable mNextFrameRunnable;
    public static final int $stable = 8;
    @NotNull
    private static final String TAG = "DotLottieDrawable";
    private static final int LOTTIE_INFO_FRAME_COUNT = 0;
    private static final int LOTTIE_INFO_DURATION = 1;
    private static final int LOTTIE_INFO_COUNT = 2;

    public DotLottieDrawable(@NotNull DotLottieContent animationData, int width, int height, @NotNull List<? extends DotLottieEventListener> dotLottieEventListener, @NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)animationData, (String)"animationData");
        Intrinsics.checkNotNullParameter(dotLottieEventListener, (String)"dotLottieEventListener");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.animationData = animationData;
        this.width = width;
        this.height = height;
        this.dotLottieEventListener = dotLottieEventListener;
        this.config = config;
        this.stateMachineListeners = new ArrayList();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.mNextFrameRunnable = () -> DotLottieDrawable.mNextFrameRunnable$lambda$1(this);
        try {
            this.initialize();
        }
        catch (Throwable e) {
            Iterable $this$forEach$iv = this.dotLottieEventListener;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DotLottieEventListener it = (DotLottieEventListener)element$iv;
                boolean bl = false;
                it.onLoadError(e);
            }
        }
    }

    public /* synthetic */ DotLottieDrawable(DotLottieContent dotLottieContent, int n, int n2, List list, Config config, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        this(dotLottieContent, n, n2, list, config);
    }

    public final boolean getFreeze() {
        return this.freeze;
    }

    public final void setFreeze(boolean value) {
        if (value) {
            Iterable $this$forEach$iv = this.dotLottieEventListener;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DotLottieEventListener p0 = (DotLottieEventListener)element$iv;
                boolean bl = false;
                p0.onFreeze();
            }
            this.mHandler.removeCallbacks(this.mNextFrameRunnable);
            DotLottiePlayer dotLottiePlayer = this.dlPlayer;
            Intrinsics.checkNotNull((Object)dotLottiePlayer);
            dotLottiePlayer.pause();
        } else {
            Iterable $this$forEach$iv = this.dotLottieEventListener;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DotLottieEventListener p0 = (DotLottieEventListener)element$iv;
                boolean bl = false;
                p0.onUnFreeze();
            }
            DotLottiePlayer dotLottiePlayer = this.dlPlayer;
            Intrinsics.checkNotNull((Object)dotLottiePlayer);
            dotLottiePlayer.play();
            this.invalidateSelf();
        }
        this.freeze = value;
    }

    public final float getDuration() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.duration();
    }

    public final void setDuration(float f) {
        this.duration = f;
    }

    public final int getLoopCount-pVg5ArA() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.loopCount-pVg5ArA();
    }

    public final void setLoopCount-WZ4Q5Ns(int n) {
        this.loopCount = n;
    }

    @Nullable
    public final Pair<Float, Float> getSegment() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        if (dotLottiePlayer.config().getSegment().isEmpty()) {
            return null;
        }
        DotLottiePlayer dotLottiePlayer2 = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer2);
        Float f = dotLottiePlayer2.config().getSegment().get(0);
        DotLottiePlayer dotLottiePlayer3 = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer3);
        return new Pair((Object)f, (Object)dotLottiePlayer3.config().getSegment().get(1));
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return -3;
    }

    public int getIntrinsicWidth() {
        return this.width;
    }

    public int getIntrinsicHeight() {
        return this.height;
    }

    public final boolean getUseFrameInterpolation() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.config().getUseFrameInterpolation();
    }

    public final void setUseFrameInterpolation(boolean value) {
        this.config.setUseFrameInterpolation(value);
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        dotLottiePlayer.setConfig(this.config);
    }

    @NotNull
    public final Mode getPlayMode() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.config().getMode();
    }

    public final float getTotalFrame() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.totalFrames();
    }

    public final boolean getAutoplay() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.config().getAutoplay();
    }

    public final float getCurrentFrame() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.currentFrame();
    }

    public final boolean getLoop() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.config().getLoopAnimation();
    }

    public final void setLoop(boolean value) {
        this.config.setLoopAnimation(value);
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        dotLottiePlayer.setConfig(this.config);
    }

    @NotNull
    public final String getMarker() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.config().getMarker();
    }

    public final void setMarker(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.config.setMarker(value);
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        dotLottiePlayer.setConfig(this.config);
    }

    @NotNull
    public final List<Marker> getMarkers() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.markers();
    }

    @NotNull
    public final Layout getLayout() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.config().getLayout();
    }

    public final void setLayout(@NotNull Layout value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.config.setLayout(value);
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        dotLottiePlayer.setConfig(this.config);
    }

    @NotNull
    public final String getActiveThemeId() {
        Object object = this.dlPlayer;
        if (object == null || (object = ((DotLottiePlayer)object).activeThemeId()) == null) {
            object = "";
        }
        return object;
    }

    @NotNull
    public final String getActiveAnimationId() {
        Object object = this.dlPlayer;
        if (object == null || (object = ((DotLottiePlayer)object).activeAnimationId()) == null) {
            object = "";
        }
        return object;
    }

    @FloatRange(from=0.0)
    public final float getSpeed() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.config().getSpeed();
    }

    public final void setSpeed(float speed) {
        this.config.setSpeed(speed);
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        dotLottiePlayer.setConfig(this.config);
    }

    public final boolean isLoaded() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.isLoaded();
    }

    private final void subscribe() {
        block0: {
            Observer observer2 = new Observer(this){
                final /* synthetic */ DotLottieDrawable this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onComplete() {
                    Iterable $this$forEach$iv = DotLottieDrawable.access$getDotLottieEventListener$p(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        DotLottieEventListener p0 = (DotLottieEventListener)element$iv;
                        boolean bl = false;
                        p0.onComplete();
                    }
                }

                public void onFrame(float frameNo) {
                    Iterable $this$forEach$iv = DotLottieDrawable.access$getDotLottieEventListener$p(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        DotLottieEventListener it = (DotLottieEventListener)element$iv;
                        boolean bl = false;
                        it.onFrame(frameNo);
                    }
                }

                public void onPause() {
                    Iterable $this$forEach$iv = DotLottieDrawable.access$getDotLottieEventListener$p(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        DotLottieEventListener p0 = (DotLottieEventListener)element$iv;
                        boolean bl = false;
                        p0.onPause();
                    }
                }

                public void onStop() {
                    Iterable $this$forEach$iv = DotLottieDrawable.access$getDotLottieEventListener$p(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        DotLottieEventListener p0 = (DotLottieEventListener)element$iv;
                        boolean bl = false;
                        p0.onStop();
                    }
                }

                public void onPlay() {
                    Iterable $this$forEach$iv = DotLottieDrawable.access$getDotLottieEventListener$p(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        DotLottieEventListener p0 = (DotLottieEventListener)element$iv;
                        boolean bl = false;
                        p0.onPlay();
                    }
                }

                public void onLoad() {
                    Iterable $this$forEach$iv = DotLottieDrawable.access$getDotLottieEventListener$p(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        DotLottieEventListener p0 = (DotLottieEventListener)element$iv;
                        boolean bl = false;
                        p0.onLoad();
                    }
                }

                public void onLoop-WZ4Q5Ns(int loopCount) {
                    Iterable $this$forEach$iv = DotLottieDrawable.access$getDotLottieEventListener$p(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        DotLottieEventListener it = (DotLottieEventListener)element$iv;
                        boolean bl = false;
                        it.onLoop(loopCount);
                    }
                }

                public void onRender(float frameNo) {
                    Iterable $this$forEach$iv = DotLottieDrawable.access$getDotLottieEventListener$p(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        DotLottieEventListener it = (DotLottieEventListener)element$iv;
                        boolean bl = false;
                        it.onRender(frameNo);
                    }
                }

                public void onLoadError() {
                    Iterable $this$forEach$iv = DotLottieDrawable.access$getDotLottieEventListener$p(this.this$0);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        DotLottieEventListener p0 = (DotLottieEventListener)element$iv;
                        boolean bl = false;
                        p0.onLoadError();
                    }
                }
            };
            DotLottiePlayer dotLottiePlayer = this.dlPlayer;
            if (dotLottiePlayer == null) break block0;
            dotLottiePlayer.subscribe(observer2);
        }
    }

    private final void initialize() {
        this.dlPlayer = new DotLottiePlayer(this.config);
        DotLottieContent dotLottieContent = this.animationData;
        if (dotLottieContent instanceof DotLottieContent.Json) {
            DotLottiePlayer dotLottiePlayer = this.dlPlayer;
            Intrinsics.checkNotNull((Object)dotLottiePlayer);
            dotLottiePlayer.loadAnimationData-BltQuoY(((DotLottieContent.Json)this.animationData).getJsonString(), UInt.constructor-impl((int)this.width), UInt.constructor-impl((int)this.height));
        } else if (dotLottieContent instanceof DotLottieContent.Binary) {
            DotLottiePlayer dotLottiePlayer = this.dlPlayer;
            Intrinsics.checkNotNull((Object)dotLottiePlayer);
            dotLottiePlayer.loadDotlottieData-BltQuoY(((DotLottieContent.Binary)this.animationData).getData(), UInt.constructor-impl((int)this.width), UInt.constructor-impl((int)this.height));
        }
        this.bitmapBuffer = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        this.nativeBuffer = new Pointer(dotLottiePlayer.bufferPtr-s-VKNKU());
        this.subscribe();
    }

    public final void release() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        dotLottiePlayer.destroy();
        Iterable $this$forEach$iv = this.dotLottieEventListener;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DotLottieEventListener p0 = (DotLottieEventListener)element$iv;
            boolean bl = false;
            p0.onDestroy();
        }
        if (this.bitmapBuffer != null) {
            Bitmap bitmap = this.bitmapBuffer;
            if (bitmap != null) {
                bitmap.recycle();
            }
            this.bitmapBuffer = null;
        }
    }

    public final void resize(int w, int h) {
        this.width = w;
        this.height = h;
        Bitmap bitmap = this.bitmapBuffer;
        if (bitmap != null) {
            bitmap.recycle();
        }
        this.bitmapBuffer = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        dotLottiePlayer.resize-feOb9K0(UInt.constructor-impl((int)this.width), UInt.constructor-impl((int)this.height));
        DotLottiePlayer dotLottiePlayer2 = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer2);
        this.nativeBuffer = new Pointer(dotLottiePlayer2.bufferPtr-s-VKNKU());
    }

    public boolean isRunning() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.isPlaying();
    }

    public final void play() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        dotLottiePlayer.play();
        this.invalidateSelf();
    }

    public void start() {
        this.play();
    }

    public final void setPlayMode(@NotNull Mode playMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)playMode), (String)"playMode");
        this.config.setMode(playMode);
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        dotLottiePlayer.setConfig(this.config);
    }

    public void stop() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        dotLottiePlayer.stop();
        this.mHandler.removeCallbacks(this.mNextFrameRunnable);
    }

    public final boolean isPaused() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.isPaused();
    }

    public final boolean isStopped() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.isStopped();
    }

    public final void setCurrentFrame(float frame) {
        this.mHandler.removeCallbacks(this.mNextFrameRunnable);
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        dotLottiePlayer.setFrame(frame);
        DotLottiePlayer dotLottiePlayer2 = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer2);
        dotLottiePlayer2.render();
        this.invalidateSelf();
    }

    public final void setSegment(float first, float second) {
        Object[] objectArray = new Float[]{Float.valueOf(first), Float.valueOf(second)};
        this.config.setSegment(CollectionsKt.listOf((Object[])objectArray));
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        dotLottiePlayer.setConfig(this.config);
    }

    public final void loadAnimation(@NotNull String animationId) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)animationId, (String)"animationId");
            DotLottiePlayer dotLottiePlayer = this.dlPlayer;
            if (dotLottiePlayer == null) break block0;
            dotLottiePlayer.loadAnimation-BltQuoY(animationId, UInt.constructor-impl((int)this.width), UInt.constructor-impl((int)this.height));
        }
    }

    public final void setTheme(@NotNull String themeId) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)themeId, (String)"themeId");
            DotLottiePlayer dotLottiePlayer = this.dlPlayer;
            if (dotLottiePlayer == null) break block0;
            dotLottiePlayer.setTheme(themeId);
        }
    }

    public final void setThemeData(@NotNull String themeData) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)themeData, (String)"themeData");
            DotLottiePlayer dotLottiePlayer = this.dlPlayer;
            if (dotLottiePlayer == null) break block0;
            dotLottiePlayer.setThemeData(themeData);
        }
    }

    public final void resetTheme() {
        block0: {
            DotLottiePlayer dotLottiePlayer = this.dlPlayer;
            if (dotLottiePlayer == null) break block0;
            dotLottiePlayer.resetTheme();
        }
    }

    public final void setSlots(@NotNull String slots) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)slots, (String)"slots");
            DotLottiePlayer dotLottiePlayer = this.dlPlayer;
            if (dotLottiePlayer == null) break block0;
            dotLottiePlayer.setSlots(slots);
        }
    }

    @Nullable
    public final Manifest manifest() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        return dotLottiePlayer != null ? dotLottiePlayer.manifest() : null;
    }

    public final void pause() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        dotLottiePlayer.pause();
        this.mHandler.removeCallbacks(this.mNextFrameRunnable);
    }

    public final boolean startStateMachine() {
        boolean result;
        block1: {
            DotLottiePlayer dotLottiePlayer = this.dlPlayer;
            boolean bl = result = dotLottiePlayer != null ? dotLottiePlayer.startStateMachine() : false;
            if (!result) break block1;
            DotLottiePlayer dotLottiePlayer2 = this.dlPlayer;
            if (dotLottiePlayer2 != null) {
                dotLottiePlayer2.stateMachineSubscribe(new StateMachineObserver(this){
                    final /* synthetic */ DotLottieDrawable this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onStateEntered(@NotNull String enteringState) {
                        Intrinsics.checkNotNullParameter((Object)enteringState, (String)"enteringState");
                        Iterable $this$forEach$iv = DotLottieDrawable.access$getStateMachineListeners$p(this.this$0);
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            StateMachineEventListener it = (StateMachineEventListener)element$iv;
                            boolean bl = false;
                            it.onStateEntered(enteringState);
                        }
                    }

                    public void onStateExit(@NotNull String leavingState) {
                        Intrinsics.checkNotNullParameter((Object)leavingState, (String)"leavingState");
                        Iterable $this$forEach$iv = DotLottieDrawable.access$getStateMachineListeners$p(this.this$0);
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            StateMachineEventListener it = (StateMachineEventListener)element$iv;
                            boolean bl = false;
                            it.onStateExit(leavingState);
                        }
                    }

                    public void onTransition(@NotNull String previousState, @NotNull String newState) {
                        Intrinsics.checkNotNullParameter((Object)previousState, (String)"previousState");
                        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
                        Iterable $this$forEach$iv = DotLottieDrawable.access$getStateMachineListeners$p(this.this$0);
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            StateMachineEventListener it = (StateMachineEventListener)element$iv;
                            boolean bl = false;
                            it.onTransition(previousState, newState);
                        }
                    }
                });
            }
        }
        return result;
    }

    public final boolean stopStateMachine() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        return dotLottiePlayer != null ? dotLottiePlayer.stopStateMachine() : false;
    }

    public final boolean loadStateMachine(@NotNull String stateMachineId) {
        Intrinsics.checkNotNullParameter((Object)stateMachineId, (String)"stateMachineId");
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        return dotLottiePlayer != null ? dotLottiePlayer.loadStateMachine(stateMachineId) : false;
    }

    public final int postEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        int result = dotLottiePlayer != null ? dotLottiePlayer.postEvent(event) : 0;
        switch (result) {
            case 1: {
                Iterable $this$forEach$iv = this.dotLottieEventListener;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    DotLottieEventListener it = (DotLottieEventListener)element$iv;
                    boolean bl = false;
                    it.onError(new Throwable("Error posting event: " + event));
                }
                break;
            }
            case 2: {
                this.play();
                break;
            }
            case 3: {
                this.pause();
                break;
            }
            case 4: {
                this.invalidateSelf();
            }
        }
        return result;
    }

    public final void addStateMachineEventListener(@NotNull StateMachineEventListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.stateMachineListeners.add(listener);
    }

    public final void removeStateMachineEventListener(@NotNull StateMachineEventListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.stateMachineListeners.remove(listener);
    }

    public final boolean setStateMachineNumericContext(@NotNull String key, float value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        return dotLottiePlayer != null ? dotLottiePlayer.setStateMachineNumericContext(key, value) : false;
    }

    public final boolean setStateMachineStringContext(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        return dotLottiePlayer != null ? dotLottiePlayer.setStateMachineStringContext(key, value) : false;
    }

    public final boolean setStateMachineBooleanContext(@NotNull String key, boolean value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        return dotLottiePlayer != null ? dotLottiePlayer.setStateMachineBooleanContext(key, value) : false;
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (this.bitmapBuffer == null || this.dlPlayer == null) {
            return;
        }
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        float nextFrame = dotLottiePlayer.requestFrame();
        DotLottiePlayer dotLottiePlayer2 = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer2);
        dotLottiePlayer2.setFrame(nextFrame);
        DotLottiePlayer dotLottiePlayer3 = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer3);
        dotLottiePlayer3.render();
        Pointer pointer = this.nativeBuffer;
        Intrinsics.checkNotNull((Object)pointer);
        DotLottiePlayer dotLottiePlayer4 = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer4);
        ByteBuffer bufferBytes = pointer.getByteBuffer(0L, dotLottiePlayer4.bufferLen-s-VKNKU());
        bufferBytes.rewind();
        Bitmap bitmap = this.bitmapBuffer;
        Intrinsics.checkNotNull((Object)bitmap);
        bitmap.copyPixelsFromBuffer((Buffer)bufferBytes);
        bufferBytes.rewind();
        Bitmap bitmap2 = this.bitmapBuffer;
        Intrinsics.checkNotNull((Object)bitmap2);
        canvas.drawBitmap(bitmap2, 0.0f, 0.0f, new Paint());
        this.mHandler.postDelayed(this.mNextFrameRunnable, 0L);
    }

    private static final void mNextFrameRunnable$lambda$1(DotLottieDrawable this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.invalidateSelf();
    }

    public static final /* synthetic */ List access$getDotLottieEventListener$p(DotLottieDrawable $this) {
        return $this.dotLottieEventListener;
    }

    public static final /* synthetic */ List access$getStateMachineListeners$p(DotLottieDrawable $this) {
        return $this.stateMachineListeners;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/lottiefiles/dotlottie/core/drawable/DotLottieDrawable$Companion;", "", "()V", "LOTTIE_INFO_COUNT", "", "LOTTIE_INFO_DURATION", "LOTTIE_INFO_FRAME_COUNT", "TAG", "", "dotlottie_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

