/*
 * Decompiled with CFR 0.152.
 */
package com.lottiefiles.dotlottie.core.drawable;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.FloatRange;
import androidx.compose.runtime.internal.StabilityInferred;
import com.dotlottie.dlplayer.Config;
import com.dotlottie.dlplayer.DotLottiePlayer;
import com.dotlottie.dlplayer.Layout;
import com.dotlottie.dlplayer.Manifest;
import com.dotlottie.dlplayer.Marker;
import com.dotlottie.dlplayer.Mode;
import com.lottiefiles.dotlottie.core.util.DotLottieContent;
import com.lottiefiles.dotlottie.core.util.DotLottieEventListener;
import com.sun.jna.Pointer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.UInt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u0000 x2\u00020\u00012\u00020\u0002:\u0001xB7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020WH\u0016J\b\u0010X\u001a\u00020\u0006H\u0016J\b\u0010Y\u001a\u00020\u0006H\u0016J\b\u0010Z\u001a\u00020\u0006H\u0016J\b\u0010[\u001a\u00020UH\u0002J\u0006\u0010\\\u001a\u00020\u000fJ\b\u0010]\u001a\u00020\u000fH\u0016J\u0006\u0010^\u001a\u00020\u000fJ\u000e\u0010_\u001a\u00020U2\u0006\u0010`\u001a\u000208J\u000e\u0010a\u001a\u00020U2\u0006\u0010b\u001a\u000208J\b\u0010c\u001a\u0004\u0018\u00010dJ\u0006\u0010e\u001a\u00020UJ\u0006\u0010f\u001a\u00020UJ\u0006\u0010g\u001a\u00020UJ\u0016\u0010h\u001a\u00020U2\u0006\u0010i\u001a\u00020\u00062\u0006\u0010j\u001a\u00020\u0006J\u0010\u0010k\u001a\u00020U2\u0006\u0010l\u001a\u00020\u0006H\u0016J\u0012\u0010m\u001a\u00020U2\b\u0010n\u001a\u0004\u0018\u00010oH\u0016J\u000e\u0010p\u001a\u00020U2\u0006\u0010q\u001a\u00020\u0015J\u000e\u0010r\u001a\u00020U2\u0006\u0010D\u001a\u00020EJ\u0016\u0010s\u001a\u00020U2\u0006\u0010t\u001a\u00020\u00152\u0006\u0010u\u001a\u00020\u0015J\b\u0010v\u001a\u00020UH\u0016J\b\u0010w\u001a\u00020UH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u00020\u00158FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u001dR$\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0011\"\u0004\b!\u0010\"R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0011R$\u0010%\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020$8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R$\u0010*\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010\u0011\"\u0004\b,\u0010\"R'\u0010-\u001a\u00020.8FX\u0086\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0010\n\u0002\u00103\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u00109\u001a\u0002082\u0006\u0010\u001e\u001a\u0002088F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u0017\u0010>\u001a\b\u0012\u0004\u0012\u00020?0\t8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u0010\u0010B\u001a\u0004\u0018\u00010CX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010D\u001a\u00020E8F\u00a2\u0006\u0006\u001a\u0004\bF\u0010GR\u001f\u0010H\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0015\u0018\u00010I8F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010KR$\u0010L\u001a\u00020\u00152\u0006\u0010L\u001a\u00020\u00158G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bM\u0010\u0017\"\u0004\bN\u0010\u001dR\u0011\u0010O\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\bP\u0010\u0017R$\u0010Q\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bR\u0010\u0011\"\u0004\bS\u0010\"R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006y"}, d2={"Lcom/lottiefiles/dotlottie/core/drawable/DotLottieDrawable;", "Landroid/graphics/drawable/Drawable;", "Landroid/graphics/drawable/Animatable;", "animationData", "Lcom/lottiefiles/dotlottie/core/util/DotLottieContent;", "width", "", "height", "dotLottieEventListener", "", "Lcom/lottiefiles/dotlottie/core/util/DotLottieEventListener;", "config", "Lcom/dotlottie/dlplayer/Config;", "(Lcom/lottiefiles/dotlottie/core/util/DotLottieContent;IILjava/util/List;Lcom/dotlottie/dlplayer/Config;)V", "autoplay", "", "getAutoplay", "()Z", "bitmapBuffer", "Landroid/graphics/Bitmap;", "currentFrame", "", "getCurrentFrame", "()F", "dlPlayer", "Lcom/dotlottie/dlplayer/DotLottiePlayer;", "duration", "getDuration", "setDuration", "(F)V", "value", "freeze", "getFreeze", "setFreeze", "(Z)V", "isLoaded", "Lcom/dotlottie/dlplayer/Layout;", "layout", "getLayout", "()Lcom/dotlottie/dlplayer/Layout;", "setLayout", "(Lcom/dotlottie/dlplayer/Layout;)V", "loop", "getLoop", "setLoop", "loopCount", "Lkotlin/UInt;", "getLoopCount-pVg5ArA", "()I", "setLoopCount-WZ4Q5Ns", "(I)V", "I", "mHandler", "Landroid/os/Handler;", "mNextFrameRunnable", "Ljava/lang/Runnable;", "", "marker", "getMarker", "()Ljava/lang/String;", "setMarker", "(Ljava/lang/String;)V", "markers", "Lcom/dotlottie/dlplayer/Marker;", "getMarkers", "()Ljava/util/List;", "nativeBuffer", "Lcom/sun/jna/Pointer;", "playMode", "Lcom/dotlottie/dlplayer/Mode;", "getPlayMode", "()Lcom/dotlottie/dlplayer/Mode;", "segment", "Lkotlin/Pair;", "getSegment", "()Lkotlin/Pair;", "speed", "getSpeed", "setSpeed", "totalFrame", "getTotalFrame", "useFrameInterpolation", "getUseFrameInterpolation", "setUseFrameInterpolation", "draw", "", "canvas", "Landroid/graphics/Canvas;", "getIntrinsicHeight", "getIntrinsicWidth", "getOpacity", "initialize", "isPaused", "isRunning", "isStopped", "loadAnimation", "animationId", "loadTheme", "themeId", "manifest", "Lcom/dotlottie/dlplayer/Manifest;", "pause", "play", "release", "resize", "w", "h", "setAlpha", "alpha", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "setCurrentFrame", "frame", "setPlayMode", "setSegment", "first", "second", "start", "stop", "Companion", "dotlottie_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDotLottieDrawable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotLottieDrawable.kt\ncom/lottiefiles/dotlottie/core/drawable/DotLottieDrawable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,282:1\n1855#2,2:283\n1855#2,2:285\n1855#2,2:287\n1855#2,2:289\n1855#2,2:291\n*S KotlinDebug\n*F\n+ 1 DotLottieDrawable.kt\ncom/lottiefiles/dotlottie/core/drawable/DotLottieDrawable\n*L\n144#1:283,2\n38#1:285,2\n42#1:287,2\n165#1:289,2\n172#1:291,2\n*E\n"})
public final class DotLottieDrawable
extends Drawable
implements Animatable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DotLottieContent animationData;
    private int width;
    private int height;
    @NotNull
    private final List<DotLottieEventListener> dotLottieEventListener;
    @NotNull
    private Config config;
    @Nullable
    private Pointer nativeBuffer;
    @Nullable
    private Bitmap bitmapBuffer;
    @Nullable
    private DotLottiePlayer dlPlayer;
    private boolean freeze;
    private float duration;
    private int loopCount;
    @NotNull
    private final Handler mHandler;
    @NotNull
    private final Runnable mNextFrameRunnable;
    public static final int $stable = 8;
    @NotNull
    private static final String TAG = "DotLottieDrawable";
    private static final int LOTTIE_INFO_FRAME_COUNT = 0;
    private static final int LOTTIE_INFO_DURATION = 1;
    private static final int LOTTIE_INFO_COUNT = 2;

    public DotLottieDrawable(@NotNull DotLottieContent animationData, int width, int height, @NotNull List<? extends DotLottieEventListener> dotLottieEventListener, @NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)animationData, (String)"animationData");
        Intrinsics.checkNotNullParameter(dotLottieEventListener, (String)"dotLottieEventListener");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.animationData = animationData;
        this.width = width;
        this.height = height;
        this.dotLottieEventListener = dotLottieEventListener;
        this.config = config;
        this.mHandler = new Handler(Looper.getMainLooper());
        this.mNextFrameRunnable = () -> DotLottieDrawable.mNextFrameRunnable$lambda$1(this);
        try {
            this.initialize();
        }
        catch (Throwable e) {
            Iterable $this$forEach$iv = this.dotLottieEventListener;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DotLottieEventListener it = (DotLottieEventListener)element$iv;
                boolean bl = false;
                it.onLoadError(e);
            }
        }
    }

    public /* synthetic */ DotLottieDrawable(DotLottieContent dotLottieContent, int n, int n2, List list, Config config, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        this(dotLottieContent, n, n2, list, config);
    }

    public final boolean getFreeze() {
        return this.freeze;
    }

    public final void setFreeze(boolean value) {
        if (value) {
            Iterable $this$forEach$iv = this.dotLottieEventListener;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DotLottieEventListener p0 = (DotLottieEventListener)element$iv;
                boolean bl = false;
                p0.onFreeze();
            }
            this.mHandler.removeCallbacks(this.mNextFrameRunnable);
            DotLottiePlayer dotLottiePlayer = this.dlPlayer;
            Intrinsics.checkNotNull((Object)dotLottiePlayer);
            dotLottiePlayer.pause();
        } else {
            Iterable $this$forEach$iv = this.dotLottieEventListener;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DotLottieEventListener p0 = (DotLottieEventListener)element$iv;
                boolean bl = false;
                p0.onUnFreeze();
            }
            DotLottiePlayer dotLottiePlayer = this.dlPlayer;
            Intrinsics.checkNotNull((Object)dotLottiePlayer);
            dotLottiePlayer.play();
            this.invalidateSelf();
        }
        this.freeze = value;
    }

    public final float getDuration() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.duration();
    }

    public final void setDuration(float f) {
        this.duration = f;
    }

    public final int getLoopCount-pVg5ArA() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.loopCount-pVg5ArA();
    }

    public final void setLoopCount-WZ4Q5Ns(int n) {
        this.loopCount = n;
    }

    @Nullable
    public final Pair<Float, Float> getSegment() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        if (dotLottiePlayer.config().getSegment().isEmpty()) {
            return null;
        }
        DotLottiePlayer dotLottiePlayer2 = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer2);
        Float f = dotLottiePlayer2.config().getSegment().get(0);
        DotLottiePlayer dotLottiePlayer3 = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer3);
        return new Pair((Object)f, (Object)dotLottiePlayer3.config().getSegment().get(1));
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return -3;
    }

    public int getIntrinsicWidth() {
        return this.width;
    }

    public int getIntrinsicHeight() {
        return this.height;
    }

    public final boolean getUseFrameInterpolation() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.config().getUseFrameInterpolation();
    }

    public final void setUseFrameInterpolation(boolean value) {
        this.config.setUseFrameInterpolation(value);
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        dotLottiePlayer.setConfig(this.config);
    }

    @NotNull
    public final Mode getPlayMode() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.config().getMode();
    }

    public final float getTotalFrame() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.totalFrames();
    }

    public final boolean getAutoplay() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.config().getAutoplay();
    }

    public final float getCurrentFrame() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.currentFrame();
    }

    public final boolean getLoop() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.config().getLoopAnimation();
    }

    public final void setLoop(boolean value) {
        this.config.setLoopAnimation(value);
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        dotLottiePlayer.setConfig(this.config);
    }

    @NotNull
    public final String getMarker() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.config().getMarker();
    }

    public final void setMarker(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.config.setMarker(value);
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        dotLottiePlayer.setConfig(this.config);
    }

    @NotNull
    public final List<Marker> getMarkers() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.markers();
    }

    @NotNull
    public final Layout getLayout() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.config().getLayout();
    }

    public final void setLayout(@NotNull Layout value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.config.setLayout(value);
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        dotLottiePlayer.setConfig(this.config);
    }

    @FloatRange(from=0.0)
    public final float getSpeed() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.config().getSpeed();
    }

    public final void setSpeed(float speed) {
        this.config.setSpeed(speed);
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        dotLottiePlayer.setConfig(this.config);
    }

    public final boolean isLoaded() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.isLoaded();
    }

    private final void initialize() {
        this.dlPlayer = new DotLottiePlayer(this.config);
        DotLottieContent dotLottieContent = this.animationData;
        if (dotLottieContent instanceof DotLottieContent.Json) {
            DotLottiePlayer dotLottiePlayer = this.dlPlayer;
            Intrinsics.checkNotNull((Object)dotLottiePlayer);
            dotLottiePlayer.loadAnimationData-BltQuoY(((DotLottieContent.Json)this.animationData).getJsonString(), UInt.constructor-impl((int)this.width), UInt.constructor-impl((int)this.height));
        } else if (dotLottieContent instanceof DotLottieContent.Binary) {
            DotLottiePlayer dotLottiePlayer = this.dlPlayer;
            Intrinsics.checkNotNull((Object)dotLottiePlayer);
            dotLottiePlayer.loadDotlottieData-BltQuoY(((DotLottieContent.Binary)this.animationData).getData(), UInt.constructor-impl((int)this.width), UInt.constructor-impl((int)this.height));
        }
        this.bitmapBuffer = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        this.nativeBuffer = new Pointer(dotLottiePlayer.bufferPtr-s-VKNKU());
        Iterable $this$forEach$iv = this.dotLottieEventListener;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DotLottieEventListener it = (DotLottieEventListener)element$iv;
            boolean bl = false;
            DotLottiePlayer dotLottiePlayer2 = this.dlPlayer;
            Intrinsics.checkNotNull((Object)dotLottiePlayer2);
            dotLottiePlayer2.subscribe(it);
        }
    }

    public final void release() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        dotLottiePlayer.destroy();
        Iterable $this$forEach$iv = this.dotLottieEventListener;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DotLottieEventListener p0 = (DotLottieEventListener)element$iv;
            boolean bl = false;
            p0.onDestroy();
        }
        if (this.bitmapBuffer != null) {
            Bitmap bitmap = this.bitmapBuffer;
            if (bitmap != null) {
                bitmap.recycle();
            }
            this.bitmapBuffer = null;
        }
    }

    public final void resize(int w, int h) {
        this.width = w;
        this.height = h;
        Bitmap bitmap = this.bitmapBuffer;
        if (bitmap != null) {
            bitmap.recycle();
        }
        this.bitmapBuffer = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        dotLottiePlayer.resize-feOb9K0(UInt.constructor-impl((int)this.width), UInt.constructor-impl((int)this.height));
        DotLottiePlayer dotLottiePlayer2 = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer2);
        this.nativeBuffer = new Pointer(dotLottiePlayer2.bufferPtr-s-VKNKU());
    }

    public boolean isRunning() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.isPlaying();
    }

    public final void play() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        dotLottiePlayer.play();
        this.invalidateSelf();
    }

    public void start() {
        this.play();
    }

    public final void setPlayMode(@NotNull Mode playMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)playMode), (String)"playMode");
        this.config.setMode(playMode);
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        dotLottiePlayer.setConfig(this.config);
    }

    public void stop() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        dotLottiePlayer.stop();
        this.mHandler.removeCallbacks(this.mNextFrameRunnable);
    }

    public final boolean isPaused() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.isPaused();
    }

    public final boolean isStopped() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        return dotLottiePlayer.isStopped();
    }

    public final void setCurrentFrame(float frame) {
        this.mHandler.removeCallbacks(this.mNextFrameRunnable);
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        dotLottiePlayer.setFrame(frame);
        DotLottiePlayer dotLottiePlayer2 = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer2);
        dotLottiePlayer2.render();
        this.invalidateSelf();
    }

    public final void setSegment(float first, float second) {
        Object[] objectArray = new Float[]{Float.valueOf(first), Float.valueOf(second)};
        this.config.setSegment(CollectionsKt.listOf((Object[])objectArray));
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        dotLottiePlayer.setConfig(this.config);
    }

    public final void loadAnimation(@NotNull String animationId) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)animationId, (String)"animationId");
            DotLottiePlayer dotLottiePlayer = this.dlPlayer;
            if (dotLottiePlayer == null) break block0;
            dotLottiePlayer.loadAnimation-BltQuoY(animationId, UInt.constructor-impl((int)this.width), UInt.constructor-impl((int)this.height));
        }
    }

    public final void loadTheme(@NotNull String themeId) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)themeId, (String)"themeId");
            DotLottiePlayer dotLottiePlayer = this.dlPlayer;
            if (dotLottiePlayer == null) break block0;
            dotLottiePlayer.loadTheme(themeId);
        }
    }

    @Nullable
    public final Manifest manifest() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        return dotLottiePlayer != null ? dotLottiePlayer.manifest() : null;
    }

    public final void pause() {
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        dotLottiePlayer.pause();
        this.mHandler.removeCallbacks(this.mNextFrameRunnable);
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (this.bitmapBuffer == null || this.dlPlayer == null) {
            return;
        }
        DotLottiePlayer dotLottiePlayer = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer);
        float nextFrame = dotLottiePlayer.requestFrame();
        DotLottiePlayer dotLottiePlayer2 = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer2);
        dotLottiePlayer2.setFrame(nextFrame);
        DotLottiePlayer dotLottiePlayer3 = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer3);
        dotLottiePlayer3.render();
        Pointer pointer = this.nativeBuffer;
        Intrinsics.checkNotNull((Object)pointer);
        DotLottiePlayer dotLottiePlayer4 = this.dlPlayer;
        Intrinsics.checkNotNull((Object)dotLottiePlayer4);
        ByteBuffer bufferBytes = pointer.getByteBuffer(0L, dotLottiePlayer4.bufferLen-s-VKNKU());
        bufferBytes.rewind();
        Bitmap bitmap = this.bitmapBuffer;
        Intrinsics.checkNotNull((Object)bitmap);
        bitmap.copyPixelsFromBuffer((Buffer)bufferBytes);
        bufferBytes.rewind();
        Bitmap bitmap2 = this.bitmapBuffer;
        Intrinsics.checkNotNull((Object)bitmap2);
        canvas.drawBitmap(bitmap2, 0.0f, 0.0f, new Paint());
        this.mHandler.postDelayed(this.mNextFrameRunnable, 0L);
    }

    private static final void mNextFrameRunnable$lambda$1(DotLottieDrawable this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.invalidateSelf();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/lottiefiles/dotlottie/core/drawable/DotLottieDrawable$Companion;", "", "()V", "LOTTIE_INFO_COUNT", "", "LOTTIE_INFO_DURATION", "LOTTIE_INFO_FRAME_COUNT", "TAG", "", "dotlottie_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

