/*
 * Decompiled with CFR 0.152.
 */
package com.dotlottie.dlplayer;

import androidx.compose.runtime.internal.StabilityInferred;
import com.dotlottie.dlplayer.FfiConverter;
import com.dotlottie.dlplayer.RustBuffer;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0015\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\t\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/dotlottie/dlplayer/FfiConverterFloat;", "Lcom/dotlottie/dlplayer/FfiConverter;", "", "()V", "allocationSize", "", "value", "lift", "(F)Ljava/lang/Float;", "lower", "read", "buf", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)Ljava/lang/Float;", "write", "", "dotlottie_release"})
@StabilityInferred(parameters=0)
public final class FfiConverterFloat
implements FfiConverter<Float, Float> {
    @NotNull
    public static final FfiConverterFloat INSTANCE = new FfiConverterFloat();
    public static final int $stable;

    private FfiConverterFloat() {
    }

    @Override
    @NotNull
    public Float lift(float value) {
        return Float.valueOf(value);
    }

    @Override
    @NotNull
    public Float read(@NotNull ByteBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        return Float.valueOf(buf.getFloat());
    }

    @Override
    @NotNull
    public Float lower(float value) {
        return Float.valueOf(value);
    }

    @Override
    public int allocationSize(float value) {
        return 4;
    }

    @Override
    public void write(float value, @NotNull ByteBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        buf.putFloat(value);
    }

    @Override
    @NotNull
    public RustBuffer.ByValue lowerIntoRustBuffer(float value) {
        return FfiConverter.DefaultImpls.lowerIntoRustBuffer(this, Float.valueOf(value));
    }

    @Override
    @NotNull
    public Float liftFromRustBuffer(@NotNull RustBuffer.ByValue rbuf) {
        return FfiConverter.DefaultImpls.liftFromRustBuffer(this, rbuf);
    }
}

