/*
 * Decompiled with CFR 0.152.
 */
package com.ruiwenliu.Horizontallibrary;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import com.ruiwenliu.Horizontallibrary.adapter.BaseRecyclerviewAdapter;
import com.ruiwenliu.Horizontallibrary.adapter.HorizontalAdapter;
import com.ruiwenliu.Horizontallibrary.inter.ItemValue;
import com.ruiwenliu.Horizontallibrary.inter.OnEditAttributeLstener;
import com.ruiwenliu.Horizontallibrary.inter.OnItemClickListener;
import com.ruiwenliu.Horizontallibrary.weight.GallerySnapHelper;
import com.ruiwenliu.Horizontallibrary.weight.SpaceItemDecoration;
import com.zhy.autolayout.utils.AutoUtils;
import java.util.List;

public class HorizontalScrollview<D, T extends BaseRecyclerviewAdapter>
extends RecyclerView {
    private Context mContext;
    private T mAdapter;
    private int itemSpace;
    private boolean isAdjust;
    private OnEditAttributeLstener attributeLstener;

    public HorizontalScrollview(Context context) {
        super(context);
        this.mContext = context;
    }

    public HorizontalScrollview(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
    }

    protected void onDetachedFromWindow() {
        this.attributeLstener = null;
        super.onDetachedFromWindow();
    }

    public void setCustomAdjustMode(boolean isAdjust) {
        this.isAdjust = isAdjust;
    }

    public void setItemSpace(int space) {
        this.itemSpace = space;
    }

    public HorizontalScrollview setCustomAdapter(T adapter) {
        if (adapter != null) {
            this.mAdapter = adapter;
            this.setLayoutManager((RecyclerView.LayoutManager)(this.isAdjust ? new GridLayoutManager(this.mContext, ((BaseRecyclerviewAdapter)((Object)this.mAdapter)).getItemCount()) : new LinearLayoutManager(this.mContext, 0, false)));
            this.setAdapter((RecyclerView.Adapter)this.mAdapter);
            if (!this.isAdjust) {
                this.addItemDecoration(new SpaceItemDecoration(this.itemSpace == 0 ? AutoUtils.getPercentWidthSize((int)10) : this.itemSpace, ((BaseRecyclerviewAdapter)((Object)this.mAdapter)).getData().size()));
                GallerySnapHelper snapHelper = new GallerySnapHelper();
                snapHelper.attachToRecyclerView(this);
            }
        }
        return this;
    }

    public HorizontalScrollview setAdapter(List<ItemValue> list, OnEditAttributeLstener lstener) {
        if (list != null) {
            this.attributeLstener = lstener;
            this.mAdapter = new HorizontalAdapter(this.attributeLstener);
            this.isAdjust = this.attributeLstener != null ? this.attributeLstener.isAdjustModel() : false;
            this.setLayoutManager((RecyclerView.LayoutManager)(this.isAdjust ? new GridLayoutManager(this.mContext, list.size()) : new LinearLayoutManager(this.mContext, 0, false)));
            this.setAdapter((RecyclerView.Adapter)this.mAdapter);
            ((BaseRecyclerviewAdapter)((Object)this.mAdapter)).setNewData(list);
            if (!this.isAdjust) {
                this.addItemDecoration(new SpaceItemDecoration(this.itemSpace == 0 ? AutoUtils.getPercentWidthSize((int)10) : this.itemSpace, ((BaseRecyclerviewAdapter)((Object)this.mAdapter)).getData().size()));
                GallerySnapHelper snapHelper = new GallerySnapHelper();
                snapHelper.attachToRecyclerView(this);
            }
        }
        return this;
    }

    public void setNewData(List<D> list) {
        this.setLayoutManager((RecyclerView.LayoutManager)(this.isAdjust ? new GridLayoutManager(this.mContext, list.size()) : new LinearLayoutManager(this.mContext, 0, false)));
        ((BaseRecyclerviewAdapter)((Object)this.mAdapter)).setNewData(list);
        ((BaseRecyclerviewAdapter)((Object)this.mAdapter)).setSelect(0);
    }

    public void setOnItemClickListerter(OnItemClickListener itemClickListerter) {
        if (this.mAdapter != null) {
            ((BaseRecyclerviewAdapter)((Object)this.mAdapter)).setOnItemClickListener(itemClickListerter);
        }
    }

    public void setScrollPosition(int position) {
        if (this.mAdapter != null) {
            this.scrollToPosition(position);
            ((BaseRecyclerviewAdapter)((Object)this.mAdapter)).setSelect(position);
        }
    }
}

