/*
 * Decompiled with CFR 0.152.
 */
package com.wega.library.loadingDialog;

import android.app.Dialog;
import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.wega.library.R;

public class LoadingDialog
extends Dialog {
    private ProgressBar mPbLoadingProgress;
    private TextView mTvLoadingDialogText;
    private CharSequence mLoading_text;
    private CharSequence mSuccess_text;
    private CharSequence mFail_text;
    private long defaultDelayMillis = 1000L;
    private Context mContext;

    public LoadingDialog(@NonNull Context context) {
        super(context, R.style.style_loading_dialog);
        this.mContext = context;
        this.setContentView(R.layout.layout_loading_dialog);
        this.initView();
        this.setup();
    }

    private void initView() {
        this.mTvLoadingDialogText = (TextView)this.findViewById(R.id.tv_loading_dialog_text);
        this.mPbLoadingProgress = (ProgressBar)this.findViewById(R.id.pb_loading_progress);
    }

    private void setup() {
        this.setCancelable(false);
        this.mLoading_text = this.mContext.getString(R.string.loading);
        this.mSuccess_text = this.mContext.getString(R.string.load_success);
        this.mFail_text = this.mContext.getString(R.string.load_fail);
    }

    private void setLoading_text(CharSequence loading_text) {
        this.mLoading_text = loading_text;
    }

    private void setSuccess_text(CharSequence success_text) {
        this.mSuccess_text = success_text;
    }

    private void setFail_text(CharSequence fail_text) {
        this.mFail_text = fail_text;
    }

    public void loading() {
        this.loading(this.mLoading_text);
    }

    public void loading(CharSequence loading_text) {
        this.mTvLoadingDialogText.setText(loading_text);
        if (!this.isShowing()) {
            this.show();
        }
    }

    public void loadSuccess() {
        this.loadComplete(this.mSuccess_text);
    }

    public void loadSuccess(CharSequence success_text) {
        this.loadComplete(success_text);
    }

    public void loadFail() {
        this.loadComplete(this.mFail_text);
    }

    public void loadFail(CharSequence fail_text) {
        this.loadComplete(fail_text);
    }

    public void loadComplete(CharSequence completeText) {
        this.mTvLoadingDialogText.setText(completeText);
        this.cancelDelay(this.defaultDelayMillis);
    }

    public void cancelDelay(long delayMillis) {
        this.mTvLoadingDialogText.postDelayed(new Runnable(){

            @Override
            public void run() {
                LoadingDialog.this.cancel();
            }
        }, delayMillis);
    }

    public static class Builder {
        private Context mBuilder_Context;
        private CharSequence mBuilder_Loading_text;
        private CharSequence mBuilder_Success_text;
        private CharSequence mBuilder_Fail_text;
        private LoadingDialog mLoadingDialog;

        public Builder(Context context) {
            this.mBuilder_Context = context;
        }

        public LoadingDialog create() {
            if (this.mLoadingDialog == null) {
                this.mLoadingDialog = new LoadingDialog(this.mBuilder_Context);
                if (!TextUtils.isEmpty((CharSequence)this.mBuilder_Loading_text)) {
                    this.mLoadingDialog.setLoading_text(this.mBuilder_Loading_text);
                }
                if (!TextUtils.isEmpty((CharSequence)this.mBuilder_Success_text)) {
                    this.mLoadingDialog.setSuccess_text(this.mBuilder_Success_text);
                }
                if (!TextUtils.isEmpty((CharSequence)this.mBuilder_Fail_text)) {
                    this.mLoadingDialog.setFail_text(this.mBuilder_Fail_text);
                }
            }
            return this.mLoadingDialog;
        }

        public Builder setLoading_text(CharSequence loading_text) {
            this.mBuilder_Loading_text = loading_text;
            return this;
        }

        public Builder setSuccess_text(CharSequence success_text) {
            this.mBuilder_Success_text = success_text;
            return this;
        }

        public Builder setFail_text(CharSequence fail_text) {
            this.mBuilder_Fail_text = fail_text;
            return this;
        }
    }
}

