/*
 * Decompiled with CFR 0.152.
 */
package com.zhengsr.tablib.view.action;

import android.graphics.Canvas;
import android.view.View;
import com.zhengsr.tablib.bean.TabBean;
import com.zhengsr.tablib.bean.TabValue;
import com.zhengsr.tablib.view.action.BaseAction;
import com.zhengsr.tablib.view.flow.TabFlowLayout;

public class RoundAction
extends BaseAction {
    private static final String TAG = "RoundAction";
    private float mRound;

    @Override
    public void configAttrs(TabBean bean) {
        super.configAttrs(bean);
        if (bean.tabRoundSize != -1) {
            this.mRound = bean.tabRoundSize;
        }
    }

    @Override
    public void config(TabFlowLayout parentView) {
        super.config(parentView);
        View child = parentView.getChildAt(0);
        if (child != null) {
            float l = this.mTabBean.tabMarginLeft + child.getLeft();
            float t = this.mTabBean.tabMarginTop + child.getTop();
            float r = child.getRight() - this.mTabBean.tabMarginRight;
            float b = child.getBottom() - this.mTabBean.tabMarginBottom;
            if (this.mTabBean.tabWidth != -1) {
                r = (float)this.mTabBean.tabWidth + (l += (float)((child.getMeasuredWidth() - this.mTabBean.tabWidth) / 2));
            }
            this.mTabRect.set(l, t, r, b);
        }
        parentView.postInvalidate();
    }

    @Override
    protected void valueChange(TabValue value) {
        if (this.isVertical()) {
            this.mTabRect.top = value.top;
            this.mTabRect.bottom = value.bottom;
        }
        this.mTabRect.left = value.left;
        this.mTabRect.right = value.right;
    }

    @Override
    public void draw(Canvas canvas) {
        canvas.drawRoundRect(this.mTabRect, this.mRound, this.mRound, this.mPaint);
    }
}

