/*
 * Decompiled with CFR 0.152.
 */
package com.zhengsr.tablib.view.action;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import com.zhengsr.tablib.bean.TabBean;
import com.zhengsr.tablib.bean.TabValue;
import com.zhengsr.tablib.view.action.BaseAction;
import com.zhengsr.tablib.view.flow.TabFlowLayout;

public class ResAction
extends BaseAction {
    private static final String TAG = "ResAction";
    private Bitmap mBitmap;
    private Rect mSrcRect;
    private Drawable mDrawable;
    private int mRes = -1;

    @Override
    public void configAttrs(TabBean bean) {
        super.configAttrs(bean);
        this.mRes = bean.tabItemRes;
    }

    @Override
    public void config(TabFlowLayout parentView) {
        View child;
        super.config(parentView);
        if (this.mRes != -1) {
            this.mDrawable = this.mContext.getResources().getDrawable(this.mRes);
        }
        if ((child = parentView.getChildAt(0)) != null && this.mDrawable != null) {
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            this.mBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(this.mBitmap);
            float l = this.mTabBean.tabMarginLeft + child.getLeft();
            float t = this.mTabBean.tabMarginTop + child.getTop();
            float r = child.getRight() - this.mTabBean.tabMarginRight;
            float b = child.getBottom() - this.mTabBean.tabMarginBottom;
            this.mDrawable.setBounds(0, 0, width, height);
            this.mDrawable.draw(canvas);
            if (this.mTabBean.tabWidth != -1) {
                r = (float)this.mTabBean.tabWidth + (l += (float)((child.getMeasuredWidth() - this.mTabBean.tabWidth) / 2));
            }
            this.mTabRect.set(l, t, r, b);
            this.mSrcRect = new Rect(0, 0, width, height);
        }
    }

    @Override
    protected void valueChange(TabValue value) {
        if (this.isVertical()) {
            this.mTabRect.top = value.top;
            this.mTabRect.bottom = value.bottom;
        }
        this.mTabRect.left = value.left;
        this.mTabRect.right = value.right;
    }

    @Override
    public void draw(Canvas canvas) {
        if (this.mBitmap != null) {
            canvas.drawBitmap(this.mBitmap, this.mSrcRect, this.mTabRect, this.mPaint);
        }
    }
}

