/*
 * Decompiled with CFR 0.152.
 */
package com.zhengsr.tablib.view.action;

import android.graphics.Canvas;
import android.graphics.Path;
import android.view.View;
import com.zhengsr.tablib.bean.TabValue;
import com.zhengsr.tablib.view.action.BaseAction;
import com.zhengsr.tablib.view.flow.TabFlowLayout;

public class TriAction
extends BaseAction {
    private static final String TAG = "TriAction";
    private Path mPath;

    @Override
    public void config(TabFlowLayout parentView) {
        super.config(parentView);
        this.mPath = new Path();
        View child = parentView.getChildAt(0);
        if (child != null) {
            float b;
            float r;
            float t;
            float l;
            if (this.isLeftAction()) {
                l = child.getLeft() + this.mTabBean.tabMarginLeft;
                t = child.getTop() + this.mTabBean.tabMarginTop;
                r = l + (float)this.mTabBean.tabWidth;
                b = t + (float)child.getBottom() - (float)this.mTabBean.tabMarginBottom;
                if (this.mTabBean.tabHeight != -1) {
                    b = (t += (float)((child.getMeasuredHeight() - this.mTabBean.tabHeight) / 2)) + (float)this.mTabBean.tabHeight;
                }
            } else if (this.isRightAction()) {
                l = child.getRight() - this.mTabBean.tabMarginRight;
                t = child.getTop() - this.mTabBean.tabMarginTop;
                r = l - (float)this.mTabBean.tabWidth;
                b = t + (float)this.mTabBean.tabHeight;
                if (this.mTabBean.tabHeight != -1) {
                    b = (t += (float)((child.getMeasuredHeight() - this.mTabBean.tabHeight) / 2)) + (float)this.mTabBean.tabHeight;
                }
            } else {
                l = this.mTabBean.tabMarginLeft + child.getLeft();
                t = this.mTabBean.tabMarginTop + child.getBottom() - this.mTabBean.tabHeight - this.mTabBean.tabMarginBottom;
                r = child.getRight() - this.mTabBean.tabMarginRight;
                b = t + (float)this.mTabBean.tabHeight;
                if (this.mTabBean.tabWidth != -1) {
                    r = (float)this.mTabBean.tabWidth + (l += (float)((child.getMeasuredWidth() - this.mTabBean.tabWidth) / 2));
                }
            }
            this.mTabRect.set(l, t, r, b);
            if (this.isVertical()) {
                this.mPath.moveTo(r, t + (float)(this.mTabBean.tabHeight / 2));
                this.mPath.lineTo(l, t);
                this.mPath.lineTo(l, b);
            } else {
                this.mPath.moveTo(l + (float)(this.mTabBean.tabWidth / 2), t);
                this.mPath.lineTo(l, b);
                this.mPath.lineTo(r, b);
            }
        }
    }

    @Override
    protected void valueChange(TabValue value) {
        super.valueChange(value);
        this.mPath.reset();
        if (this.isVertical()) {
            this.mTabRect.set(value.valueToRect());
            float l = this.mTabRect.left;
            float t = this.mTabRect.top;
            float r = this.mTabRect.right;
            float b = this.mTabRect.bottom;
            if (this.isRightAction()) {
                l = r;
                r = l - (float)this.mTabBean.tabWidth;
            }
            this.mPath.moveTo(r, t + (float)(this.mTabBean.tabHeight / 2));
            this.mPath.lineTo(l, t);
            this.mPath.lineTo(l, b);
        } else {
            this.mPath.moveTo(this.mTabRect.width() / 2.0f + this.mTabRect.left, this.mTabRect.top);
            this.mPath.lineTo(this.mTabRect.left, this.mTabRect.bottom);
            this.mPath.lineTo(this.mTabRect.right, this.mTabRect.bottom);
        }
    }

    @Override
    public void draw(Canvas canvas) {
        canvas.drawPath(this.mPath, this.mPaint);
    }
}

