/*
 * Decompiled with CFR 0.152.
 */
package com.kwabenaberko.openweathermaplib.implementation;

import androidx.annotation.NonNull;
import com.kwabenaberko.openweathermaplib.implementation.callback.CurrentWeatherCallback;
import com.kwabenaberko.openweathermaplib.implementation.callback.ThreeHourForecastCallback;
import com.kwabenaberko.openweathermaplib.model.currentweather.CurrentWeather;
import com.kwabenaberko.openweathermaplib.model.threehourforecast.ThreeHourForecast;
import com.kwabenaberko.openweathermaplib.network.OpenWeatherMapClient;
import com.kwabenaberko.openweathermaplib.network.OpenWeatherMapService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class OpenWeatherMapHelper {
    private static final String APPID = "appId";
    private static final String UNITS = "units";
    private static final String LANGUAGE = "lang";
    private static final String QUERY = "q";
    private static final String CITY_ID = "id";
    private static final String LATITUDE = "lat";
    private static final String LONGITUDE = "lon";
    private static final String ZIP_CODE = "zip";
    private final OpenWeatherMapService openWeatherMapService = (OpenWeatherMapService)OpenWeatherMapClient.getClient().create(OpenWeatherMapService.class);
    private final Map<String, String> options = new HashMap<String, String>();

    public OpenWeatherMapHelper(String apiKey) {
        this.options.put(APPID, apiKey == null ? "" : apiKey);
    }

    public void setUnits(String units) {
        this.options.put(UNITS, units);
    }

    public void setLanguage(String lang) {
        this.options.put(LANGUAGE, lang);
    }

    private Throwable NoAppIdErrMessage() {
        return new Throwable("UnAuthorized. Please set a valid OpenWeatherMap API KEY.");
    }

    private Throwable NotFoundErrMsg(String str) {
        Throwable throwable = null;
        try {
            JSONObject obj = new JSONObject(str);
            throwable = new Throwable(obj.getString("message"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (throwable == null) {
            throwable = new Throwable("An unexpected error occurred.");
        }
        return throwable;
    }

    public void getCurrentWeatherByCityName(String city, final CurrentWeatherCallback callback) {
        this.options.put(QUERY, city);
        this.openWeatherMapService.getCurrentWeatherByCityName(this.options).enqueue((Callback)new Callback<CurrentWeather>(){

            public void onResponse(@NonNull Call<CurrentWeather> call, @NonNull Response<CurrentWeather> response) {
                OpenWeatherMapHelper.this.handleCurrentWeatherResponse((Response<CurrentWeather>)response, callback);
            }

            public void onFailure(@NonNull Call<CurrentWeather> call, @NonNull Throwable throwable) {
                callback.onFailure(throwable);
            }
        });
    }

    public void getCurrentWeatherByCityID(String id, final CurrentWeatherCallback callback) {
        this.options.put(CITY_ID, id);
        this.openWeatherMapService.getCurrentWeatherByCityID(this.options).enqueue((Callback)new Callback<CurrentWeather>(){

            public void onResponse(Call<CurrentWeather> call, Response<CurrentWeather> response) {
                OpenWeatherMapHelper.this.handleCurrentWeatherResponse((Response<CurrentWeather>)response, callback);
            }

            public void onFailure(@NonNull Call<CurrentWeather> call, @NonNull Throwable throwable) {
                callback.onFailure(throwable);
            }
        });
    }

    public void getCurrentWeatherByGeoCoordinates(double latitude, double longitude, final CurrentWeatherCallback callback) {
        this.options.put(LATITUDE, String.valueOf(latitude));
        this.options.put(LONGITUDE, String.valueOf(longitude));
        this.openWeatherMapService.getCurrentWeatherByGeoCoordinates(this.options).enqueue((Callback)new Callback<CurrentWeather>(){

            public void onResponse(Call<CurrentWeather> call, Response<CurrentWeather> response) {
                OpenWeatherMapHelper.this.handleCurrentWeatherResponse((Response<CurrentWeather>)response, callback);
            }

            public void onFailure(@NonNull Call<CurrentWeather> call, @NonNull Throwable throwable) {
                callback.onFailure(throwable);
            }
        });
    }

    public void getCurrentWeatherByZipCode(String zipCode, final CurrentWeatherCallback callback) {
        this.options.put(ZIP_CODE, zipCode);
        this.openWeatherMapService.getCurrentWeatherByZipCode(this.options).enqueue((Callback)new Callback<CurrentWeather>(){

            public void onResponse(Call<CurrentWeather> call, Response<CurrentWeather> response) {
                OpenWeatherMapHelper.this.handleCurrentWeatherResponse((Response<CurrentWeather>)response, callback);
            }

            public void onFailure(@NonNull Call<CurrentWeather> call, @NonNull Throwable throwable) {
                callback.onFailure(throwable);
            }
        });
    }

    private void handleCurrentWeatherResponse(Response<CurrentWeather> response, CurrentWeatherCallback callback) {
        if (response.code() == 200) {
            callback.onSuccess((CurrentWeather)response.body());
        } else if (response.code() == 403 || response.code() == 401) {
            callback.onFailure(this.NoAppIdErrMessage());
        } else {
            try {
                callback.onFailure(this.NotFoundErrMsg(response.errorBody().string()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void getThreeHourForecastByCityName(String city, final ThreeHourForecastCallback callback) {
        this.options.put(QUERY, city);
        this.openWeatherMapService.getThreeHourForecastByCityName(this.options).enqueue((Callback)new Callback<ThreeHourForecast>(){

            public void onResponse(@NonNull Call<ThreeHourForecast> call, @NonNull Response<ThreeHourForecast> response) {
                OpenWeatherMapHelper.this.handleThreeHourForecastResponse((Response<ThreeHourForecast>)response, callback);
            }

            public void onFailure(@NonNull Call<ThreeHourForecast> call, @NonNull Throwable throwable) {
                callback.onFailure(throwable);
            }
        });
    }

    public void getThreeHourForecastByCityID(String id, final ThreeHourForecastCallback callback) {
        this.options.put(CITY_ID, id);
        this.openWeatherMapService.getThreeHourForecastByCityID(this.options).enqueue((Callback)new Callback<ThreeHourForecast>(){

            public void onResponse(@NonNull Call<ThreeHourForecast> call, @NonNull Response<ThreeHourForecast> response) {
                OpenWeatherMapHelper.this.handleThreeHourForecastResponse((Response<ThreeHourForecast>)response, callback);
            }

            public void onFailure(@NonNull Call<ThreeHourForecast> call, @NonNull Throwable throwable) {
                callback.onFailure(throwable);
            }
        });
    }

    public void getThreeHourForecastByGeoCoordinates(double latitude, double longitude, final ThreeHourForecastCallback callback) {
        this.options.put(LATITUDE, String.valueOf(latitude));
        this.options.put(LONGITUDE, String.valueOf(longitude));
        this.openWeatherMapService.getThreeHourForecastByGeoCoordinates(this.options).enqueue((Callback)new Callback<ThreeHourForecast>(){

            public void onResponse(@NonNull Call<ThreeHourForecast> call, @NonNull Response<ThreeHourForecast> response) {
                OpenWeatherMapHelper.this.handleThreeHourForecastResponse((Response<ThreeHourForecast>)response, callback);
            }

            public void onFailure(@NonNull Call<ThreeHourForecast> call, @NonNull Throwable throwable) {
                callback.onFailure(throwable);
            }
        });
    }

    public void getThreeHourForecastByZipCode(String zipCode, final ThreeHourForecastCallback callback) {
        this.options.put(ZIP_CODE, zipCode);
        this.openWeatherMapService.getThreeHourForecastByZipCode(this.options).enqueue((Callback)new Callback<ThreeHourForecast>(){

            public void onResponse(@NonNull Call<ThreeHourForecast> call, @NonNull Response<ThreeHourForecast> response) {
                OpenWeatherMapHelper.this.handleThreeHourForecastResponse((Response<ThreeHourForecast>)response, callback);
            }

            public void onFailure(@NonNull Call<ThreeHourForecast> call, @NonNull Throwable throwable) {
                callback.onFailure(throwable);
            }
        });
    }

    private void handleThreeHourForecastResponse(Response<ThreeHourForecast> response, ThreeHourForecastCallback callback) {
        if (response.code() == 200) {
            callback.onSuccess((ThreeHourForecast)response.body());
        } else if (response.code() == 403 || response.code() == 401) {
            callback.onFailure(this.NoAppIdErrMessage());
        } else {
            try {
                callback.onFailure(this.NotFoundErrMsg(response.errorBody().string()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

