/*
 * Decompiled with CFR 0.152.
 */
package com.kunzisoft.switchdatetime.date.widget;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.kunzisoft.switchdatetime.R;
import java.util.List;

class YearPickerAdapter
extends BaseAdapter {
    private static final int LIST_ITEM_TYPE_STANDARD = 0;
    private static final int LIST_ITEM_TYPE_INDICATOR = 1;
    private static final int LIST_ITEM_TYPE_COUNT = 2;
    private List<Integer> listYears;
    private int selectedYear;
    private LayoutInflater layoutInflater;

    YearPickerAdapter(Context context, List<Integer> listYears, int selectedYear) {
        this.listYears = listYears;
        this.selectedYear = selectedYear;
        this.layoutInflater = LayoutInflater.from((Context)context);
    }

    public int getCount() {
        return this.listYears.size();
    }

    public Object getItem(int i) {
        return this.listYears.get(i);
    }

    public long getItemId(int i) {
        return this.listYears.get(i).intValue();
    }

    public int getItemViewType(int position) {
        if (this.listYears.get(position) == this.selectedYear) {
            return 1;
        }
        return 0;
    }

    public int getViewTypeCount() {
        return 2;
    }

    @NonNull
    public View getView(int position, View convertView, @NonNull ViewGroup parent) {
        TextIndicatorViewHolder holder;
        int type = this.getItemViewType(position);
        if (convertView == null) {
            holder = new TextIndicatorViewHolder();
            switch (type) {
                case 0: {
                    convertView = this.layoutInflater.inflate(R.layout.year_text, parent, false);
                    break;
                }
                case 1: {
                    convertView = this.layoutInflater.inflate(R.layout.year_text_indicator, parent, false);
                }
            }
            assert (convertView != null);
            convertView.setTag((Object)holder);
        } else {
            holder = (TextIndicatorViewHolder)convertView.getTag();
        }
        holder.textView = (TextView)convertView.findViewById(R.id.year_textView);
        holder.textView.setText((CharSequence)String.valueOf(this.listYears.get(position)));
        return convertView;
    }

    public List<Integer> getListYears() {
        return this.listYears;
    }

    public void setListYears(List<Integer> listYears) {
        this.listYears = listYears;
    }

    public int getSelectedYear() {
        return this.selectedYear;
    }

    public void setSelectedYear(int selectedYear) {
        this.selectedYear = selectedYear;
    }

    private class TextIndicatorViewHolder {
        TextView textView;

        private TextIndicatorViewHolder() {
        }
    }
}

