/*
 * Decompiled with CFR 0.152.
 */
package com.kunzisoft.switchdatetime;

import android.animation.Keyframe;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.annotation.SuppressLint;
import android.os.Build;
import android.view.View;
import android.view.accessibility.AccessibilityManager;

public class Utils {
    private static final int ANIMATION_DELAY = 0;
    private static final int PULSE_ANIMATOR_DURATION = 544;

    public static void animLabelElement(View view) {
        ObjectAnimator monthDayAnim = Utils.getPulseAnimator(view, 0.9f, 1.05f);
        monthDayAnim.setStartDelay(0L);
        monthDayAnim.start();
    }

    public static ObjectAnimator getPulseAnimator(View labelToAnimate, float decreaseRatio, float increaseRatio) {
        Keyframe k0 = Keyframe.ofFloat((float)0.0f, (float)1.0f);
        Keyframe k1 = Keyframe.ofFloat((float)0.275f, (float)decreaseRatio);
        Keyframe k2 = Keyframe.ofFloat((float)0.69f, (float)increaseRatio);
        Keyframe k3 = Keyframe.ofFloat((float)1.0f, (float)1.0f);
        PropertyValuesHolder scaleX = PropertyValuesHolder.ofKeyframe((String)"scaleX", (Keyframe[])new Keyframe[]{k0, k1, k2, k3});
        PropertyValuesHolder scaleY = PropertyValuesHolder.ofKeyframe((String)"scaleY", (Keyframe[])new Keyframe[]{k0, k1, k2, k3});
        ObjectAnimator pulseAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)labelToAnimate, (PropertyValuesHolder[])new PropertyValuesHolder[]{scaleX, scaleY});
        pulseAnimator.setDuration(544L);
        return pulseAnimator;
    }

    public static boolean isTouchExplorationEnabled(AccessibilityManager accessibilityManager) {
        if (Build.VERSION.SDK_INT >= 14) {
            return accessibilityManager.isTouchExplorationEnabled();
        }
        return false;
    }

    @SuppressLint(value={"NewApi"})
    public static void tryAccessibilityAnnounce(View view, CharSequence text) {
        if (Build.VERSION.SDK_INT >= 16 && view != null && text != null) {
            view.announceForAccessibility(text);
        }
    }
}

