/*
 * Decompiled with CFR 0.152.
 */
package com.kunminx.binding_recyclerview.binding_adapter;

import androidx.databinding.BindingAdapter;
import androidx.recyclerview.widget.ListAdapter;
import androidx.recyclerview.widget.RecyclerView;
import java.util.List;

public class RecyclerViewBindingAdapter {
    @BindingAdapter(value={"adapter"}, requireAll=false)
    public static void setAdapter(RecyclerView recyclerView, RecyclerView.Adapter adapter) {
        recyclerView.setAdapter(adapter);
    }

    @BindingAdapter(value={"submitList"}, requireAll=false)
    public static void submitList(RecyclerView recyclerView, List list) {
        if (recyclerView.getAdapter() != null) {
            ListAdapter adapter = (ListAdapter)recyclerView.getAdapter();
            adapter.submitList(list);
        }
    }

    @BindingAdapter(value={"notifyCurrentListChanged"}, requireAll=false)
    public static void notifyCurrentListChanged(RecyclerView recyclerView, boolean notifyCurrentListChanged) {
        if (notifyCurrentListChanged) {
            recyclerView.getAdapter().notifyDataSetChanged();
        }
    }

    @BindingAdapter(value={"autoScrollToTopWhenInsert", "autoScrollToBottomWhenInsert"}, requireAll=false)
    public static void autoScroll(final RecyclerView recyclerView, final boolean autoScrollToTopWhenInsert, final boolean autoScrollToBottomWhenInsert) {
        if (recyclerView.getAdapter() != null) {
            recyclerView.getAdapter().registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

                public void onItemRangeInserted(int positionStart, int itemCount) {
                    if (autoScrollToTopWhenInsert) {
                        recyclerView.scrollToPosition(0);
                    } else if (autoScrollToBottomWhenInsert) {
                        recyclerView.scrollToPosition(recyclerView.getAdapter().getItemCount());
                    }
                }
            });
        }
    }
}

