/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.providers.types;

import com.fasterxml.jackson.core.JsonParser;
import io.ethers.core.Result;
import io.ethers.providers.JsonRpcClient;
import io.ethers.providers.RpcError;
import io.ethers.providers.types.BatchRpcRequest;
import io.ethers.providers.types.RpcRequest;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u0002B1\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0002\u0010\fB5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00028\u00000\u000e\u00a2\u0006\u0002\u0010\u0010J\"\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00030\u001c0\u001b2\u0006\u0010\u001a\u001a\u00020\u001dH\u0016J\u001a\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00030\u001c0\u001bH\u0016J\u0014\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00030\u001cH\u0016J\b\u0010 \u001a\u00020\u0007H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00028\u00000\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006!"}, d2={"Lio/ethers/providers/types/RpcCall;", "T", "Lio/ethers/providers/types/RpcRequest;", "Lio/ethers/providers/RpcError;", "client", "Lio/ethers/providers/JsonRpcClient;", "method", "", "params", "", "resultType", "Ljava/lang/Class;", "(Lio/ethers/providers/JsonRpcClient;Ljava/lang/String;[Ljava/lang/Object;Ljava/lang/Class;)V", "resultDecoder", "Ljava/util/function/Function;", "Lcom/fasterxml/jackson/core/JsonParser;", "(Lio/ethers/providers/JsonRpcClient;Ljava/lang/String;[Ljava/lang/Object;Ljava/util/function/Function;)V", "getClient", "()Lio/ethers/providers/JsonRpcClient;", "getMethod", "()Ljava/lang/String;", "getParams", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "getResultDecoder", "()Ljava/util/function/Function;", "batch", "Ljava/util/concurrent/CompletableFuture;", "Lio/ethers/core/Result;", "Lio/ethers/providers/types/BatchRpcRequest;", "sendAsync", "sendAwait", "toString", "ethers-providers"})
public final class RpcCall<T>
extends RpcRequest<T, RpcError> {
    @NotNull
    private final JsonRpcClient client;
    @NotNull
    private final String method;
    @NotNull
    private final Object[] params;
    @NotNull
    private final Function<JsonParser, T> resultDecoder;

    public RpcCall(@NotNull JsonRpcClient client, @NotNull String method, @NotNull Object[] params, @NotNull Function<JsonParser, T> resultDecoder) {
        this.client = client;
        this.method = method;
        this.params = params;
        this.resultDecoder = resultDecoder;
    }

    @NotNull
    public final JsonRpcClient getClient() {
        return this.client;
    }

    @NotNull
    public final String getMethod() {
        return this.method;
    }

    @NotNull
    public final Object[] getParams() {
        return this.params;
    }

    @NotNull
    public final Function<JsonParser, T> getResultDecoder() {
        return this.resultDecoder;
    }

    public RpcCall(@NotNull JsonRpcClient client, @NotNull String method, @NotNull Object[] params, @NotNull Class<T> resultType) {
        this(client, method, params, arg_0 -> RpcCall._init_$lambda$0(resultType, arg_0));
    }

    @Override
    @NotNull
    public Result<T, RpcError> sendAwait() {
        return this.sendAsync().join();
    }

    @Override
    @NotNull
    public CompletableFuture<Result<T, RpcError>> sendAsync() {
        return this.client.request(this.method, this.params, this.resultDecoder);
    }

    @Override
    @NotNull
    public CompletableFuture<Result<T, RpcError>> batch(@NotNull BatchRpcRequest batch) {
        return batch.addRpcCall(this);
    }

    @NotNull
    public String toString() {
        String string = Arrays.toString(this.params);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return "RpcCall(method='" + this.method + "', params=" + string + ")";
    }

    private static final Object _init_$lambda$0(Class $resultType, JsonParser p) {
        return p.readValueAs($resultType);
    }
}

