/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.providers.types;

import io.ethers.core.Result;
import io.ethers.core.ResultKt;
import io.ethers.core.types.Hash;
import io.ethers.core.types.TransactionReceipt;
import io.ethers.providers.RpcError;
import io.ethers.providers.middleware.Middleware;
import io.ethers.providers.types.PendingInclusion;
import java.time.Duration;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J,\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/ethers/providers/types/PendingTransaction;", "Lio/ethers/providers/types/PendingInclusion;", "Lio/ethers/core/types/TransactionReceipt;", "hash", "Lio/ethers/core/types/Hash;", "provider", "Lio/ethers/providers/middleware/Middleware;", "(Lio/ethers/core/types/Hash;Lio/ethers/providers/middleware/Middleware;)V", "getHash", "()Lio/ethers/core/types/Hash;", "awaitInclusion", "Lio/ethers/core/Result;", "Lio/ethers/providers/types/PendingInclusion$Error;", "retries", "", "interval", "Ljava/time/Duration;", "confirmations", "toString", "", "ethers-providers"})
public final class PendingTransaction
implements PendingInclusion<TransactionReceipt> {
    @NotNull
    private final Hash hash;
    @NotNull
    private final Middleware provider;

    public PendingTransaction(@NotNull Hash hash, @NotNull Middleware provider) {
        this.hash = hash;
        this.provider = provider;
    }

    @NotNull
    public final Hash getHash() {
        return this.hash;
    }

    @Override
    @NotNull
    public Result<TransactionReceipt, PendingInclusion.Error> awaitInclusion(int retries, @NotNull Duration interval, int confirmations) {
        Object response;
        long intervalMillis = interval.toMillis();
        RpcError receiptError = null;
        TransactionReceipt included = null;
        int retriesLeft = retries;
        while (retriesLeft-- > 0) {
            response = this.provider.getTransactionReceipt(this.hash).sendAwait();
            if (ResultKt.isFailure(response)) {
                receiptError = (RpcError)((Result.Failure)response).getError();
                Thread.sleep(intervalMillis);
                continue;
            }
            included = (TransactionReceipt)OptionalsKt.getOrNull((Optional)((Optional)response.unwrap()));
            if (included != null) break;
            Thread.sleep(intervalMillis);
        }
        if (included == null && receiptError != null) {
            return ResultKt.failure((Result.Error)new PendingInclusion.Error.RpcError(this.hash, receiptError));
        }
        if (included == null) {
            return ResultKt.failure((Result.Error)new PendingInclusion.Error.NoInclusion(this.hash, retries));
        }
        if (!included.isSuccessful()) {
            return ResultKt.failure((Result.Error)new PendingInclusion.Error.TxFailed(this.hash, included));
        }
        if (confirmations <= 1) {
            return ResultKt.success(included);
        }
        while (!ResultKt.isFailure(response = this.provider.getBlockNumber().sendAwait())) {
            long currentBlock = ((Number)response.unwrap()).longValue();
            if (currentBlock - included.getBlockNumber() >= (long)(confirmations - 1)) {
                return ResultKt.success((Object)included);
            }
            Thread.sleep(intervalMillis);
        }
        return ResultKt.failure((Result.Error)new PendingInclusion.Error.RpcError(this.hash, (RpcError)((Result.Failure)response).getError()));
    }

    @NotNull
    public String toString() {
        return "PendingTransaction(hash=" + this.hash + ")";
    }
}

