/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.providers.types;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.ethers.core.Result;
import io.ethers.core.ResultKt;
import io.ethers.providers.BlockingSubscriptionStream;
import io.ethers.providers.RpcError;
import io.ethers.providers.SubscriptionStream;
import io.ethers.providers.middleware.Middleware;
import io.ethers.providers.types.FilterPollerKt;
import io.ethers.providers.types.RpcCall;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010(\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\b\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cH\u0096\u0002J2\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u0000\"\u0004\b\u0001\u0010\u001e2\u001e\u0010\u001f\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001e0\n0\bJ\b\u0010 \u001a\u00020\u001aH\u0016J\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/ethers/providers/types/FilterPoller;", "T", "Lio/ethers/providers/SubscriptionStream;", "id", "", "provider", "Lio/ethers/providers/middleware/Middleware;", "decoder", "Ljava/util/function/Function;", "Lcom/fasterxml/jackson/core/JsonParser;", "", "(Ljava/lang/String;Lio/ethers/providers/middleware/Middleware;Ljava/util/function/Function;)V", "LOG", "Lorg/slf4j/Logger;", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "interval", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "stream", "Lio/ethers/providers/BlockingSubscriptionStream;", "threadFactory", "Ljava/util/concurrent/ThreadFactory;", "unsubscribed", "", "initializePoller", "", "iterator", "", "mapPoller", "R", "mapper", "unsubscribe", "withInterval", "withThreadFactory", "ethers-providers"})
@SourceDebugExtension(value={"SMAP\nFilterPoller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilterPoller.kt\nio/ethers/providers/types/FilterPoller\n+ 2 LoggerExtensions.kt\nio/ethers/logger/LoggerExtensionsKt\n+ 3 Result.kt\nio/ethers/core/ResultKt\n*L\n1#1,152:1\n20#2:153\n63#2,4:154\n63#2,4:159\n63#2,4:163\n45#2,4:167\n231#3:158\n*S KotlinDebug\n*F\n+ 1 FilterPoller.kt\nio/ethers/providers/types/FilterPoller\n*L\n28#1:153\n99#1:154,4\n108#1:159,4\n134#1:163,4\n136#1:167,4\n106#1:158\n*E\n"})
public final class FilterPoller<T>
extends SubscriptionStream<T> {
    @NotNull
    private final String id;
    @NotNull
    private final Middleware provider;
    @NotNull
    private final Function<JsonParser, List<T>> decoder;
    @NotNull
    private final Logger LOG;
    private Duration interval;
    @NotNull
    private ThreadFactory threadFactory;
    private volatile boolean unsubscribed;
    @NotNull
    private final AtomicBoolean initialized;
    @NotNull
    private final BlockingSubscriptionStream<T> stream;

    public FilterPoller(@NotNull String id, @NotNull Middleware provider, @NotNull Function<JsonParser, List<T>> decoder) {
        this.id = id;
        this.provider = provider;
        this.decoder = decoder;
        FilterPoller $this$getLogger$iv = this;
        boolean $i$f$getLogger = false;
        this.LOG = LoggerFactory.getLogger($this$getLogger$iv.getClass());
        this.interval = FilterPollerKt.access$getDEFAULT_POLLER_INTERVAL$p();
        this.threadFactory = FilterPollerKt.access$getPOLLER_DAEMON_FACTORY$p();
        this.initialized = new AtomicBoolean(false);
        this.stream = new BlockingSubscriptionStream(() -> FilterPoller.stream$lambda$0(this));
    }

    @NotNull
    public final <R> FilterPoller<R> mapPoller(@NotNull Function<List<T>, List<R>> mapper) {
        return new FilterPoller<T>(this.id, this.provider, this.decoder.andThen(mapper));
    }

    @NotNull
    public final FilterPoller<T> withInterval(@NotNull Duration interval) {
        this.interval = interval;
        return this;
    }

    @NotNull
    public final FilterPoller<T> withThreadFactory(@NotNull ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    @Override
    public void unsubscribe() {
        this.stream.unsubscribe();
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        Iterator<T> iter = this.stream.iterator();
        return new Iterator<T>(this, iter){
            final /* synthetic */ Iterator<T> $iter;
            {
                this.$iter = $iter;
                FilterPoller.access$initializePoller($receiver);
            }

            public boolean hasNext() {
                return this.$iter.hasNext();
            }

            public T next() {
                return this.$iter.next();
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    private final void initializePoller() {
        if (this.initialized.compareAndSet(false, true)) {
            this.threadFactory.newThread(() -> FilterPoller.initializePoller$lambda$6(this)).start();
        }
    }

    private static final void stream$lambda$0(FilterPoller this$0) {
        this$0.unsubscribed = true;
    }

    private static final Boolean initializePoller$lambda$6$lambda$3(JsonParser it) {
        return it.currentToken() == JsonToken.VALUE_TRUE;
    }

    private static final void initializePoller$lambda$6(FilterPoller this$0) {
        Object[] result;
        int $i$f$err;
        Logger logger;
        long intervalMs = this$0.interval.toMillis();
        Object[] objectArray = new String[]{this$0.id};
        RpcCall getChangesCall = new RpcCall(this$0.provider.getClient(), "eth_getFilterChanges", objectArray, this$0.decoder);
        boolean filterExists = true;
        while (!this$0.unsubscribed) {
            Result response = getChangesCall.sendAwait();
            if (ResultKt.isFailure(response)) {
                Logger $this$err$iv = this$0.LOG;
                boolean $i$f$err2 = false;
                if ($this$err$iv.isErrorEnabled()) {
                    logger = $this$err$iv;
                    boolean bl = false;
                    logger.error("Error polling filter '" + this$0.id + "': " + ((Result.Failure)response).getError());
                }
                Result.Error $this$asTypeOrNull$iv = ((Result.Failure)response).getError();
                boolean $i$f$asTypeOrNull = false;
                RpcError error = (RpcError)$this$asTypeOrNull$iv.asTypeOrNull(RpcError.class);
                Object object = error;
                boolean bl = object != null && (object = ((RpcError)object).getMessage()) != null ? StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"filter not found", (boolean)false, (int)2, null) : false;
                if (bl) {
                    Logger $this$err$iv2 = this$0.LOG;
                    $i$f$err = 0;
                    if ($this$err$iv2.isErrorEnabled()) {
                        logger = $this$err$iv2;
                        boolean bl2 = false;
                        logger.error("Filter '" + this$0.id + "' expired, stopping polling thread and unsubscribing");
                    }
                    this$0.stream.unsubscribe();
                    filterExists = false;
                    break;
                }
            } else {
                result = (Object[])response.unwrap();
                $i$f$err = result.size();
                for (int i = 0; i < $i$f$err; ++i) {
                    this$0.stream.pushEvent(result.get(i));
                }
            }
            Thread.sleep(intervalMs);
        }
        if (filterExists) {
            result = new String[]{this$0.id};
            RpcCall<Boolean> uninstallCall = new RpcCall<Boolean>(this$0.provider.getClient(), "eth_uninstallFilter", result, FilterPoller::initializePoller$lambda$6$lambda$3);
            Result<Boolean, RpcError> response = uninstallCall.sendAwait();
            if (ResultKt.isFailure(response)) {
                Logger $this$err$iv = this$0.LOG;
                $i$f$err = 0;
                if ($this$err$iv.isErrorEnabled()) {
                    logger = $this$err$iv;
                    boolean bl = false;
                    logger.error("Error uninstalling filter '" + this$0.id + "': " + ((Result.Failure)response).getError());
                }
            } else {
                Logger $this$inf$iv = this$0.LOG;
                boolean $i$f$inf = false;
                if ($this$inf$iv.isInfoEnabled()) {
                    logger = $this$inf$iv;
                    boolean bl = false;
                    logger.info("Uninstalled filter '" + this$0.id + "'");
                }
            }
        }
    }

    public static final /* synthetic */ void access$initializePoller(FilterPoller $this) {
        $this.initializePoller();
    }
}

