/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.providers.types;

import io.ethers.core.Result;
import io.ethers.providers.JsonRpcClient;
import io.ethers.providers.RpcError;
import io.ethers.providers.types.BatchRpcRequestKt;
import io.ethers.providers.types.RpcCall;
import io.ethers.providers.types.RpcRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001d\u001eB\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u00020\f0\u000b0\n\"\u0004\b\u0000\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0007J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\nJ\u0006\u0010\u001c\u001a\u00020\u001bR&\u0010\u0005\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\t\u001a2\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\f0\u000b0\n0\u0006j\u0018\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\f0\u000b0\n`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00128@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R*\u0010\u0015\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\f0\u000b0\n0\u00128@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lio/ethers/providers/types/BatchRpcRequest;", "", "defaultSize", "", "(I)V", "_requests", "Ljava/util/ArrayList;", "Lio/ethers/providers/types/RpcCall;", "Lkotlin/collections/ArrayList;", "_responses", "Ljava/util/concurrent/CompletableFuture;", "Lio/ethers/core/Result;", "Lio/ethers/providers/RpcError;", "batchSent", "Ljava/util/concurrent/atomic/AtomicBoolean;", "client", "Lio/ethers/providers/JsonRpcClient;", "requests", "", "getRequests$ethers_providers", "()Ljava/util/List;", "responses", "getResponses$ethers_providers", "addRpcCall", "T", "request", "sendAsync", "", "sendAwait", "BatchCompletableFuture", "Companion", "ethers-providers"})
public final class BatchRpcRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicBoolean batchSent;
    @NotNull
    private final ArrayList<RpcCall<?>> _requests;
    @NotNull
    private final ArrayList<CompletableFuture<Result<?, RpcError>>> _responses;
    @Nullable
    private JsonRpcClient client;

    @JvmOverloads
    public BatchRpcRequest(int defaultSize) {
        this.batchSent = new AtomicBoolean(false);
        this._requests = new ArrayList(defaultSize);
        this._responses = new ArrayList(defaultSize);
    }

    public /* synthetic */ BatchRpcRequest(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        this(n);
    }

    @NotNull
    public final List<RpcCall<?>> getRequests$ethers_providers() {
        return this._requests;
    }

    @NotNull
    public final List<CompletableFuture<Result<?, RpcError>>> getResponses$ethers_providers() {
        return this._responses;
    }

    @NotNull
    public final <T> CompletableFuture<Result<T, RpcError>> addRpcCall(@NotNull RpcCall<T> request2) {
        if (this.client == null) {
            this.client = request2.getClient();
        } else if (this.client != request2.getClient()) {
            throw new IllegalArgumentException("All requests must use the same client");
        }
        BatchCompletableFuture future = new BatchCompletableFuture(this);
        this._requests.add(request2);
        this._responses.add(future);
        return future;
    }

    public final boolean sendAwait() {
        return this.sendAsync().join();
    }

    @NotNull
    public final CompletableFuture<Boolean> sendAsync() {
        if (this.client == null) {
            throw new IllegalStateException("No requests added");
        }
        if (!this.batchSent.compareAndSet(false, true)) {
            throw new IllegalStateException("Batch already sent");
        }
        JsonRpcClient jsonRpcClient = this.client;
        Intrinsics.checkNotNull((Object)jsonRpcClient);
        return jsonRpcClient.requestBatch(this);
    }

    @JvmOverloads
    public BatchRpcRequest() {
        this(0, 1, null);
    }

    @JvmStatic
    @JvmName(name="sendAwait")
    @NotNull
    public static final <T, E extends Result.Error> List<Result<T, E>> sendAwait(@NotNull Iterable<? extends RpcRequest<? extends T, E>> requests) {
        return Companion.sendAwait(requests);
    }

    @JvmStatic
    @JvmName(name="sendAsync")
    @NotNull
    public static final <T, E extends Result.Error> List<CompletableFuture<Result<T, E>>> sendAsync(@NotNull Iterable<? extends RpcRequest<T, E>> requests) {
        return Companion.sendAsync(requests);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\r\u0010\u0006\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0006\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000fJ\r\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/ethers/providers/types/BatchRpcRequest$BatchCompletableFuture;", "T", "Ljava/util/concurrent/CompletableFuture;", "batch", "Lio/ethers/providers/types/BatchRpcRequest;", "(Lio/ethers/providers/types/BatchRpcRequest;)V", "get", "()Ljava/lang/Object;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "getNow", "valueIfAbsent", "(Ljava/lang/Object;)Ljava/lang/Object;", "join", "verifyBatchSent", "", "ethers-providers"})
    private static final class BatchCompletableFuture<T>
    extends CompletableFuture<T> {
        @NotNull
        private final BatchRpcRequest batch;

        public BatchCompletableFuture(@NotNull BatchRpcRequest batch) {
            this.batch = batch;
        }

        @Override
        public T get() {
            this.verifyBatchSent();
            return super.get();
        }

        @Override
        public T get(long timeout, @NotNull TimeUnit unit) {
            this.verifyBatchSent();
            return super.get(timeout, unit);
        }

        @Override
        public T getNow(T valueIfAbsent) {
            this.verifyBatchSent();
            return super.getNow(valueIfAbsent);
        }

        @Override
        public T join() {
            this.verifyBatchSent();
            return super.join();
        }

        private final void verifyBatchSent() {
            if (!this.batch.batchSent.get()) {
                throw new IllegalStateException("Batch has not been sent yet. Awaiting would block indefinitely.");
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JC\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0004\"\u0004\b\u0000\u0010\u0005\"\b\b\u0001\u0010\u0006*\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\n0\tH\u0007\u00a2\u0006\u0002\u0010\u000bJE\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\r\"\u0004\b\u0000\u0010\u0005\"\b\b\u0001\u0010\u0006*\u00020\u00072\u001a\u0010\b\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\b\u0001\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\n0\tH\u0007\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lio/ethers/providers/types/BatchRpcRequest$Companion;", "", "()V", "sendAsync", "Lio/ethers/providers/types/BatchResponseAsync;", "T", "E", "Lio/ethers/core/Result$Error;", "requests", "", "Lio/ethers/providers/types/RpcRequest;", "(Ljava/lang/Iterable;)Ljava/util/List;", "sendAwait", "Lio/ethers/providers/types/BatchResponse;", "ethers-providers"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmName(name="sendAwait")
        @NotNull
        public final <T, E extends Result.Error> List<Result<T, E>> sendAwait(@NotNull Iterable<? extends RpcRequest<? extends T, E>> requests) {
            return BatchRpcRequestKt.sendAwait(requests);
        }

        @JvmStatic
        @JvmName(name="sendAsync")
        @NotNull
        public final <T, E extends Result.Error> List<CompletableFuture<Result<T, E>>> sendAsync(@NotNull Iterable<? extends RpcRequest<T, E>> requests) {
            return BatchRpcRequestKt.sendAsync(requests);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

