/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.providers.middleware;

import io.ethers.core.types.AccountOverride;
import io.ethers.core.types.Address;
import io.ethers.core.types.BlockId;
import io.ethers.core.types.BlockOverride;
import io.ethers.core.types.BlockWithHashes;
import io.ethers.core.types.BlockWithTransactions;
import io.ethers.core.types.Bytes;
import io.ethers.core.types.CallRequest;
import io.ethers.core.types.FeeHistory;
import io.ethers.core.types.Hash;
import io.ethers.core.types.Log;
import io.ethers.core.types.LogFilter;
import io.ethers.core.types.RPCTransaction;
import io.ethers.core.types.SyncStatus;
import io.ethers.core.types.TransactionReceipt;
import io.ethers.core.types.transaction.TransactionSigned;
import io.ethers.core.types.transaction.TransactionUnsigned;
import io.ethers.providers.RpcError;
import io.ethers.providers.types.FilterPoller;
import io.ethers.providers.types.PendingTransaction;
import io.ethers.providers.types.RpcRequest;
import io.ethers.providers.types.RpcSubscribe;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J$\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J,\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J8\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0016JH\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0016\b\u0002\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00102\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH&J\"\u0010\u0013\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH&J\"\u0010\u0013\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\"\u0010\u0013\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J$\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH&J$\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J$\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u001c\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0006\u001a\u00020\nH&J$\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH&J$\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J$\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u001c\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u000b\u001a\u00020\fH&J\u001c\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001c\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0014\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u0007H&J\u001c\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u000b\u001a\u00020\fH&J\u001c\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001c\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u001c\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u000b\u001a\u00020\fH&J\u001c\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001c\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u001c\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u000b\u001a\u00020\fH&J\u001c\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001c\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J$\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH&J$\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J$\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J$\u0010%\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0003H\u0016J4\u0010%\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00032\u000e\b\u0002\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00180*H&J\u0014\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\t0\u0007H&J\"\u0010,\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0*\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\"\u0010,\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0*\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010.\u001a\u00020\u0015H\u0016J\"\u0010,\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0*\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010/\u001a\u000200H&J\"\u0010,\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0*\u0012\u0004\u0012\u00020\t0\u00072\u0006\u00101\u001a\u00020\u0003H\u0016J\u0014\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\t0\u0007H&J$\u00103\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00104\u001a\u00020\u0003H&J$\u00103\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u0003H\u0016J$\u00103\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u0003H\u0016J,\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u00106\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fH&J,\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u00106\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J,\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u00106\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J$\u00107\u001a\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00104\u001a\u00020\u0003H&J$\u00107\u001a\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u0003H\u0016J$\u00107\u001a\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u0003H\u0016J\"\u00109\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002080:\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0014\u001a\u00020\u0015H&J$\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH&J$\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J$\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\"\u0010<\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020=0:\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0014\u001a\u00020\u0015H&J$\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00104\u001a\u00020\u0003H&J$\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u0003H\u0016J$\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u0003H\u0016J\u001c\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u000b\u001a\u00020\fH&J\u001c\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001c\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0014\u0010@\u001a\u000e\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020\t0\u0007H&J\u001c\u0010B\u001a\u000e\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010D\u001a\u00020EH\u0016J\u001c\u0010B\u001a\u000e\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010D\u001a\u00020FH&J\u001c\u0010G\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\t0H2\u0006\u0010/\u001a\u000200H&J\u0014\u0010I\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\t0HH&J\u0014\u0010J\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\t0HH&J\u0014\u0010K\u001a\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020\t0HH&J\"\u0010L\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0M\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010/\u001a\u000200H&J\u001a\u0010N\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150M\u0012\u0004\u0012\u00020\t0\u0007H&J\u001a\u0010O\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150M\u0012\u0004\u0012\u00020\t0\u0007H&J\u001a\u0010P\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002080M\u0012\u0004\u0012\u00020\t0\u0007H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006Q\u00c0\u0006\u0001"}, d2={"Lio/ethers/providers/middleware/EthApi;", "", "chainId", "", "getChainId", "()J", "call", "Lio/ethers/providers/types/RpcRequest;", "Lio/ethers/core/types/Bytes;", "Lio/ethers/providers/RpcError;", "Lio/ethers/core/types/CallRequest;", "blockId", "Lio/ethers/core/types/BlockId;", "blockOverride", "Lio/ethers/core/types/BlockOverride;", "stateOverride", "", "Lio/ethers/core/types/Address;", "Lio/ethers/core/types/AccountOverride;", "createAccessList", "hash", "Lio/ethers/core/types/Hash;", "number", "estimateGas", "Ljava/math/BigInteger;", "fillTransaction", "Lio/ethers/core/types/transaction/TransactionUnsigned;", "getBalance", "address", "getBlockHeader", "Lio/ethers/core/types/BlockWithHashes;", "getBlockNumber", "getBlockTransactionCount", "getBlockWithHashes", "getBlockWithTransactions", "Lio/ethers/core/types/BlockWithTransactions;", "getCode", "getFeeHistory", "Lio/ethers/core/types/FeeHistory;", "blockCount", "lastBlockNumber", "rewardPercentiles", "", "getGasPrice", "getLogs", "Lio/ethers/core/types/Log;", "blockHash", "filter", "Lio/ethers/core/types/LogFilter;", "blockNumber", "getMaxPriorityFeePerGas", "getRawTransactionByBlockAndIndex", "index", "getStorage", "key", "getTransactionByBlockAndIndex", "Lio/ethers/core/types/RPCTransaction;", "getTransactionByHash", "Ljava/util/Optional;", "getTransactionCount", "getTransactionReceipt", "Lio/ethers/core/types/TransactionReceipt;", "getUncleBlockHeader", "getUncleBlocksCount", "isNodeSyncing", "Lio/ethers/core/types/SyncStatus;", "sendRawTransaction", "Lio/ethers/providers/types/PendingTransaction;", "signedTransaction", "Lio/ethers/core/types/transaction/TransactionSigned;", "", "subscribeLogs", "Lio/ethers/providers/types/RpcSubscribe;", "subscribeNewHeads", "subscribeNewPendingTransactionHashes", "subscribeNewPendingTransactions", "watchLogs", "Lio/ethers/providers/types/FilterPoller;", "watchNewBlocks", "watchNewPendingTransactionHashes", "watchNewPendingTransactions", "ethers-providers"})
public interface EthApi {
    public long getChainId();

    @NotNull
    public RpcRequest<Long, RpcError> getBlockNumber();

    @NotNull
    default public RpcRequest<BigInteger, RpcError> getBalance(@NotNull Address address, @NotNull Hash hash) {
        return this.getBalance(address, (BlockId)new BlockId.Hash(hash));
    }

    @NotNull
    default public RpcRequest<BigInteger, RpcError> getBalance(@NotNull Address address, long number) {
        return this.getBalance(address, (BlockId)new BlockId.Number(number));
    }

    @NotNull
    public RpcRequest<BigInteger, RpcError> getBalance(@NotNull Address var1, @NotNull BlockId var2);

    @NotNull
    default public RpcRequest<BlockWithHashes, RpcError> getBlockHeader(@NotNull Hash hash) {
        return this.getBlockHeader((BlockId)new BlockId.Hash(hash));
    }

    @NotNull
    default public RpcRequest<BlockWithHashes, RpcError> getBlockHeader(long number) {
        return this.getBlockHeader((BlockId)new BlockId.Number(number));
    }

    @NotNull
    public RpcRequest<BlockWithHashes, RpcError> getBlockHeader(@NotNull BlockId var1);

    @NotNull
    default public RpcRequest<BlockWithHashes, RpcError> getBlockWithHashes(@NotNull Hash hash) {
        return this.getBlockWithHashes((BlockId)new BlockId.Hash(hash));
    }

    @NotNull
    default public RpcRequest<BlockWithHashes, RpcError> getBlockWithHashes(long number) {
        return this.getBlockWithHashes((BlockId)new BlockId.Number(number));
    }

    @NotNull
    public RpcRequest<BlockWithHashes, RpcError> getBlockWithHashes(@NotNull BlockId var1);

    @NotNull
    default public RpcRequest<BlockWithTransactions, RpcError> getBlockWithTransactions(@NotNull Hash hash) {
        return this.getBlockWithTransactions((BlockId)new BlockId.Hash(hash));
    }

    @NotNull
    default public RpcRequest<BlockWithTransactions, RpcError> getBlockWithTransactions(long number) {
        return this.getBlockWithTransactions((BlockId)new BlockId.Number(number));
    }

    @NotNull
    public RpcRequest<BlockWithTransactions, RpcError> getBlockWithTransactions(@NotNull BlockId var1);

    @NotNull
    default public RpcRequest<BlockWithHashes, RpcError> getUncleBlockHeader(@NotNull Hash hash, long index) {
        return this.getUncleBlockHeader((BlockId)new BlockId.Hash(hash), index);
    }

    @NotNull
    default public RpcRequest<BlockWithHashes, RpcError> getUncleBlockHeader(long number, long index) {
        return this.getUncleBlockHeader((BlockId)new BlockId.Number(number), index);
    }

    @NotNull
    public RpcRequest<BlockWithHashes, RpcError> getUncleBlockHeader(@NotNull BlockId var1, long var2);

    @NotNull
    default public RpcRequest<Long, RpcError> getUncleBlocksCount(@NotNull Hash hash) {
        return this.getUncleBlocksCount((BlockId)new BlockId.Hash(hash));
    }

    @NotNull
    default public RpcRequest<Long, RpcError> getUncleBlocksCount(long number) {
        return this.getUncleBlocksCount((BlockId)new BlockId.Number(number));
    }

    @NotNull
    public RpcRequest<Long, RpcError> getUncleBlocksCount(@NotNull BlockId var1);

    @NotNull
    default public RpcRequest<Bytes, RpcError> getCode(@NotNull Address address, @NotNull Hash hash) {
        return this.getCode(address, (BlockId)new BlockId.Hash(hash));
    }

    @NotNull
    default public RpcRequest<Bytes, RpcError> getCode(@NotNull Address address, long number) {
        return this.getCode(address, (BlockId)new BlockId.Number(number));
    }

    @NotNull
    public RpcRequest<Bytes, RpcError> getCode(@NotNull Address var1, @NotNull BlockId var2);

    @NotNull
    default public RpcRequest<Hash, RpcError> getStorage(@NotNull Address address, @NotNull Hash key, @NotNull Hash hash) {
        return this.getStorage(address, key, (BlockId)new BlockId.Hash(hash));
    }

    @NotNull
    default public RpcRequest<Hash, RpcError> getStorage(@NotNull Address address, @NotNull Hash key, long number) {
        return this.getStorage(address, key, (BlockId)new BlockId.Number(number));
    }

    @NotNull
    public RpcRequest<Hash, RpcError> getStorage(@NotNull Address var1, @NotNull Hash var2, @NotNull BlockId var3);

    @NotNull
    default public RpcRequest<Bytes, RpcError> call(@NotNull CallRequest call, @NotNull BlockId blockId) {
        return this.call(call, blockId, null, null);
    }

    @NotNull
    default public RpcRequest<Bytes, RpcError> call(@NotNull CallRequest call, @NotNull BlockId blockId, @NotNull Map<Address, AccountOverride> stateOverride) {
        return this.call(call, blockId, stateOverride, null);
    }

    @NotNull
    default public RpcRequest<Bytes, RpcError> call(@NotNull CallRequest call, @NotNull BlockId blockId, @NotNull BlockOverride blockOverride) {
        return this.call(call, blockId, null, blockOverride);
    }

    @NotNull
    public RpcRequest<Bytes, RpcError> call(@NotNull CallRequest var1, @NotNull BlockId var2, @Nullable Map<Address, AccountOverride> var3, @Nullable BlockOverride var4);

    public static /* synthetic */ RpcRequest call$default(EthApi ethApi, CallRequest callRequest, BlockId blockId, Map map, BlockOverride blockOverride, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: call");
        }
        if ((n & 4) != 0) {
            map = null;
        }
        if ((n & 8) != 0) {
            blockOverride = null;
        }
        return ethApi.call(callRequest, blockId, map, blockOverride);
    }

    @NotNull
    default public RpcRequest<BigInteger, RpcError> estimateGas(@NotNull CallRequest call, @NotNull Hash hash) {
        return this.estimateGas(call, (BlockId)new BlockId.Hash(hash));
    }

    @NotNull
    default public RpcRequest<BigInteger, RpcError> estimateGas(@NotNull CallRequest call, long number) {
        return this.estimateGas(call, (BlockId)new BlockId.Number(number));
    }

    @NotNull
    public RpcRequest<BigInteger, RpcError> estimateGas(@NotNull CallRequest var1, @NotNull BlockId var2);

    @NotNull
    default public RpcRequest<?, RpcError> createAccessList(@NotNull CallRequest call, @NotNull Hash hash) {
        return this.createAccessList(call, (BlockId)new BlockId.Hash(hash));
    }

    @NotNull
    default public RpcRequest<?, RpcError> createAccessList(@NotNull CallRequest call, long number) {
        return this.createAccessList(call, (BlockId)new BlockId.Number(number));
    }

    @NotNull
    public RpcRequest<?, RpcError> createAccessList(@NotNull CallRequest var1, @NotNull BlockId var2);

    @NotNull
    public RpcRequest<BigInteger, RpcError> getGasPrice();

    @NotNull
    public RpcRequest<BigInteger, RpcError> getMaxPriorityFeePerGas();

    @NotNull
    default public RpcRequest<FeeHistory, RpcError> getFeeHistory(long blockCount, long lastBlockNumber) {
        return this.getFeeHistory(blockCount, lastBlockNumber, CollectionsKt.emptyList());
    }

    @NotNull
    public RpcRequest<FeeHistory, RpcError> getFeeHistory(long var1, long var3, @NotNull List<? extends BigInteger> var5);

    public static /* synthetic */ RpcRequest getFeeHistory$default(EthApi ethApi, long l, long l2, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getFeeHistory");
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return ethApi.getFeeHistory(l, l2, list);
    }

    @NotNull
    public RpcRequest<SyncStatus, RpcError> isNodeSyncing();

    @NotNull
    default public RpcRequest<Long, RpcError> getBlockTransactionCount(long number) {
        return this.getBlockTransactionCount((BlockId)new BlockId.Number(number));
    }

    @NotNull
    default public RpcRequest<Long, RpcError> getBlockTransactionCount(@NotNull Hash hash) {
        return this.getBlockTransactionCount((BlockId)new BlockId.Hash(hash));
    }

    @NotNull
    public RpcRequest<Long, RpcError> getBlockTransactionCount(@NotNull BlockId var1);

    @NotNull
    default public RpcRequest<RPCTransaction, RpcError> getTransactionByBlockAndIndex(long number, long index) {
        return this.getTransactionByBlockAndIndex((BlockId)new BlockId.Number(number), index);
    }

    @NotNull
    default public RpcRequest<RPCTransaction, RpcError> getTransactionByBlockAndIndex(@NotNull Hash hash, long index) {
        return this.getTransactionByBlockAndIndex((BlockId)new BlockId.Hash(hash), index);
    }

    @NotNull
    public RpcRequest<RPCTransaction, RpcError> getTransactionByBlockAndIndex(@NotNull BlockId var1, long var2);

    @NotNull
    default public RpcRequest<Bytes, RpcError> getRawTransactionByBlockAndIndex(long number, long index) {
        return this.getRawTransactionByBlockAndIndex((BlockId)new BlockId.Number(number), index);
    }

    @NotNull
    default public RpcRequest<Bytes, RpcError> getRawTransactionByBlockAndIndex(@NotNull Hash hash, long index) {
        return this.getRawTransactionByBlockAndIndex((BlockId)new BlockId.Hash(hash), index);
    }

    @NotNull
    public RpcRequest<Bytes, RpcError> getRawTransactionByBlockAndIndex(@NotNull BlockId var1, long var2);

    @NotNull
    default public RpcRequest<Long, RpcError> getTransactionCount(@NotNull Address address, long number) {
        return this.getTransactionCount(address, (BlockId)new BlockId.Number(number));
    }

    @NotNull
    default public RpcRequest<Long, RpcError> getTransactionCount(@NotNull Address address, @NotNull Hash hash) {
        return this.getTransactionCount(address, (BlockId)new BlockId.Hash(hash));
    }

    @NotNull
    public RpcRequest<Long, RpcError> getTransactionCount(@NotNull Address var1, @NotNull BlockId var2);

    @NotNull
    public RpcRequest<Optional<RPCTransaction>, RpcError> getTransactionByHash(@NotNull Hash var1);

    @NotNull
    public RpcRequest<Optional<TransactionReceipt>, RpcError> getTransactionReceipt(@NotNull Hash var1);

    @NotNull
    default public RpcRequest<PendingTransaction, RpcError> sendRawTransaction(@NotNull TransactionSigned signedTransaction) {
        return this.sendRawTransaction(signedTransaction.toRlp());
    }

    @NotNull
    public RpcRequest<PendingTransaction, RpcError> sendRawTransaction(@NotNull byte[] var1);

    @NotNull
    public RpcRequest<TransactionUnsigned, RpcError> fillTransaction(@NotNull CallRequest var1);

    @NotNull
    default public RpcRequest<List<Log>, RpcError> getLogs(@NotNull Hash blockHash) {
        return this.getLogs((BlockId)new BlockId.Hash(blockHash));
    }

    @NotNull
    default public RpcRequest<List<Log>, RpcError> getLogs(long blockNumber) {
        return this.getLogs((BlockId)new BlockId.Number(blockNumber));
    }

    @NotNull
    default public RpcRequest<List<Log>, RpcError> getLogs(@NotNull BlockId blockId) {
        LogFilter logFilter;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof BlockId.Hash) {
            logFilter = new LogFilter().atBlock((BlockId.Hash)blockId);
        } else if (blockId2 instanceof BlockId.Name) {
            logFilter = new LogFilter().blockRange((BlockId.Name)blockId, (BlockId.Name)blockId);
        } else if (blockId2 instanceof BlockId.Number) {
            logFilter = new LogFilter().blockRange((BlockId.Number)blockId, (BlockId.Number)blockId);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        LogFilter filter = logFilter;
        return this.getLogs(filter);
    }

    @NotNull
    public RpcRequest<List<Log>, RpcError> getLogs(@NotNull LogFilter var1);

    @NotNull
    public RpcRequest<FilterPoller<Log>, RpcError> watchLogs(@NotNull LogFilter var1);

    @NotNull
    public RpcRequest<FilterPoller<Hash>, RpcError> watchNewBlocks();

    @NotNull
    public RpcRequest<FilterPoller<Hash>, RpcError> watchNewPendingTransactionHashes();

    @NotNull
    public RpcRequest<FilterPoller<RPCTransaction>, RpcError> watchNewPendingTransactions();

    @NotNull
    public RpcSubscribe<Log, RpcError> subscribeLogs(@NotNull LogFilter var1);

    @NotNull
    public RpcSubscribe<BlockWithHashes, RpcError> subscribeNewHeads();

    @NotNull
    public RpcSubscribe<RPCTransaction, RpcError> subscribeNewPendingTransactions();

    @NotNull
    public RpcSubscribe<Hash, RpcError> subscribeNewPendingTransactionHashes();
}

