/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.providers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.ethers.core.FastHex;
import io.ethers.core.JsonParserExtensionsKt;
import io.ethers.core.types.AccountOverride;
import io.ethers.core.types.Address;
import io.ethers.core.types.Block;
import io.ethers.core.types.BlockId;
import io.ethers.core.types.BlockOverride;
import io.ethers.core.types.BlockWithHashes;
import io.ethers.core.types.BlockWithTransactions;
import io.ethers.core.types.Bytes;
import io.ethers.core.types.CallRequest;
import io.ethers.core.types.CreateAccessList;
import io.ethers.core.types.FeeHistory;
import io.ethers.core.types.Hash;
import io.ethers.core.types.Log;
import io.ethers.core.types.LogFilter;
import io.ethers.core.types.RPCTransaction;
import io.ethers.core.types.SyncStatus;
import io.ethers.core.types.TransactionReceipt;
import io.ethers.core.types.TxpoolContent;
import io.ethers.core.types.TxpoolContentFromAddress;
import io.ethers.core.types.TxpoolInspectResult;
import io.ethers.core.types.TxpoolStatus;
import io.ethers.core.types.tracers.TracerConfig;
import io.ethers.core.types.tracers.TxTraceResult;
import io.ethers.core.types.transaction.TransactionUnsigned;
import io.ethers.providers.JsonPubSubClient;
import io.ethers.providers.JsonRpcClient;
import io.ethers.providers.RpcError;
import io.ethers.providers.middleware.Middleware;
import io.ethers.providers.types.FilterPoller;
import io.ethers.providers.types.PendingTransaction;
import io.ethers.providers.types.RpcCall;
import io.ethers.providers.types.RpcRequest;
import io.ethers.providers.types.RpcSubscribe;
import io.ethers.providers.types.RpcSubscribeCall;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JD\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0011\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J$\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0011\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J$\u0010 \u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0011\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001c\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0011\u001a\u00020\u0015H\u0016J$\u0010$\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016JH\u0010&\u001a\u000e\u0012\u0004\u0012\u0002H'\u0012\u0004\u0012\u00020\u00140\u0012\"\u0004\b\u0000\u0010(\"\u000e\b\u0001\u0010'*\b\u0012\u0004\u0012\u0002H(0)2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H'0-H\u0004J\u001c\u0010.\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0014\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00140\u0012H\u0016J\u001c\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001c\u00102\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001c\u00103\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J$\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J2\u00106\u001a\u000e\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u00108\u001a\u00020\u00062\u0006\u00109\u001a\u00020\u00062\f\u0010:\u001a\b\u0012\u0004\u0012\u00020!0;H\u0016J\u0014\u0010<\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00140\u0012H\u0016J\"\u0010=\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020>0;\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010?\u001a\u00020@H\u0016J\u0014\u0010A\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00140\u0012H\u0016J\u0014\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00140\u0012H\u0016J\u001c\u0010C\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001c\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\"\u0010E\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130;\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\"\u0010F\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130G\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010H\u001a\u00020IH\u0016J$\u0010J\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010K\u001a\u00020\u0006H\u0016J,\u0010L\u001a\u000e\u0012\u0004\u0012\u00020I\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010M\u001a\u00020I2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J$\u0010N\u001a\u000e\u0012\u0004\u0012\u00020O\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010K\u001a\u00020\u0006H\u0016J\"\u0010P\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020O0G\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010H\u001a\u00020IH\u0016J$\u0010Q\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\"\u0010R\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020S0G\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010H\u001a\u00020IH\u0016J$\u0010T\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010K\u001a\u00020\u0006H\u0016J\u001c\u0010U\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0014\u0010V\u001a\u000e\u0012\u0004\u0012\u00020W\u0012\u0004\u0012\u00020\u00140\u0012H\u0016J\u0014\u0010X\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u00140\u0012H\u0016J\u0014\u0010Y\u001a\u000e\u0012\u0004\u0012\u00020Z\u0012\u0004\u0012\u00020\u00140\u0012H\u0016J\u001c\u0010[\u001a\u000e\u0012\u0004\u0012\u00020W\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\\\u001a\u00020\u0006H\u0016J\u001c\u0010]\u001a\u000e\u0012\u0004\u0012\u00020^\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010_\u001a\u00020`H\u0016J?\u0010a\u001a\u000e\u0012\u0004\u0012\u0002H(\u0012\u0004\u0012\u00020\u00140b\"\u0004\b\u0000\u0010(2\n\u0010c\u001a\u0006\u0012\u0002\b\u00030d2\u0012\u0010e\u001a\u000e\u0012\u0004\u0012\u00020g\u0012\u0004\u0012\u0002H(0fH\u0002\u00a2\u0006\u0002\u0010hJ\u001c\u0010i\u001a\u000e\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020\u00140b2\u0006\u0010?\u001a\u00020@H\u0016J\u0014\u0010j\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u00140bH\u0016J\u0014\u0010k\u001a\u000e\u0012\u0004\u0012\u00020I\u0012\u0004\u0012\u00020\u00140bH\u0016J\u0014\u0010l\u001a\u000e\u0012\u0004\u0012\u00020O\u0012\u0004\u0012\u00020\u00140bH\u0016J<\u0010m\u001a\u001a\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H(0n0;\u0012\u0004\u0012\u00020\u00140\u0012\"\u0004\b\u0000\u0010(2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010o\u001a\b\u0012\u0004\u0012\u0002H(0pH\u0016J8\u0010q\u001a\u000e\u0012\u0004\u0012\u0002H(\u0012\u0004\u0012\u00020\u00140\u0012\"\u0004\b\u0000\u0010(2\u0006\u0010\u0011\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010o\u001a\b\u0012\u0004\u0012\u0002H(0pH\u0016J0\u0010r\u001a\u000e\u0012\u0004\u0012\u0002H(\u0012\u0004\u0012\u00020\u00140\u0012\"\u0004\b\u0000\u0010(2\u0006\u0010s\u001a\u00020I2\f\u0010o\u001a\b\u0012\u0004\u0012\u0002H(0pH\u0016J\u0014\u0010t\u001a\u000e\u0012\u0004\u0012\u00020u\u0012\u0004\u0012\u00020\u00140\u0012H\u0016J\u001c\u0010v\u001a\u000e\u0012\u0004\u0012\u00020w\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010%\u001a\u00020\u001aH\u0016J\u0014\u0010x\u001a\u000e\u0012\u0004\u0012\u00020y\u0012\u0004\u0012\u00020\u00140\u0012H\u0016J\u0014\u0010z\u001a\u000e\u0012\u0004\u0012\u00020{\u0012\u0004\u0012\u00020\u00140\u0012H\u0016J\"\u0010|\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020>0}\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010?\u001a\u00020@H\u0016J\u001a\u0010~\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020I0}\u0012\u0004\u0012\u00020\u00140\u0012H\u0016J\u001a\u0010\u007f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020I0}\u0012\u0004\u0012\u00020\u00140\u0012H\u0016J\u001b\u0010\u0080\u0001\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020O0}\u0012\u0004\u0012\u00020\u00140\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0081\u0001"}, d2={"Lio/ethers/providers/Provider;", "Lio/ethers/providers/middleware/Middleware;", "client", "Lio/ethers/providers/JsonRpcClient;", "(Lio/ethers/providers/JsonRpcClient;)V", "chainId", "", "getChainId", "()J", "getClient", "()Lio/ethers/providers/JsonRpcClient;", "inner", "getInner", "()Lio/ethers/providers/middleware/Middleware;", "provider", "getProvider", "()Lio/ethers/providers/Provider;", "call", "Lio/ethers/providers/types/RpcRequest;", "Lio/ethers/core/types/Bytes;", "Lio/ethers/providers/RpcError;", "Lio/ethers/core/types/CallRequest;", "blockId", "Lio/ethers/core/types/BlockId;", "stateOverride", "", "Lio/ethers/core/types/Address;", "Lio/ethers/core/types/AccountOverride;", "blockOverride", "Lio/ethers/core/types/BlockOverride;", "createAccessList", "Lio/ethers/core/types/CreateAccessList;", "estimateGas", "Ljava/math/BigInteger;", "fillTransaction", "Lio/ethers/core/types/transaction/TransactionUnsigned;", "getBalance", "address", "getBlock", "B", "T", "Lio/ethers/core/types/Block;", "fullTransactions", "", "responseType", "Ljava/lang/Class;", "getBlockHeader", "Lio/ethers/core/types/BlockWithHashes;", "getBlockNumber", "getBlockTransactionCount", "getBlockWithHashes", "getBlockWithTransactions", "Lio/ethers/core/types/BlockWithTransactions;", "getCode", "getFeeHistory", "Lio/ethers/core/types/FeeHistory;", "blockCount", "lastBlockNumber", "rewardPercentiles", "", "getGasPrice", "getLogs", "Lio/ethers/core/types/Log;", "filter", "Lio/ethers/core/types/LogFilter;", "getMaxPriorityFeePerGas", "getPeerCount", "getRawBlockHeader", "getRawBlockWithTransactions", "getRawReceipts", "getRawTransaction", "Ljava/util/Optional;", "hash", "Lio/ethers/core/types/Hash;", "getRawTransactionByBlockAndIndex", "index", "getStorage", "key", "getTransactionByBlockAndIndex", "Lio/ethers/core/types/RPCTransaction;", "getTransactionByHash", "getTransactionCount", "getTransactionReceipt", "Lio/ethers/core/types/TransactionReceipt;", "getUncleBlockHeader", "getUncleBlocksCount", "getVersion", "", "isListening", "isNodeSyncing", "Lio/ethers/core/types/SyncStatus;", "printBlock", "number", "sendRawTransaction", "Lio/ethers/providers/types/PendingTransaction;", "signedTransaction", "", "subscribe", "Lio/ethers/providers/types/RpcSubscribe;", "params", "", "decoder", "Ljava/util/function/Function;", "Lcom/fasterxml/jackson/core/JsonParser;", "([Ljava/lang/Object;Ljava/util/function/Function;)Lio/ethers/providers/types/RpcSubscribe;", "subscribeLogs", "subscribeNewHeads", "subscribeNewPendingTransactionHashes", "subscribeNewPendingTransactions", "traceBlock", "Lio/ethers/core/types/tracers/TxTraceResult;", "config", "Lio/ethers/core/types/tracers/TracerConfig;", "traceCall", "traceTransaction", "txHash", "txpoolContent", "Lio/ethers/core/types/TxpoolContent;", "txpoolContentFrom", "Lio/ethers/core/types/TxpoolContentFromAddress;", "txpoolInspect", "Lio/ethers/core/types/TxpoolInspectResult;", "txpoolStatus", "Lio/ethers/core/types/TxpoolStatus;", "watchLogs", "Lio/ethers/providers/types/FilterPoller;", "watchNewBlocks", "watchNewPendingTransactionHashes", "watchNewPendingTransactions", "ethers-providers"})
@SourceDebugExtension(value={"SMAP\nProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Provider.kt\nio/ethers/providers/Provider\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 JsonParserExtensions.kt\nio/ethers/core/JsonParserExtensionsKt\n*L\n1#1,439:1\n26#2:440\n26#2:441\n26#2:442\n26#2:443\n26#2:444\n26#2:445\n26#2:446\n26#2:447\n26#2:448\n26#2:449\n26#2:450\n26#2:451\n26#2:452\n194#3,11:453\n33#3,6:464\n205#3,3:470\n*S KotlinDebug\n*F\n+ 1 Provider.kt\nio/ethers/providers/Provider\n*L\n62#1:440\n67#1:441\n159#1:442\n163#1:443\n176#1:444\n278#1:445\n287#1:446\n408#1:447\n412#1:448\n416#1:449\n423#1:450\n432#1:451\n436#1:452\n387#1:453,11\n392#1:464,6\n387#1:470,3\n*E\n"})
public final class Provider
implements Middleware {
    @NotNull
    private final JsonRpcClient client;
    private final long chainId;

    public Provider(@NotNull JsonRpcClient client) {
        this.client = client;
        boolean $i$f$emptyArray = false;
        this.chainId = ((Number)new RpcCall<Long>(this.getClient(), "eth_chainId", new Object[0], Provider::chainId$lambda$0).sendAwait().unwrap()).longValue();
    }

    @Override
    @NotNull
    public JsonRpcClient getClient() {
        return this.client;
    }

    @Override
    @Nullable
    public Middleware getInner() {
        return null;
    }

    @Override
    @NotNull
    public Provider getProvider() {
        return this;
    }

    @Override
    public long getChainId() {
        return this.chainId;
    }

    @Override
    @NotNull
    public RpcRequest<Long, RpcError> getBlockNumber() {
        boolean $i$f$emptyArray = false;
        return new RpcCall<Long>(this.getClient(), "eth_blockNumber", new Object[0], Provider::getBlockNumber$lambda$1);
    }

    @Override
    @NotNull
    public RpcRequest<BigInteger, RpcError> getBalance(@NotNull Address address, @NotNull BlockId blockId) {
        Object[] objectArray = new Object[]{address, blockId.getId()};
        return new RpcCall<BigInteger>(this.getClient(), "eth_getBalance", objectArray, Provider::getBalance$lambda$2);
    }

    @Override
    @NotNull
    public RpcRequest<BlockWithHashes, RpcError> getBlockHeader(@NotNull BlockId blockId) {
        String string;
        Object[] objectArray = new String[]{blockId.getId()};
        Object[] params = objectArray;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof BlockId.Hash) {
            string = "eth_getHeaderByHash";
        } else if (blockId2 instanceof BlockId.Number ? true : blockId2 instanceof BlockId.Name) {
            string = "eth_getHeaderByNumber";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String method = string;
        return new RpcCall<BlockWithHashes>(this.getClient(), method, params, BlockWithHashes.class);
    }

    @Override
    @NotNull
    public RpcRequest<BlockWithHashes, RpcError> getBlockWithHashes(@NotNull BlockId blockId) {
        return this.getBlock(blockId, false, BlockWithHashes.class);
    }

    @Override
    @NotNull
    public RpcRequest<BlockWithTransactions, RpcError> getBlockWithTransactions(@NotNull BlockId blockId) {
        return this.getBlock(blockId, true, BlockWithTransactions.class);
    }

    @NotNull
    protected final <T, B extends Block<T>> RpcRequest<B, RpcError> getBlock(@NotNull BlockId blockId, boolean fullTransactions, @NotNull Class<B> responseType) {
        String string;
        Object[] objectArray = new Object[]{blockId.getId(), fullTransactions};
        Object[] params = objectArray;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof BlockId.Hash) {
            string = "eth_getBlockByHash";
        } else if (blockId2 instanceof BlockId.Number ? true : blockId2 instanceof BlockId.Name) {
            string = "eth_getBlockByNumber";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String method = string;
        return new RpcCall<B>(this.getClient(), method, params, responseType);
    }

    @Override
    @NotNull
    public RpcRequest<BlockWithHashes, RpcError> getUncleBlockHeader(@NotNull BlockId blockId, long index) {
        String string;
        Object[] objectArray = new String[]{blockId.getId(), FastHex.encodeWithPrefix((long)index)};
        Object[] params = objectArray;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof BlockId.Hash) {
            string = "eth_getUncleByBlockHashAndIndex";
        } else if (blockId2 instanceof BlockId.Number ? true : blockId2 instanceof BlockId.Name) {
            string = "eth_getUncleByBlockNumberAndIndex";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String method = string;
        return new RpcCall<BlockWithHashes>(this.getClient(), method, params, BlockWithHashes.class);
    }

    @Override
    @NotNull
    public RpcRequest<Long, RpcError> getUncleBlocksCount(@NotNull BlockId blockId) {
        String string;
        Object[] objectArray = new String[]{blockId.getId()};
        Object[] params = objectArray;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof BlockId.Hash) {
            string = "eth_getUncleCountByBlockHash";
        } else if (blockId2 instanceof BlockId.Number ? true : blockId2 instanceof BlockId.Name) {
            string = "eth_getUncleCountByBlockNumber";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String method = string;
        return new RpcCall<Long>(this.getClient(), method, params, Provider::getUncleBlocksCount$lambda$3);
    }

    @Override
    @NotNull
    public RpcRequest<Bytes, RpcError> getCode(@NotNull Address address, @NotNull BlockId blockId) {
        Object[] objectArray = new Object[]{address, blockId.getId()};
        Object[] params = objectArray;
        return new RpcCall<Bytes>(this.getClient(), "eth_getCode", params, Bytes.class);
    }

    @Override
    @NotNull
    public RpcRequest<Hash, RpcError> getStorage(@NotNull Address address, @NotNull Hash key, @NotNull BlockId blockId) {
        Object[] objectArray = new Object[]{address, key, blockId.getId()};
        Object[] params = objectArray;
        return new RpcCall<Hash>(this.getClient(), "eth_getStorageAt", params, Hash.class);
    }

    @Override
    @NotNull
    public RpcRequest<Bytes, RpcError> call(@NotNull CallRequest call, @NotNull BlockId blockId, @Nullable Map<Address, AccountOverride> stateOverride, @Nullable BlockOverride blockOverride) {
        Object[] objectArray;
        Object[] objectArray2;
        if (blockOverride != null) {
            objectArray2 = new Object[]{call, blockId.getId(), stateOverride, blockOverride};
            objectArray = objectArray2;
        } else if (stateOverride != null) {
            objectArray2 = new Object[]{call, blockId.getId(), stateOverride};
            objectArray = objectArray2;
        } else {
            objectArray2 = new Object[]{call, blockId.getId()};
            objectArray = objectArray2;
        }
        Object[] params = objectArray;
        return new RpcCall<Bytes>(this.getClient(), "eth_call", params, Bytes.class);
    }

    @Override
    @NotNull
    public RpcRequest<BigInteger, RpcError> estimateGas(@NotNull CallRequest call, @NotNull BlockId blockId) {
        Object[] objectArray = new Object[]{call, blockId.getId()};
        Object[] params = objectArray;
        return new RpcCall<BigInteger>(this.getClient(), "eth_estimateGas", params, Provider::estimateGas$lambda$4);
    }

    @NotNull
    public RpcRequest<CreateAccessList, RpcError> createAccessList(@NotNull CallRequest call, @NotNull BlockId blockId) {
        Object[] objectArray = new Object[]{call, blockId.getId()};
        Object[] params = objectArray;
        return new RpcCall<CreateAccessList>(this.getClient(), "eth_createAccessList", params, CreateAccessList.class);
    }

    @Override
    @NotNull
    public RpcRequest<BigInteger, RpcError> getGasPrice() {
        boolean $i$f$emptyArray = false;
        return new RpcCall<BigInteger>(this.getClient(), "eth_gasPrice", new Object[0], Provider::getGasPrice$lambda$5);
    }

    @Override
    @NotNull
    public RpcRequest<BigInteger, RpcError> getMaxPriorityFeePerGas() {
        boolean $i$f$emptyArray = false;
        return new RpcCall<BigInteger>(this.getClient(), "eth_maxPriorityFeePerGas", new Object[0], Provider::getMaxPriorityFeePerGas$lambda$6);
    }

    @Override
    @NotNull
    public RpcRequest<FeeHistory, RpcError> getFeeHistory(long blockCount, long lastBlockNumber, @NotNull List<? extends BigInteger> rewardPercentiles) {
        Object[] objectArray = new Object[]{blockCount, FastHex.encodeWithPrefix((long)lastBlockNumber), rewardPercentiles};
        Object[] params = objectArray;
        return new RpcCall<FeeHistory>(this.getClient(), "eth_feeHistory", params, FeeHistory.class);
    }

    @Override
    @NotNull
    public RpcRequest<SyncStatus, RpcError> isNodeSyncing() {
        boolean $i$f$emptyArray = false;
        return new RpcCall<SyncStatus>(this.getClient(), "eth_syncing", new Object[0], Provider::isNodeSyncing$lambda$7);
    }

    @Override
    @NotNull
    public RpcRequest<Long, RpcError> getBlockTransactionCount(@NotNull BlockId blockId) {
        String string;
        Object[] objectArray = new String[]{blockId.getId()};
        Object[] params = objectArray;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof BlockId.Hash) {
            string = "eth_getBlockTransactionCountByHash";
        } else if (blockId2 instanceof BlockId.Number ? true : blockId2 instanceof BlockId.Name) {
            string = "eth_getBlockTransactionCountByNumber";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String method = string;
        return new RpcCall<Long>(this.getClient(), method, params, Provider::getBlockTransactionCount$lambda$8);
    }

    @Override
    @NotNull
    public RpcRequest<RPCTransaction, RpcError> getTransactionByBlockAndIndex(@NotNull BlockId blockId, long index) {
        String string;
        Object[] objectArray = new String[]{blockId.getId(), FastHex.encodeWithPrefix((long)index)};
        Object[] params = objectArray;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof BlockId.Hash) {
            string = "eth_getTransactionByBlockHashAndIndex";
        } else if (blockId2 instanceof BlockId.Number ? true : blockId2 instanceof BlockId.Name) {
            string = "eth_getTransactionByBlockNumberAndIndex";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String method = string;
        return new RpcCall<RPCTransaction>(this.getClient(), method, params, RPCTransaction.class);
    }

    @Override
    @NotNull
    public RpcRequest<Bytes, RpcError> getRawTransactionByBlockAndIndex(@NotNull BlockId blockId, long index) {
        String string;
        Object[] objectArray = new String[]{blockId.getId(), FastHex.encodeWithPrefix((long)index)};
        Object[] params = objectArray;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof BlockId.Hash) {
            string = "eth_getRawTransactionByBlockHashAndIndex";
        } else if (blockId2 instanceof BlockId.Number ? true : blockId2 instanceof BlockId.Name) {
            string = "eth_getRawTransactionByBlockNumberAndIndex";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String method = string;
        return new RpcCall<Bytes>(this.getClient(), method, params, Bytes.class);
    }

    @Override
    @NotNull
    public RpcRequest<Long, RpcError> getTransactionCount(@NotNull Address address, @NotNull BlockId blockId) {
        Object[] objectArray = new Object[]{address, blockId.getId()};
        return new RpcCall<Long>(this.getClient(), "eth_getTransactionCount", objectArray, Provider::getTransactionCount$lambda$9);
    }

    @Override
    @NotNull
    public RpcRequest<Optional<RPCTransaction>, RpcError> getTransactionByHash(@NotNull Hash hash) {
        Object[] objectArray = new Hash[]{hash};
        return new RpcCall<Optional>(this.getClient(), "eth_getTransactionByHash", objectArray, Provider::getTransactionByHash$lambda$10);
    }

    @Override
    @NotNull
    public RpcRequest<Optional<TransactionReceipt>, RpcError> getTransactionReceipt(@NotNull Hash hash) {
        Object[] objectArray = new Hash[]{hash};
        return new RpcCall<Optional>(this.getClient(), "eth_getTransactionReceipt", objectArray, Provider::getTransactionReceipt$lambda$11);
    }

    @Override
    @NotNull
    public RpcRequest<PendingTransaction, RpcError> sendRawTransaction(@NotNull byte[] signedTransaction) {
        byte[][] byArrayArray = new byte[][]{signedTransaction};
        return new RpcCall<PendingTransaction>(this.getClient(), "eth_sendRawTransaction", (Object[])byArrayArray, arg_0 -> Provider.sendRawTransaction$lambda$12(this, arg_0));
    }

    @Override
    @NotNull
    public RpcRequest<TransactionUnsigned, RpcError> fillTransaction(@NotNull CallRequest call) {
        Object[] objectArray = new CallRequest[]{call};
        return new RpcCall<TransactionUnsigned>(this.getClient(), "eth_fillTransaction", objectArray, arg_0 -> Provider.fillTransaction$lambda$13(this, arg_0));
    }

    @Override
    @NotNull
    public RpcRequest<List<Log>, RpcError> getLogs(@NotNull LogFilter filter) {
        Object[] objectArray = new LogFilter[]{filter};
        return new RpcCall<List>(this.getClient(), "eth_getLogs", objectArray, Provider::getLogs$lambda$14);
    }

    @Override
    @NotNull
    public RpcRequest<FilterPoller<Log>, RpcError> watchLogs(@NotNull LogFilter filter) {
        Object[] objectArray = new LogFilter[]{filter};
        return new RpcCall<FilterPoller>(this.getClient(), "eth_newFilter", objectArray, arg_0 -> Provider.watchLogs$lambda$16(this, arg_0));
    }

    @Override
    @NotNull
    public RpcRequest<FilterPoller<Hash>, RpcError> watchNewBlocks() {
        boolean $i$f$emptyArray = false;
        return new RpcCall<FilterPoller>(this.getClient(), "eth_newBlockFilter", new Object[0], arg_0 -> Provider.watchNewBlocks$lambda$18(this, arg_0));
    }

    @Override
    @NotNull
    public RpcRequest<FilterPoller<Hash>, RpcError> watchNewPendingTransactionHashes() {
        boolean $i$f$emptyArray = false;
        return new RpcCall<FilterPoller>(this.getClient(), "eth_newPendingTransactionFilter", new Object[0], arg_0 -> Provider.watchNewPendingTransactionHashes$lambda$20(this, arg_0));
    }

    @Override
    @NotNull
    public RpcRequest<FilterPoller<RPCTransaction>, RpcError> watchNewPendingTransactions() {
        Object[] objectArray = new Boolean[]{true};
        return new RpcCall<FilterPoller>(this.getClient(), "eth_newPendingTransactionFilter", objectArray, arg_0 -> Provider.watchNewPendingTransactions$lambda$22(this, arg_0));
    }

    @Override
    @NotNull
    public RpcSubscribe<Hash, RpcError> subscribeNewPendingTransactionHashes() {
        Object[] objectArray = new String[]{"newPendingTransactions"};
        return this.subscribe(objectArray, Provider::subscribeNewPendingTransactionHashes$lambda$23);
    }

    @Override
    @NotNull
    public RpcSubscribe<RPCTransaction, RpcError> subscribeNewPendingTransactions() {
        Object[] objectArray = new Object[]{"newPendingTransactions", true};
        return this.subscribe(objectArray, Provider::subscribeNewPendingTransactions$lambda$24);
    }

    @Override
    @NotNull
    public RpcSubscribe<BlockWithHashes, RpcError> subscribeNewHeads() {
        Object[] objectArray = new String[]{"newHeads"};
        return this.subscribe(objectArray, Provider::subscribeNewHeads$lambda$25);
    }

    @Override
    @NotNull
    public RpcSubscribe<Log, RpcError> subscribeLogs(@NotNull LogFilter filter) {
        Object[] objectArray = new Object[]{"logs", filter};
        return this.subscribe(objectArray, Provider::subscribeLogs$lambda$26);
    }

    private final <T> RpcSubscribe<T, RpcError> subscribe(Object[] params, Function<JsonParser, T> decoder) {
        if (!this.isPubSub()) {
            throw new UnsupportedOperationException("Pub/sub is not supported by this provider");
        }
        JsonRpcClient jsonRpcClient = this.getClient();
        Intrinsics.checkNotNull((Object)jsonRpcClient, (String)"null cannot be cast to non-null type io.ethers.providers.JsonPubSubClient");
        return new RpcSubscribeCall<T>((JsonPubSubClient)jsonRpcClient, params, decoder);
    }

    @Override
    @NotNull
    public RpcRequest<Bytes, RpcError> getRawBlockHeader(@NotNull BlockId blockId) {
        Object[] objectArray = new String[]{blockId.getId()};
        Object[] params = objectArray;
        return new RpcCall<Bytes>(this.getClient(), "debug_getRawHeader", params, Bytes.class);
    }

    @Override
    @NotNull
    public RpcRequest<Bytes, RpcError> getRawBlockWithTransactions(@NotNull BlockId blockId) {
        Object[] objectArray = new String[]{blockId.getId()};
        Object[] params = objectArray;
        return new RpcCall<Bytes>(this.getClient(), "debug_getRawBlock", params, Bytes.class);
    }

    @Override
    @NotNull
    public RpcRequest<List<Bytes>, RpcError> getRawReceipts(@NotNull BlockId blockId) {
        Object[] objectArray = new String[]{blockId.getId()};
        Object[] params = objectArray;
        return new RpcCall<List>(this.getClient(), "debug_getRawReceipts", params, Provider::getRawReceipts$lambda$27);
    }

    @Override
    @NotNull
    public RpcRequest<Optional<Bytes>, RpcError> getRawTransaction(@NotNull Hash hash) {
        Object[] objectArray = new Hash[]{hash};
        return new RpcCall<Optional>(this.getClient(), "debug_getRawTransaction", objectArray, Provider::getRawTransaction$lambda$28);
    }

    @Override
    @NotNull
    public RpcRequest<String, RpcError> printBlock(long number) {
        Object[] objectArray = new Long[]{number};
        Object[] params = objectArray;
        return new RpcCall<String>(this.getClient(), "debug_printBlock", params, String.class);
    }

    @Override
    @NotNull
    public <T> RpcRequest<T, RpcError> traceCall(@NotNull CallRequest call, @NotNull BlockId blockId, @NotNull TracerConfig<T> config) {
        Object[] objectArray = new Object[]{call, blockId.getId(), config};
        Object[] params = objectArray;
        return new RpcCall<Object>(this.getClient(), "debug_traceCall", params, arg_0 -> Provider.traceCall$lambda$29(config, arg_0));
    }

    @Override
    @NotNull
    public <T> RpcRequest<T, RpcError> traceTransaction(@NotNull Hash txHash, @NotNull TracerConfig<T> config) {
        Object[] objectArray = new Object[]{txHash, config};
        Object[] params = objectArray;
        return new RpcCall<Object>(this.getClient(), "debug_traceTransaction", params, arg_0 -> Provider.traceTransaction$lambda$30(config, arg_0));
    }

    @Override
    @NotNull
    public <T> RpcRequest<List<TxTraceResult<T>>, RpcError> traceBlock(@NotNull BlockId blockId, @NotNull TracerConfig<T> config) {
        String string;
        Object[] objectArray = new Object[]{blockId.getId(), config};
        Object[] params = objectArray;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof BlockId.Hash) {
            string = "debug_traceBlockByHash";
        } else if (blockId2 instanceof BlockId.Number ? true : blockId2 instanceof BlockId.Name) {
            string = "debug_traceBlockByNumber";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String method = string;
        return new RpcCall<List>(this.getClient(), method, params, arg_0 -> Provider.traceBlock$lambda$33(config, arg_0));
    }

    @Override
    @NotNull
    public RpcRequest<Boolean, RpcError> isListening() {
        boolean $i$f$emptyArray = false;
        return new RpcCall<Boolean>(this.getClient(), "net_listening", new Object[0], Provider::isListening$lambda$34);
    }

    @Override
    @NotNull
    public RpcRequest<Long, RpcError> getPeerCount() {
        boolean $i$f$emptyArray = false;
        return new RpcCall<Long>(this.getClient(), "net_peerCount", new Object[0], Provider::getPeerCount$lambda$35);
    }

    @Override
    @NotNull
    public RpcRequest<String, RpcError> getVersion() {
        boolean $i$f$emptyArray = false;
        return new RpcCall<String>(this.getClient(), "net_version", new Object[0], String.class);
    }

    @Override
    @NotNull
    public RpcRequest<TxpoolContent, RpcError> txpoolContent() {
        boolean $i$f$emptyArray = false;
        return new RpcCall<TxpoolContent>(this.getClient(), "txpool_content", new Object[0], TxpoolContent.class);
    }

    @Override
    @NotNull
    public RpcRequest<TxpoolContentFromAddress, RpcError> txpoolContentFrom(@NotNull Address address) {
        Object[] objectArray = new Address[]{address};
        Object[] params = objectArray;
        return new RpcCall<TxpoolContentFromAddress>(this.getClient(), "txpool_contentFrom", params, TxpoolContentFromAddress.class);
    }

    @Override
    @NotNull
    public RpcRequest<TxpoolStatus, RpcError> txpoolStatus() {
        boolean $i$f$emptyArray = false;
        return new RpcCall<TxpoolStatus>(this.getClient(), "txpool_status", new Object[0], TxpoolStatus.class);
    }

    @Override
    @NotNull
    public RpcRequest<TxpoolInspectResult, RpcError> txpoolInspect() {
        boolean $i$f$emptyArray = false;
        return new RpcCall<TxpoolInspectResult>(this.getClient(), "txpool_inspect", new Object[0], TxpoolInspectResult.class);
    }

    private static final Long chainId$lambda$0(JsonParser it) {
        return JsonParserExtensionsKt.readHexLong((JsonParser)it);
    }

    private static final Long getBlockNumber$lambda$1(JsonParser it) {
        return JsonParserExtensionsKt.readHexLong((JsonParser)it);
    }

    private static final BigInteger getBalance$lambda$2(JsonParser it) {
        return JsonParserExtensionsKt.readHexBigInteger((JsonParser)it);
    }

    private static final Long getUncleBlocksCount$lambda$3(JsonParser it) {
        return JsonParserExtensionsKt.readHexLong((JsonParser)it);
    }

    private static final BigInteger estimateGas$lambda$4(JsonParser it) {
        return JsonParserExtensionsKt.readHexBigInteger((JsonParser)it);
    }

    private static final BigInteger getGasPrice$lambda$5(JsonParser it) {
        return JsonParserExtensionsKt.readHexBigInteger((JsonParser)it);
    }

    private static final BigInteger getMaxPriorityFeePerGas$lambda$6(JsonParser it) {
        return JsonParserExtensionsKt.readHexBigInteger((JsonParser)it);
    }

    private static final SyncStatus isNodeSyncing$lambda$7(JsonParser it) {
        return (SyncStatus)it.readValueAs(SyncStatus.class);
    }

    private static final Long getBlockTransactionCount$lambda$8(JsonParser it) {
        return JsonParserExtensionsKt.readHexLong((JsonParser)it);
    }

    private static final Long getTransactionCount$lambda$9(JsonParser it) {
        return JsonParserExtensionsKt.readHexLong((JsonParser)it);
    }

    private static final Optional getTransactionByHash$lambda$10(JsonParser it) {
        return JsonParserExtensionsKt.readOptionalValue((JsonParser)it, RPCTransaction.class);
    }

    private static final Optional getTransactionReceipt$lambda$11(JsonParser it) {
        return JsonParserExtensionsKt.readOptionalValue((JsonParser)it, TransactionReceipt.class);
    }

    private static final PendingTransaction sendRawTransaction$lambda$12(Provider this$0, JsonParser it) {
        return new PendingTransaction(JsonParserExtensionsKt.readHash((JsonParser)it), this$0);
    }

    private static final TransactionUnsigned fillTransaction$lambda$13(Provider this$0, JsonParser it) {
        TransactionUnsigned ret = null;
        while (!JsonParserExtensionsKt.isNextTokenObjectEnd((JsonParser)it)) {
            if (!JsonParserExtensionsKt.isField((JsonParser)it, (String)"raw")) continue;
            ret = TransactionUnsigned.Companion.rlpDecode(JsonParserExtensionsKt.readHexByteArray((JsonParser)it), this$0.getChainId());
        }
        TransactionUnsigned transactionUnsigned = ret;
        if (transactionUnsigned == null) {
            throw new IllegalStateException("Invalid response, should not happen");
        }
        return transactionUnsigned;
    }

    private static final List getLogs$lambda$14(JsonParser it) {
        return JsonParserExtensionsKt.readListOf((JsonParser)it, Log.class);
    }

    private static final List watchLogs$lambda$16$lambda$15(JsonParser it) {
        return JsonParserExtensionsKt.readListOf((JsonParser)it, Log.class);
    }

    private static final FilterPoller watchLogs$lambda$16(Provider this$0, JsonParser p) {
        return new FilterPoller(p.getText(), this$0, Provider::watchLogs$lambda$16$lambda$15);
    }

    private static final List watchNewBlocks$lambda$18$lambda$17(JsonParser it) {
        return JsonParserExtensionsKt.readListOfHashes((JsonParser)it);
    }

    private static final FilterPoller watchNewBlocks$lambda$18(Provider this$0, JsonParser p) {
        return new FilterPoller(p.getText(), this$0, Provider::watchNewBlocks$lambda$18$lambda$17);
    }

    private static final List watchNewPendingTransactionHashes$lambda$20$lambda$19(JsonParser it) {
        return JsonParserExtensionsKt.readListOfHashes((JsonParser)it);
    }

    private static final FilterPoller watchNewPendingTransactionHashes$lambda$20(Provider this$0, JsonParser p) {
        return new FilterPoller(p.getText(), this$0, Provider::watchNewPendingTransactionHashes$lambda$20$lambda$19);
    }

    private static final List watchNewPendingTransactions$lambda$22$lambda$21(JsonParser it) {
        return JsonParserExtensionsKt.readListOf((JsonParser)it, RPCTransaction.class);
    }

    private static final FilterPoller watchNewPendingTransactions$lambda$22(Provider this$0, JsonParser p) {
        return new FilterPoller(p.getText(), this$0, Provider::watchNewPendingTransactions$lambda$22$lambda$21);
    }

    private static final Hash subscribeNewPendingTransactionHashes$lambda$23(JsonParser it) {
        return JsonParserExtensionsKt.readHash((JsonParser)it);
    }

    private static final RPCTransaction subscribeNewPendingTransactions$lambda$24(JsonParser it) {
        return (RPCTransaction)it.readValueAs(RPCTransaction.class);
    }

    private static final BlockWithHashes subscribeNewHeads$lambda$25(JsonParser it) {
        return (BlockWithHashes)it.readValueAs(BlockWithHashes.class);
    }

    private static final Log subscribeLogs$lambda$26(JsonParser it) {
        return (Log)it.readValueAs(Log.class);
    }

    private static final List getRawReceipts$lambda$27(JsonParser it) {
        return JsonParserExtensionsKt.readListOf((JsonParser)it, Bytes.class);
    }

    private static final Optional getRawTransaction$lambda$28(JsonParser it) {
        if (it.currentToken() == null) {
            return Optional.empty();
        }
        Bytes bytes = JsonParserExtensionsKt.readBytesEmptyAsNull((JsonParser)it);
        if (bytes == null) {
            return Optional.empty();
        }
        Bytes rlp = bytes;
        return Optional.of(rlp);
    }

    private static final Object traceCall$lambda$29(TracerConfig $config, JsonParser it) {
        return $config.getTracer().decodeResult(it);
    }

    private static final Object traceTransaction$lambda$30(TracerConfig $config, JsonParser it) {
        return $config.getTracer().decodeResult(it);
    }

    /*
     * Unable to fully structure code
     */
    private static final List traceBlock$lambda$33(TracerConfig $config, JsonParser it) {
        block9: {
            block10: {
                block8: {
                    $this$readListOf$iv = it;
                    $i$f$readListOf = false;
                    if ($this$readListOf$iv.getCurrentToken() != JsonToken.VALUE_NULL) break block8;
                    v0 = CollectionsKt.emptyList();
                    break block9;
                }
                if ($this$readListOf$iv.nextToken() != JsonToken.END_ARRAY) break block10;
                v0 = CollectionsKt.emptyList();
                break block9;
            }
            ret$iv = new ArrayList<TxTraceResult>();
            do {
                var5_5 = $this$readListOf$iv;
                var16_16 = ret$iv;
                $i$a$-readListOf-Provider$traceBlock$1$1 = false;
                txHash = null;
                result = null;
                error = null;
                $this$forEachObjectField$iv = it;
                $i$f$forEachObjectField = false;
                while (!JsonParserExtensionsKt.isNextTokenObjectEnd((JsonParser)$this$forEachObjectField$iv)) {
                    block11: {
                        field$iv = $this$forEachObjectField$iv.getCurrentName();
                        $this$forEachObjectField$iv.nextToken();
                        field = field$iv;
                        $i$a$-forEachObjectField-Provider$traceBlock$1$1$1 = false;
                        var15_15 = field;
                        switch (var15_15.hashCode()) {
                            case -934426595: {
                                if (var15_15.equals("result")) break;
                                ** break;
                            }
                            case 96784904: {
                                if (!var15_15.equals("error")) {
                                    ** break;
                                }
                                break block11;
                            }
                            case -860921422: {
                                if (!var15_15.equals("txHash")) ** break;
                                txHash = JsonParserExtensionsKt.readHash((JsonParser)it);
                                ** break;
                            }
                        }
                        result = $config.getTracer().decodeResult(it);
                        ** break;
                    }
                    error = it.getValueAsString();
lbl44:
                    // 7 sources

                }
                var16_16.add(new TxTraceResult(txHash, result, error));
            } while ($this$readListOf$iv.nextToken() != JsonToken.END_ARRAY);
            v0 = ret$iv;
        }
        return v0;
    }

    private static final Boolean isListening$lambda$34(JsonParser it) {
        return (Boolean)it.readValueAs(Boolean.TYPE);
    }

    private static final Long getPeerCount$lambda$35(JsonParser it) {
        return JsonParserExtensionsKt.readHexLong((JsonParser)it);
    }
}

