/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.ens;

import io.ethers.core.types.Bytes;
import io.ethers.crypto.Hashing;
import io.ethers.ens.NameHashKt;
import io.github.adraffy.ens.ENSNormalize;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u001e\u0010\u0007\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lio/ethers/ens/NameHash;", "", "()V", "dnsEncode", "Lio/ethers/core/types/Bytes;", "name", "", "nameHash", "", "ensName", "labels", "", "index", "", "ethers-ens"})
public final class NameHash {
    @NotNull
    public static final NameHash INSTANCE = new NameHash();

    private NameHash() {
    }

    @NotNull
    public final byte[] nameHash(@NotNull String ensName) {
        String[] stringArray = new String[]{"."};
        return this.nameHash(StringsKt.split$default((CharSequence)ENSNormalize.ENSIP15.normalize(ensName), (String[])stringArray, (boolean)false, (int)0, (int)6, null), 0);
    }

    private final byte[] nameHash(List<String> labels, int index) {
        byte[] byArray;
        if (index >= labels.size() || Intrinsics.areEqual((Object)labels.get(index), (Object)"")) {
            byArray = NameHashKt.access$getEMPTY_BYTE_ARRAY$p();
        } else {
            byte[] remainderHash = this.nameHash(labels, index + 1);
            byte[] result = new byte[64];
            System.arraycopy(remainderHash, 0, result, 0, remainderHash.length);
            byte[] byArray2 = labels.get(index).getBytes(StandardCharsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            byte[] labelHash = Hashing.keccak256((byte[])byArray2);
            System.arraycopy(labelHash, 0, result, 32, labelHash.length);
            byArray = Hashing.keccak256((byte[])result);
        }
        return byArray;
    }

    @NotNull
    public final Bytes dnsEncode(@NotNull String name) {
        String[] stringArray = new String[]{"."};
        List parts = StringsKt.split$default((CharSequence)name, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        for (String part : parts) {
            String normalized = ENSNormalize.ENSIP15.normalize(part);
            stream.write(normalized.length());
            byte[] byArray = normalized.getBytes(StandardCharsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            stream.write(byArray);
        }
        stream.write(0);
        return new Bytes(stream.toByteArray());
    }
}

