/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.abi.call;

import io.ethers.abi.error.ContractError;
import io.ethers.abi.error.ContractRpcError;
import io.ethers.abi.error.DecodingError;
import io.ethers.abi.error.RevertError;
import io.ethers.core.FastHex;
import io.ethers.core.Result;
import io.ethers.core.ResultKt;
import io.ethers.core.types.AccessList;
import io.ethers.core.types.AccountOverride;
import io.ethers.core.types.Address;
import io.ethers.core.types.BlockId;
import io.ethers.core.types.BlockOverride;
import io.ethers.core.types.Bytes;
import io.ethers.core.types.CallRequest;
import io.ethers.core.types.tracers.TracerConfig;
import io.ethers.providers.RpcError;
import io.ethers.providers.middleware.Middleware;
import io.ethers.providers.types.RpcRequest;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0014\b\u0001\u0010\u0002*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00002\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001b\u0010\n\u001a\u00028\u00012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\u0002\u00103J@\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u000205042\u0006\u00106\u001a\u0002072\u0016\b\u0002\u00108\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020:\u0018\u0001092\n\b\u0002\u0010;\u001a\u0004\u0018\u00010<H\u0007J\u0015\u0010\u0014\u001a\u00028\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0002\u0010=J\u0013\u0010\u001a\u001a\u00028\u00012\u0006\u0010\u0007\u001a\u00020\u0019\u00a2\u0006\u0002\u0010>J\u0015\u0010 \u001a\u00028\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0002\u0010?J\u0015\u0010%\u001a\u00028\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0002\u0010?J\u0015\u0010(\u001a\u00028\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0002\u0010?J\u001c\u0010@\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002050A2\u0006\u0010B\u001a\u00020CH$J\u0013\u0010+\u001a\u00028\u00012\u0006\u0010\u0007\u001a\u00020\u0019\u00a2\u0006\u0002\u0010>J\u001c\u0010D\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002050A2\u0006\u0010B\u001a\u00020CH\u0002J.\u0010E\u001a\u000e\u0012\u0004\u0012\u0002HF\u0012\u0004\u0012\u00020G04\"\u0004\b\u0002\u0010F2\u0006\u00106\u001a\u0002072\f\u0010H\u001a\b\u0012\u0004\u0012\u0002HF0IJ\u0010\u0010J\u001a\u0002052\u0006\u0010K\u001a\u00020GH\u0002R4\u0010\n\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R(\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0007\u001a\u0004\u0018\u00010\u00138F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR(\u0010 \u001a\u0004\u0018\u00010\u001f2\b\u0010\u0007\u001a\u0004\u0018\u00010\u001f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R(\u0010%\u001a\u0004\u0018\u00010\u001f2\b\u0010\u0007\u001a\u0004\u0018\u00010\u001f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010\"\"\u0004\b'\u0010$R(\u0010(\u001a\u0004\u0018\u00010\u001f2\b\u0010\u0007\u001a\u0004\u0018\u00010\u001f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010\"\"\u0004\b*\u0010$R$\u0010+\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010\u001c\"\u0004\b-\u0010\u001eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0012\u00100\u001a\u00028\u0001X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u0006L"}, d2={"Lio/ethers/abi/call/ReadContractCall;", "C", "B", "", "provider", "Lio/ethers/providers/middleware/Middleware;", "(Lio/ethers/providers/middleware/Middleware;)V", "value", "", "Lio/ethers/core/types/AccessList$Item;", "accessList", "getAccessList", "()Ljava/util/List;", "setAccessList", "(Ljava/util/List;)V", "call", "Lio/ethers/core/types/CallRequest;", "getCall", "()Lio/ethers/core/types/CallRequest;", "Lio/ethers/core/types/Address;", "from", "getFrom", "()Lio/ethers/core/types/Address;", "setFrom", "(Lio/ethers/core/types/Address;)V", "", "gas", "getGas", "()J", "setGas", "(J)V", "Ljava/math/BigInteger;", "gasFeeCap", "getGasFeeCap", "()Ljava/math/BigInteger;", "setGasFeeCap", "(Ljava/math/BigInteger;)V", "gasPrice", "getGasPrice", "setGasPrice", "gasTipCap", "getGasTipCap", "setGasTipCap", "nonce", "getNonce", "setNonce", "getProvider", "()Lio/ethers/providers/middleware/Middleware;", "self", "getSelf", "()Lio/ethers/abi/call/ReadContractCall;", "(Ljava/util/List;)Lio/ethers/abi/call/ReadContractCall;", "Lio/ethers/providers/types/RpcRequest;", "Lio/ethers/abi/error/ContractError;", "blockId", "Lio/ethers/core/types/BlockId;", "stateOverride", "", "Lio/ethers/core/types/AccountOverride;", "blockOverride", "Lio/ethers/core/types/BlockOverride;", "(Lio/ethers/core/types/Address;)Lio/ethers/abi/call/ReadContractCall;", "(J)Lio/ethers/abi/call/ReadContractCall;", "(Ljava/math/BigInteger;)Lio/ethers/abi/call/ReadContractCall;", "handleCallResult", "Lio/ethers/core/Result;", "result", "Lio/ethers/core/types/Bytes;", "safelyHandleCallResult", "traceCall", "T", "Lio/ethers/providers/RpcError;", "config", "Lio/ethers/core/types/tracers/TracerConfig;", "tryDecodingContractRevert", "err", "ethers-abi"})
@SourceDebugExtension(value={"SMAP\nContractCall.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContractCall.kt\nio/ethers/abi/call/ReadContractCall\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,265:1\n1#2:266\n*E\n"})
public abstract class ReadContractCall<C, B extends ReadContractCall<C, B>> {
    @NotNull
    private final Middleware provider;
    @NotNull
    private final CallRequest call;

    /*
     * WARNING - void declaration
     */
    public ReadContractCall(@NotNull Middleware provider) {
        void $this$call_u24lambda_u240;
        CallRequest callRequest;
        this.provider = provider;
        CallRequest callRequest2 = callRequest = new CallRequest();
        ReadContractCall readContractCall = this;
        boolean bl = false;
        $this$call_u24lambda_u240.setChainId(this.provider.getChainId());
        readContractCall.call = callRequest;
    }

    @NotNull
    protected final Middleware getProvider() {
        return this.provider;
    }

    @NotNull
    protected final CallRequest getCall() {
        return this.call;
    }

    @JvmOverloads
    @NotNull
    public final RpcRequest<C, ContractError> call(@NotNull BlockId blockId, @Nullable Map<Address, AccountOverride> stateOverride, @Nullable BlockOverride blockOverride) {
        return this.provider.call(this.call, blockId, stateOverride, blockOverride).mapError(new Result.Transformer(this){
            final /* synthetic */ ReadContractCall<C, B> $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            @NotNull
            public final ContractError invoke(@NotNull RpcError p0) {
                return ReadContractCall.access$tryDecodingContractRevert(this.$tmp0, p0);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, this.$tmp0, ReadContractCall.class, "tryDecodingContractRevert", "tryDecodingContractRevert(Lio/ethers/providers/RpcError;)Lio/ethers/abi/error/ContractError;", 0);
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof Result.Transformer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        }).andThen(new Result.Transformer(this){
            final /* synthetic */ ReadContractCall<C, B> $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            @NotNull
            public final Result<C, ContractError> invoke(@NotNull Bytes p0) {
                return ReadContractCall.access$safelyHandleCallResult(this.$tmp0, p0);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, this.$tmp0, ReadContractCall.class, "safelyHandleCallResult", "safelyHandleCallResult(Lio/ethers/core/types/Bytes;)Lio/ethers/core/Result;", 0);
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof Result.Transformer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        });
    }

    public static /* synthetic */ RpcRequest call$default(ReadContractCall readContractCall, BlockId blockId, Map map, BlockOverride blockOverride, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: call");
        }
        if ((n & 2) != 0) {
            map = null;
        }
        if ((n & 4) != 0) {
            blockOverride = null;
        }
        return readContractCall.call(blockId, map, blockOverride);
    }

    @NotNull
    public final <T> RpcRequest<T, RpcError> traceCall(@NotNull BlockId blockId, @NotNull TracerConfig<T> config) {
        return this.provider.traceCall(this.call, blockId, config);
    }

    private final Result<C, ContractError> safelyHandleCallResult(Bytes result) {
        Result result2;
        try {
            result2 = this.handleCallResult(result);
        }
        catch (Exception e) {
            result2 = ResultKt.failure((Result.Error)new DecodingError(result, e));
        }
        return result2;
    }

    private final ContractError tryDecodingContractRevert(RpcError err) {
        if (err.isExecutionError() && err.getData() != null) {
            String string = err.getData();
            Intrinsics.checkNotNull((Object)string);
            if (!FastHex.isValidHex((CharSequence)string)) {
                String string2 = err.getData();
                Intrinsics.checkNotNull((Object)string2);
                return new RevertError(string2);
            }
            String string3 = err.getData();
            Intrinsics.checkNotNull((Object)string3);
            ContractError contractError = ContractError.Companion.getOrNull(new Bytes((CharSequence)string3));
            if (contractError != null) {
                return contractError;
            }
        }
        return new ContractRpcError(err);
    }

    @NotNull
    protected abstract B getSelf();

    @NotNull
    protected abstract Result<C, ContractError> handleCallResult(@NotNull Bytes var1);

    @Nullable
    public final Address getFrom() {
        return this.call.getFrom();
    }

    public final /* synthetic */ void setFrom(Address value) {
        this.call.setFrom(value);
    }

    public final long getGas() {
        return this.call.getGas();
    }

    public final /* synthetic */ void setGas(long value) {
        this.call.setGas(value);
    }

    @Nullable
    public final BigInteger getGasPrice() {
        return this.call.getGasPrice();
    }

    public final /* synthetic */ void setGasPrice(BigInteger value) {
        this.call.setGasPrice(value);
    }

    @Nullable
    public final BigInteger getGasFeeCap() {
        return this.call.getGasFeeCap();
    }

    public final /* synthetic */ void setGasFeeCap(BigInteger value) {
        this.call.setGasFeeCap(value);
    }

    @Nullable
    public final BigInteger getGasTipCap() {
        return this.call.getGasTipCap();
    }

    public final /* synthetic */ void setGasTipCap(BigInteger value) {
        this.call.setGasTipCap(value);
    }

    public final long getNonce() {
        return this.call.getNonce();
    }

    public final /* synthetic */ void setNonce(long value) {
        this.call.setNonce(value);
    }

    @Nullable
    public final List<AccessList.Item> getAccessList() {
        return this.call.getAccessList();
    }

    public final /* synthetic */ void setAccessList(List value) {
        this.call.setAccessList(value);
    }

    @NotNull
    public final B from(@Nullable Address value) {
        this.call.setFrom(value);
        return this.getSelf();
    }

    @NotNull
    public final B gas(long value) {
        this.call.setGas(value);
        return this.getSelf();
    }

    @NotNull
    public final B gasPrice(@Nullable BigInteger value) {
        this.call.setGasPrice(value);
        return this.getSelf();
    }

    @NotNull
    public final B gasFeeCap(@Nullable BigInteger value) {
        this.call.setGasFeeCap(value);
        return this.getSelf();
    }

    @NotNull
    public final B gasTipCap(@Nullable BigInteger value) {
        this.call.setGasTipCap(value);
        return this.getSelf();
    }

    @NotNull
    public final B nonce(long value) {
        this.call.setNonce(value);
        return this.getSelf();
    }

    @NotNull
    public final B accessList(@Nullable List<AccessList.Item> value) {
        this.call.setAccessList(value);
        return this.getSelf();
    }

    @JvmOverloads
    @NotNull
    public final RpcRequest<C, ContractError> call(@NotNull BlockId blockId, @Nullable Map<Address, AccountOverride> stateOverride) {
        return ReadContractCall.call$default(this, blockId, stateOverride, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final RpcRequest<C, ContractError> call(@NotNull BlockId blockId) {
        return ReadContractCall.call$default(this, blockId, null, null, 6, null);
    }

    public static final /* synthetic */ ContractError access$tryDecodingContractRevert(ReadContractCall $this, RpcError err) {
        return $this.tryDecodingContractRevert(err);
    }

    public static final /* synthetic */ Result access$safelyHandleCallResult(ReadContractCall $this, Bytes result) {
        return $this.safelyHandleCallResult(result);
    }
}

