/*
 * Decompiled with CFR 0.152.
 */
package com.ypz.bangscreentools;

import android.content.Context;
import android.graphics.Rect;
import android.support.annotation.RequiresApi;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Window;
import com.ypz.bangscreentools.BangScreenSupport;
import java.util.ArrayList;
import java.util.List;

public class OppoBangScreen
implements BangScreenSupport {
    @Override
    @RequiresApi(api=26)
    public boolean hasNotBangScreen(Window window) {
        if (window == null) {
            return false;
        }
        return window.getContext().getPackageManager().hasSystemFeature("com.oppo.feature.screen.heteromorphism");
    }

    @Override
    @RequiresApi(api=26)
    public List<Rect> getBangSize(Window window) {
        ArrayList<Rect> result = new ArrayList<Rect>();
        if (window == null) {
            return result;
        }
        DisplayMetrics displayMetrics = window.getContext().getResources().getDisplayMetrics();
        Rect rect = new Rect();
        int width = 324;
        int height = 80;
        rect.left = (displayMetrics.widthPixels - width) / 2;
        rect.right = rect.left + width;
        rect.bottom = height;
        rect.top = 0;
        result.add(rect);
        return result;
    }

    @Override
    @RequiresApi(api=26)
    public void extendStatusCutout(Window window, Context context) {
        if (window == null) {
            return;
        }
        Log.i((String)"BangScreenTools", (String)"next");
    }

    @Override
    @RequiresApi(api=26)
    public void setWindowLayoutBlockNotch(Window window) {
        if (window == null) {
            return;
        }
        window.clearFlags(1024);
        window.clearFlags(0x4000000);
        int systemUiVisibility = window.getDecorView().getSystemUiVisibility();
        systemUiVisibility &= 0x400;
        window.getDecorView().setSystemUiVisibility(systemUiVisibility &= 0x100);
    }

    @Override
    public void transparentStatusCutout(Window window, Context context) {
    }

    @Override
    public void fullscreen(Window window, Context context) {
    }
}

