/*
 * Decompiled with CFR 0.152.
 */
package com.kennyc.bottomsheet.menu;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.SubMenu;
import androidx.annotation.DrawableRes;
import androidx.annotation.StringRes;
import androidx.core.content.res.ResourcesCompat;
import com.kennyc.bottomsheet.menu.BottomSheetMenuItem;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u00002\u00020\u0001:\u0001<B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J[\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00102\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J*\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J*\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020!H\u0016J\u0010\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u0010H\u0016J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0010H\u0002J\u001a\u0010&\u001a\u0004\u0018\u00010\t2\u0006\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020\u0010H\u0016J\b\u0010,\u001a\u00020\u0006H\u0016J\u0018\u0010-\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010.\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0010H\u0016J \u0010/\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001b\u001a\u00020\u0010H\u0016J\u0010\u00100\u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u00101\u001a\u00020!2\u0006\u0010$\u001a\u00020\u0010H\u0016J \u00102\u001a\u00020!2\u0006\u00103\u001a\u00020\u00102\u0006\u00104\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u0006H\u0016J\u0018\u00106\u001a\u00020!2\u0006\u00103\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u0006H\u0016J\u0018\u00108\u001a\u00020!2\u0006\u00103\u001a\u00020\u00102\u0006\u00109\u001a\u00020\u0006H\u0016J\u0010\u0010:\u001a\u00020!2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010;\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/kennyc/bottomsheet/menu/BottomSheetMenu;", "Landroid/view/Menu;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "isQwerty", "", "items", "Ljava/util/ArrayList;", "Lcom/kennyc/bottomsheet/menu/BottomSheetMenuItem;", "Lkotlin/collections/ArrayList;", "add", "Landroid/view/MenuItem;", "title", "", "titleRes", "", "groupId", "itemId", "order", "addIntentOptions", "caller", "Landroid/content/ComponentName;", "specifics", "", "Landroid/content/Intent;", "intent", "flags", "outSpecificItems", "(IIILandroid/content/ComponentName;[Landroid/content/Intent;Landroid/content/Intent;I[Landroid/view/MenuItem;)I", "addSubMenu", "Landroid/view/SubMenu;", "clear", "", "close", "findItem", "id", "findItemIndex", "findItemWithShortcut", "keyCode", "event", "Landroid/view/KeyEvent;", "getItem", "index", "hasVisibleItems", "isShortcutKey", "performIdentifierAction", "performShortcut", "removeGroup", "removeItem", "setGroupCheckable", "group", "checkable", "exclusive", "setGroupEnabled", "enabled", "setGroupVisible", "visible", "setQwertyMode", "size", "MenuItemBuilder", "library_release"})
public final class BottomSheetMenu
implements Menu {
    @NotNull
    private final Context context;
    private boolean isQwerty;
    @NotNull
    private final ArrayList<BottomSheetMenuItem> items;

    public BottomSheetMenu(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.items = new ArrayList();
    }

    @NotNull
    public MenuItem add(@NotNull CharSequence title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        return this.add(0, 0, 0, title);
    }

    @NotNull
    public MenuItem add(int titleRes) {
        return this.add(0, 0, 0, titleRes);
    }

    @NotNull
    public MenuItem add(int groupId, int itemId, int order, int titleRes) {
        String string = this.context.getResources().getString(titleRes);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.resources.getString(titleRes)");
        return this.add(groupId, itemId, order, string);
    }

    @NotNull
    public MenuItem add(int groupId, int itemId, int order, @NotNull CharSequence title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        BottomSheetMenuItem item = new BottomSheetMenuItem(this.context, groupId, itemId, 0, order, title);
        this.items.add(item);
        return item;
    }

    public int addIntentOptions(int groupId, int itemId, int order, @NotNull ComponentName caller, @NotNull Intent[] specifics, @NotNull Intent intent, int flags, @Nullable MenuItem[] outSpecificItems) {
        int n;
        Intrinsics.checkNotNullParameter((Object)caller, (String)"caller");
        Intrinsics.checkNotNullParameter((Object)specifics, (String)"specifics");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        PackageManager pm = this.context.getPackageManager();
        List list = pm.queryIntentActivityOptions(caller, specifics, intent, 0);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"pm.queryIntentActivityOptions(caller, specifics, intent, 0)");
        List lri = list;
        int size = lri.size();
        if ((flags & 1) == 0) {
            this.removeGroup(groupId);
        }
        if ((n = 0) < size) {
            do {
                int i = n++;
                ResolveInfo ri = (ResolveInfo)lri.get(i);
                Intent rintent = new Intent(ri.specificIndex < 0 ? intent : specifics[ri.specificIndex]);
                rintent.setComponent(new ComponentName(ri.activityInfo.applicationInfo.packageName, ri.activityInfo.name));
                CharSequence charSequence = ri.loadLabel(pm);
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"ri.loadLabel(pm)");
                MenuItem item = this.add(groupId, itemId, order, charSequence).setIcon(ri.loadIcon(pm)).setIntent(rintent);
                if (outSpecificItems == null || ri.specificIndex < 0) continue;
                int n2 = ri.specificIndex;
                Intrinsics.checkNotNullExpressionValue((Object)item, (String)"item");
                outSpecificItems[n2] = item;
            } while (n < size);
        }
        return size;
    }

    @Nullable
    public SubMenu addSubMenu(@NotNull CharSequence title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        throw new UnsupportedOperationException("Not Supported");
    }

    @Nullable
    public SubMenu addSubMenu(int titleRes) {
        throw new UnsupportedOperationException("Not Supported");
    }

    @Nullable
    public SubMenu addSubMenu(int groupId, int itemId, int order, @NotNull CharSequence title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        throw new UnsupportedOperationException("Not Supported");
    }

    @Nullable
    public SubMenu addSubMenu(int groupId, int itemId, int order, int titleRes) {
        throw new UnsupportedOperationException("Not Supported");
    }

    public void clear() {
        this.items.clear();
    }

    public void close() {
    }

    private final int findItemIndex(int id2) {
        int n = 0;
        int itemCount = this.items.size();
        if (n < itemCount) {
            do {
                int i;
                if (this.items.get(i = n++).getItemId() != id2) continue;
                return i;
            } while (n < itemCount);
        }
        return -1;
    }

    @NotNull
    public MenuItem findItem(int id2) {
        BottomSheetMenuItem bottomSheetMenuItem = this.items.get(this.findItemIndex(id2));
        Intrinsics.checkNotNullExpressionValue((Object)bottomSheetMenuItem, (String)"items[findItemIndex(id)]");
        return bottomSheetMenuItem;
    }

    @NotNull
    public MenuItem getItem(int index) {
        BottomSheetMenuItem bottomSheetMenuItem = this.items.get(index);
        Intrinsics.checkNotNullExpressionValue((Object)bottomSheetMenuItem, (String)"items[index]");
        return bottomSheetMenuItem;
    }

    public boolean hasVisibleItems() {
        int n = 0;
        int itemCount = this.items.size();
        if (n < itemCount) {
            do {
                int i;
                if (!this.items.get(i = n++).isVisible()) continue;
                return true;
            } while (n < itemCount);
        }
        return false;
    }

    private final BottomSheetMenuItem findItemWithShortcut(int keyCode, KeyEvent event) {
        boolean qwerty = this.isQwerty;
        int n = 0;
        int itemCount = this.items.size();
        if (n < itemCount) {
            do {
                char shortcut;
                int i = n++;
                BottomSheetMenuItem bottomSheetMenuItem = this.items.get(i);
                Intrinsics.checkNotNullExpressionValue((Object)bottomSheetMenuItem, (String)"items[i]");
                BottomSheetMenuItem item = bottomSheetMenuItem;
                char c = shortcut = qwerty ? item.getAlphabeticShortcut() : item.getNumericShortcut();
                if (keyCode != shortcut) continue;
                return item;
            } while (n < itemCount);
        }
        return null;
    }

    public boolean isShortcutKey(int keyCode, @NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return this.findItemWithShortcut(keyCode, event) != null;
    }

    public boolean performIdentifierAction(int id2, int flags) {
        int index = this.findItemIndex(id2);
        return index < 0 ? false : this.items.get(index).invoke();
    }

    public boolean performShortcut(int keyCode, @NotNull KeyEvent event, int flags) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        BottomSheetMenuItem bottomSheetMenuItem = this.findItemWithShortcut(keyCode, event);
        if (bottomSheetMenuItem == null) {
            return false;
        }
        BottomSheetMenuItem item = bottomSheetMenuItem;
        return item.invoke();
    }

    public void removeGroup(int groupId) {
        int itemCount = this.items.size();
        int i = 0;
        while (i < itemCount) {
            int n;
            if (this.items.get(i).getGroupId() == groupId) {
                this.items.remove(i);
                n = itemCount;
                itemCount = n + -1;
                continue;
            }
            n = i;
            i = n + 1;
        }
    }

    public void removeItem(int id2) {
        this.items.remove(this.findItemIndex(id2));
    }

    public void setGroupCheckable(int group, boolean checkable, boolean exclusive) {
        int n = 0;
        int itemCount = this.items.size();
        if (n < itemCount) {
            do {
                int i = n++;
                BottomSheetMenuItem bottomSheetMenuItem = this.items.get(i);
                Intrinsics.checkNotNullExpressionValue((Object)bottomSheetMenuItem, (String)"items[i]");
                BottomSheetMenuItem item = bottomSheetMenuItem;
                if (item.getGroupId() != group) continue;
                item.setCheckable(checkable);
                item.setExclusiveCheckable(exclusive);
            } while (n < itemCount);
        }
    }

    public void setGroupEnabled(int group, boolean enabled) {
        int n = 0;
        int itemCount = this.items.size();
        if (n < itemCount) {
            do {
                int i = n++;
                BottomSheetMenuItem bottomSheetMenuItem = this.items.get(i);
                Intrinsics.checkNotNullExpressionValue((Object)bottomSheetMenuItem, (String)"items[i]");
                BottomSheetMenuItem item = bottomSheetMenuItem;
                if (item.getGroupId() != group) continue;
                item.setEnabled(enabled);
            } while (n < itemCount);
        }
    }

    public void setGroupVisible(int group, boolean visible) {
        int n = 0;
        int itemCount = this.items.size();
        if (n < itemCount) {
            do {
                int i = n++;
                BottomSheetMenuItem bottomSheetMenuItem = this.items.get(i);
                Intrinsics.checkNotNullExpressionValue((Object)bottomSheetMenuItem, (String)"items[i]");
                BottomSheetMenuItem item = bottomSheetMenuItem;
                if (item.getGroupId() != group) continue;
                item.setVisible(visible);
            } while (n < itemCount);
        }
    }

    public void setQwertyMode(boolean isQwerty) {
        this.isQwerty = isQwerty;
    }

    public int size() {
        return this.items.size();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0010\u0010\u0014\u001a\u00020\u00002\b\b\u0001\u0010\b\u001a\u00020\u0005J\u0010\u0010\u0015\u001a\u00020\u00002\b\b\u0001\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lcom/kennyc/bottomsheet/menu/BottomSheetMenu$MenuItemBuilder;", "", "context", "Landroid/content/Context;", "id", "", "title", "", "icon", "Landroid/graphics/drawable/Drawable;", "(Landroid/content/Context;ILjava/lang/String;Landroid/graphics/drawable/Drawable;)V", "<set-?>", "getIcon", "()Landroid/graphics/drawable/Drawable;", "getId", "()I", "getTitle", "()Ljava/lang/String;", "build", "Landroid/view/MenuItem;", "setIcon", "setTitle", "library_release"})
    public static final class MenuItemBuilder {
        @NotNull
        private final Context context;
        @NotNull
        private String title;
        @Nullable
        private Drawable icon;
        private int id;

        public MenuItemBuilder(@NotNull Context context, int id2, @NotNull String title, @Nullable Drawable icon) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            this.context = context;
            this.title = title;
            this.icon = icon;
            this.id = id2;
        }

        public /* synthetic */ MenuItemBuilder(Context context, int n, String string, Drawable drawable, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                string = "NULL";
            }
            if ((n2 & 8) != 0) {
                drawable = null;
            }
            this(context, n, string, drawable);
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        @Nullable
        public final Drawable getIcon() {
            return this.icon;
        }

        public final int getId() {
            return this.id;
        }

        @NotNull
        public final MenuItemBuilder setTitle(@StringRes int title) {
            String string = this.context.getString(title);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.getString(title)");
            return this.setTitle(string);
        }

        @NotNull
        public final MenuItemBuilder setTitle(@NotNull String title) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            this.title = title;
            return this;
        }

        @NotNull
        public final MenuItemBuilder setIcon(@Nullable Drawable icon) {
            this.icon = icon;
            return this;
        }

        @NotNull
        public final MenuItemBuilder setIcon(@DrawableRes int icon) {
            return this.setIcon(ResourcesCompat.getDrawable((Resources)this.context.getResources(), (int)icon, (Resources.Theme)this.context.getTheme()));
        }

        @NotNull
        public final MenuItem build() {
            return new BottomSheetMenuItem(this.context, this.id, (CharSequence)this.title, this.icon);
        }
    }
}

