/*
 * Decompiled with CFR 0.152.
 */
package com.kennyc.bottomsheet.adapters;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.kennyc.bottomsheet.R;
import com.kennyc.bottomsheet.adapters.ViewHolder;
import java.util.List;

public class AppAdapter
extends BaseAdapter {
    List<AppInfo> mApps;
    private LayoutInflater mInflater;
    private int mTextColor;
    private int mLayoutResource;

    public AppAdapter(Context context, List<AppInfo> apps, boolean isGrid) {
        this.mApps = apps;
        this.mInflater = LayoutInflater.from((Context)context);
        this.mTextColor = context.getResources().getColor(R.color.black_85);
        this.mLayoutResource = isGrid ? R.layout.bottom_sheet_grid_item : R.layout.bottom_sheet_list_item;
    }

    public int getCount() {
        return this.mApps.size();
    }

    public AppInfo getItem(int position) {
        return this.mApps.get(position);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        AppInfo appInfo = this.getItem(position);
        if (convertView == null) {
            convertView = this.mInflater.inflate(this.mLayoutResource, parent, false);
            holder = new ViewHolder(convertView);
            holder.title.setTextColor(this.mTextColor);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        holder.icon.setImageDrawable(appInfo.drawable);
        holder.title.setText((CharSequence)appInfo.title);
        return convertView;
    }

    public static class AppInfo {
        public String title;
        public String packageName;
        public String name;
        public Drawable drawable;

        public AppInfo(String title, String packageName, String name, Drawable drawable) {
            this.title = title;
            this.packageName = packageName;
            this.name = name;
            this.drawable = drawable;
        }
    }
}

