/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.observer;

import java.util.ArrayList;
import java.util.List;

public class SensorSubject {
    private final List<SensorObserver> observers = new ArrayList<SensorObserver>();

    public void register(SensorObserver observer) {
        if (!this.observers.contains(observer)) {
            this.observers.add(observer);
        }
    }

    public void unregister(SensorObserver observer) {
        this.observers.remove(observer);
    }

    public void onNext(float[] values) {
        for (int i = 0; i < this.observers.size(); ++i) {
            this.observers.get(i).onSensorChanged(values);
        }
    }

    public static interface SensorObserver {
        public void onSensorChanged(float[] var1);
    }
}

