/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.filter.gyroscope.fusion.kalman;

import android.util.Log;
import com.kircherelectronics.fsensor.filter.gyroscope.fusion.OrientationFused;
import com.kircherelectronics.fsensor.filter.gyroscope.fusion.complementary.OrientationFusedComplementary;
import com.kircherelectronics.fsensor.filter.gyroscope.fusion.kalman.filter.RotationKalmanFilter;
import com.kircherelectronics.fsensor.filter.gyroscope.fusion.kalman.filter.RotationMeasurementModel;
import com.kircherelectronics.fsensor.filter.gyroscope.fusion.kalman.filter.RotationProcessModel;
import com.kircherelectronics.fsensor.util.angle.AngleUtils;
import com.kircherelectronics.fsensor.util.rotation.RotationUtil;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.math3.complex.Quaternion;

public class OrientationFusedKalman
extends OrientationFused {
    private static final String TAG = OrientationFusedComplementary.class.getSimpleName();
    private final RotationKalmanFilter kalmanFilter;
    private final AtomicBoolean run;
    private volatile float dT;
    private volatile float[] output = new float[3];
    private Thread thread;
    private volatile Quaternion rotationVectorAccelerationMagnetic;
    private final double[] vectorGyroscope = new double[4];
    private final double[] vectorAccelerationMagnetic = new double[4];

    public OrientationFusedKalman() {
        this(DEFAULT_TIME_CONSTANT);
    }

    public OrientationFusedKalman(float timeConstant) {
        super(timeConstant);
        this.run = new AtomicBoolean(false);
        this.kalmanFilter = new RotationKalmanFilter(new RotationProcessModel(), new RotationMeasurementModel());
    }

    public void startFusion() {
        if (!this.run.get() && this.thread == null) {
            this.run.set(true);
            this.thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (OrientationFusedKalman.this.run.get() && !Thread.interrupted()) {
                        OrientationFusedKalman.access$102(OrientationFusedKalman.this, OrientationFusedKalman.this.calculate());
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException e) {
                            Log.e((String)TAG, (String)"Kalman Thread", (Throwable)e);
                            Thread.currentThread().interrupt();
                        }
                    }
                    Thread.currentThread().interrupt();
                }
            });
            this.thread.start();
        }
    }

    public void stopFusion() {
        if (this.run.get() && this.thread != null) {
            this.run.set(false);
            this.thread.interrupt();
            this.thread = null;
        }
    }

    @Override
    public float[] getOutput() {
        return this.output;
    }

    private float[] calculate() {
        if (this.rotationVector != null && this.rotationVectorAccelerationMagnetic != null && this.dT != 0.0f) {
            this.vectorGyroscope[0] = (float)this.rotationVector.getVectorPart()[0];
            this.vectorGyroscope[1] = (float)this.rotationVector.getVectorPart()[1];
            this.vectorGyroscope[2] = (float)this.rotationVector.getVectorPart()[2];
            this.vectorGyroscope[3] = (float)this.rotationVector.getScalarPart();
            this.vectorAccelerationMagnetic[0] = (float)this.rotationVectorAccelerationMagnetic.getVectorPart()[0];
            this.vectorAccelerationMagnetic[1] = (float)this.rotationVectorAccelerationMagnetic.getVectorPart()[1];
            this.vectorAccelerationMagnetic[2] = (float)this.rotationVectorAccelerationMagnetic.getVectorPart()[2];
            this.vectorAccelerationMagnetic[3] = (float)this.rotationVectorAccelerationMagnetic.getScalarPart();
            this.kalmanFilter.predict(this.vectorGyroscope);
            this.kalmanFilter.correct(this.vectorAccelerationMagnetic);
            Quaternion result = new Quaternion(this.kalmanFilter.getStateEstimation()[3], Arrays.copyOfRange(this.kalmanFilter.getStateEstimation(), 0, 3));
            this.output = AngleUtils.getAngles(result.getQ0(), result.getQ1(), result.getQ2(), result.getQ3());
        }
        return this.output;
    }

    @Override
    public float[] calculateFusedOrientation(float[] gyroscope, long timestamp, float[] acceleration, float[] magnetic) {
        if (this.isBaseOrientationSet()) {
            if (this.timestamp != 0L) {
                this.dT = (float)(timestamp - this.timestamp) * 1.0E-9f;
                this.rotationVectorAccelerationMagnetic = RotationUtil.getOrientationVectorFromAccelerationMagnetic(acceleration, magnetic);
                this.rotationVector = RotationUtil.integrateGyroscopeRotation(this.rotationVector, gyroscope, this.dT, 1.0E-9f);
            }
            this.timestamp = timestamp;
            return this.output;
        }
        throw new IllegalStateException("You must call setBaseOrientation() before calling calculateFusedOrientation()!");
    }

    static /* synthetic */ float[] access$102(OrientationFusedKalman x0, float[] x1) {
        x0.output = x1;
        return x1;
    }
}

